const express = require('express');
const router = express.Router();
const brandController = require('../controllers/brandController');
const { verifyToken } = require('../middleware/role');
const apiLimiter = require('../middleware/apiLimiter');

router.post('/brands',verifyToken,apiLimiter, brandController.createBrand);
router.put('/brands',verifyToken, brandController.EditBrand);
router.get('/brands/:id', brandController.getBrandById);
router.get('/companies/:compId/brands',verifyToken,apiLimiter, brandController.getAllBrandsByCompany);
router.get('/companies/all-brands/sa',verifyToken,apiLimiter, brandController.getAllBrandsWithCompany);
router.get('/companies/brands/brands-assign',verifyToken, brandController.getAllBrandsAssignsforCompanyUsers);
router.get('/companies/:compId/brandnames', brandController.getAllBrandsNameByCompany);
router.get('/companies/brands/users-assign', brandController.getAllUsersforAssignBrand);
router.get('/companies/brands/users-assign-compulsory', brandController.getAllUsersforAssignBrandCompulosry);
router.put('/companies/brands/update-users-assign', brandController.updateUsersforAssignBrand);
router.put('/companies/brands/update-brand-assign', brandController.updateBrandsforAssignUsers);
router.put('/brands/:id', brandController.updateBrand);
router.patch('/brands/:id/enable', brandController.enableBrand);
router.patch('/brands/:id/disable', brandController.disableBrand);

module.exports = router;
