// routes/userRoutes.js
const express = require('express');
const router = express.Router();
const userController = require('../controllers/userController');
const { verifyToken } = require('../middleware/role');

router.post('/users', userController.createUser);
router.post('/update-profile', userController.updateProfile);
router.get('/profile-images', userController.GetExistingProfileImages);
router.post('/update-profile-password', userController.updateProfilePassword);
router.get('/get-profile/:user_id', userController.getProfile);
router.get('/users/:id', userController.findUserById);
router.post('/users/bycompany/:compId', userController.findUserByCompId);
router.get('/users/for_online_filter/:user_id', userController.getUsersRelatedToCompany);
router.get('/users', verifyToken,userController.getAllUsers);
// router.get('/users/compulsory', verifyToken,userController.getAllCompulsoryUsers);
router.put('/users/:id', userController.updateUser);
router.patch('/users/:id/status', userController.changeUserStatus);
router.get('/users/brand/:brandId', userController.getUsersByBrandId);

module.exports = router;
