const jwt = require('jsonwebtoken');
const db = require('./db'); // Import your database connection

const refreshToken = async (refreshToken) => {
  if (!refreshToken) {
    throw new Error("Refresh token is required");
  }

  try {
    // Verify the refresh token
    const decoded = jwt.verify(refreshToken, process.env.JWT_REFRESH_SECRET);

    // Check if the refresh token exists in the database
    const user = await db.query(
      `SELECT * FROM user_sessions WHERE user_id = ? AND refresh_token = ?`,
      [decoded.userId, refreshToken]
    );

    if (!user.length) {
      throw new Error("Invalid refresh token");
    }

    // Generate new access and refresh tokens
    const newAccessToken = jwt.sign(
      { userId: decoded.userId, role: decoded.role },
      process.env.JWT_SECRET,
      { expiresIn: '5m' }
    );

    const newRefreshToken = jwt.sign(
      { userId: decoded.userId, role: decoded.role },
      process.env.JWT_REFRESH_SECRET,
      { expiresIn: '10m' }
    );

    // Update the refresh token in the database
    await db.query(
      `
      UPDATE user_sessions 
      SET refresh_token = ? 
      WHERE user_id = ? AND refresh_token = ?
      `,
      [newRefreshToken, decoded.userId, refreshToken]
    );

    return { accessToken: newAccessToken, refreshToken: newRefreshToken };
  } catch (error) {
    console.error("Error refreshing token:", error);
    throw new Error("Token refresh failed");
  }
};

module.exports = refreshToken;
