// models/companyModel.js
const db = require('../config/database');
const { generateUniqueAlphanumericID } = require('../services/script-service/utils/uuidGenerator');

const createCompany = async (name, location,representative, status) => {
  try {
    const comp_pk =await generateUniqueAlphanumericID()
    const [result] = await db.query(
      'INSERT INTO companies (name, location,representative,comp_pk, created_at, status) VALUES (?, ?, ?, ?, NOW(), ?)',
      [name, location,representative,comp_pk, status]
    );
    return result;
  } catch (error) {
    console.error('Error creating company:', error);
    throw new Error('Database operation failed: createCompany');
  }
};

const findCompanyById = async (id) => {
  try {
    const [rows] = await db.query('SELECT * FROM companies WHERE id = ?', [id]);
    return rows[0];
  } catch (error) {
    console.error('Error finding company by ID:', error);
    throw new Error('Database operation failed: findCompanyById');
  }
};

const findAllCompanies = async () => {
  try {
    const [rows] = await db.query('SELECT * FROM companies');
    return rows;
  } catch (error) {
    console.error('Error finding all companies:', error);
    throw new Error('Database operation failed: findAllCompanies');
  }
};

const updateCompany = async (id, name, location, status,representative) => {
  try {
    const [result] = await db.query(
      'UPDATE companies SET name = ?, location = ?, status = ? ,representative = ? WHERE id = ?',
      [name, location, status, representative,id]
    );
    return result;
  } catch (error) {
    console.error('Error updating company:', error);
    throw new Error('Database operation failed: updateCompany');
  }
};

const enableCompany = async (id) => {
  try {
    const [result] = await db.query('UPDATE companies SET status = 1 WHERE id = ?', [id]);
    return result;
  } catch (error) {
    console.error('Error enabling company:', error);
    throw new Error('Database operation failed: enableCompany');
  }
};

const disableCompany = async (id) => {
  try {
    const [result] = await db.query('UPDATE companies SET status = 0 WHERE id = ?', [id]);
    return result;
  } catch (error) {
    console.error('Error disabling company:', error);
    throw new Error('Database operation failed: disableCompany');
  }
};

module.exports = { createCompany, findCompanyById, findAllCompanies, updateCompany, enableCompany, disableCompany };
