// routes/logoRoutes.js
const express = require('express');
const router = express.Router();
const getWebsiteLogo = require('../utils/fetchLogo');

router.get('/logo', async (req, res) => {
  const { url } = req.query;

  if (!url) {
    return res.status(400).json({ error: 'URL is required' });
  }

  try {
    const logoUrl = await getWebsiteLogo(url);
    res.json({ logoUrl });
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

module.exports = router;
