const express = require('express');
const router = express.Router();
const userController = require('../controllers/userController');
const { verifyToken } = require('../middleware/role');

router.post('/users', userController.createUser);
router.post('/update-profile', verifyToken, userController.updateProfile);
router.get('/profile-images', verifyToken, userController.GetExistingProfileImages);
router.post('/update-profile-password', verifyToken, userController.updateProfilePassword);
router.get('/get-profile/:userId', verifyToken, userController.getProfile);
router.get('/users/:id', verifyToken, userController.findUserById);
router.get('/users/by-company/:compId', verifyToken, userController.findUserByCompId);
router.get('/users/for-online-filter/:userId', verifyToken, userController.getUsersRelatedToCompany);
router.get('/users', verifyToken, userController.getAllUsers);
router.put('/users/:id', verifyToken, userController.updateUser);
router.patch('/users/:id/status', verifyToken, userController.changeUserStatus);
router.get('/users/brand/:brandId', verifyToken, userController.getUsersByBrandId);

module.exports = router;
