const { fetchTestRegister } = require('../models/testRegisterModel');
const CustomError = require('../utils/customErrors');

// Controller for test user registration
exports.testRegister = async (req, res, next) => {
  const {
    name,
    pseudonym,
    email,
    password,
    status,
    created_by,
    hrm_id,
    role_id,
    designation,
    company_id,
    canCreateUsers,
    canCreateBrand,
    team_lead,
  } = req.body;

  if (!name) return next(new CustomError(400, 'Name is required'));
  if (!email) return next(new CustomError(400, 'Email is required'));
  if (!password) return next(new CustomError(400, 'Password is required'));

  try {
    const result = await fetchTestRegister({
      name,
      pseudonym,
      email,
      password,
      status,
      created_by,
      hrm_id,
      role_id,
      designation,
      company_id,
      canCreateUsers,
      canCreateBrand,
      team_lead,
    });

    if (result.success) {
      res.status(201).json({
        message: 'Test user registered successfully',
        userId: result.userId,
      });
    } else {
      return next(new CustomError(500, result.error || 'Failed to register test user'));
    }
  } catch (error) {
    console.error('Test Register Error:', error);
    return next(new CustomError(500, 'An error occurred during registration'));
  }
};
