// controllers/companyController.js
const { encryptData } = require('../middleware/EncryptDecryptData');
const {
    createCompany,
    findCompanyById,
    findAllCompanies,
    updateCompany,
    enableCompany,
    disableCompany
  } = require('../models/companyModel');
  
  exports.createCompany = async (req, res) => {
    try {
        const { name, location,representative , statusId } = req.body;
        const result = await createCompany(name, location,representative, statusId);
        console.log(req.body)

      res.status(201).json({ message: 'Company created successfully', id: result.insertId });
    } catch (error) {
      res.status(500).json({ error: 'Error creating company' });
    }
  };
  
  exports.getCompanyById = async (req, res) => {
    try {
      const company = await findCompanyById(req.params.id);
      if (!company) return res.status(404).json({ message: 'Company not found' });
      res.json(encryptData(company));
    } catch (error) {
      res.status(500).json({ error: 'Error retrieving company' });
    }
  };
  
  exports.getAllCompanies = async (req, res) => {
    try {
      console.log("companiess");
      
      const companies = await findAllCompanies();
      res.json(encryptData(companies));
    } catch (error) {
      res.status(500).json({ error: 'Error retrieving companies' });
    }
  };
  
  exports.updateCompany = async (req, res) => {
    try {
      const { name, location, statusId,representative } = req.body;
      const result = await updateCompany(req.params.id, name, location, statusId,representative);
      if (result.affectedRows === 0) return res.status(404).json({ message: 'Company not found' });
      res.json({ message: 'Company updated successfully' });
    } catch (error) {
      res.status(500).json({ error: 'Error updating company' });
    }
  };
  
  exports.enableCompany = async (req, res) => {
    try {
      const result = await enableCompany(req.params.id);
      if (result.affectedRows === 0) return res.status(404).json({ message: 'Company not found' });
      res.json({ message: 'Company enabled successfully' });
    } catch (error) {
      res.status(500).json({ error: 'Error enabling company' });
    }
  };
  
  exports.disableCompany = async (req, res) => {
    try {
      const result = await disableCompany(req.params.id);
      if (result.affectedRows === 0) return res.status(404).json({ message: 'Company not found' });
      res.json({ message: 'Company disabled successfully' });
    } catch (error) {
      res.status(500).json({ error: 'Error disabling company' });
    }
  };
  