const db = require('../config/database');

// Function to check user session and delete other sessions if necessary
async function checkUserSession(userId, deviceId) {
  try {
    console.log("Original User ID:", userId);
    console.log("Device ID:", deviceId);

    // Query to check if the device_id already exists for this user
    const query = `SELECT * FROM user_sessions WHERE user_id = ? AND device_id = ? AND status = 1`;
    const [rows] = await db.query(query, [userId, deviceId]);

    if (rows.length > 0) {
      // If a session already exists for the user and device, return true
      return true;
    } else {
      return false; // Session does not exist, so it's safe to create a new one
    }
  } catch (error) {
    console.error('Error checking user session:', error);
    throw new Error('Error checking user session');
  }
}

module.exports = { checkUserSession };
