const db = require('../config/database'); // Make sure to import your database configuration

const chatRateModel = {
    getRatingBySessionId: async (sessionId) => {
        const query = `
            SELECT rating
            FROM chat_rate
            WHERE chat_id = ?;
        `;

        const [rows] = await db.query(query, [sessionId]);

        // Assuming there's only one rating per session_id
        return rows.length > 0 ? rows[0] : null; 
    }
};

module.exports = chatRateModel;
