const db = require('../config/database');
const bcrypt = require('bcryptjs');
const crypto = require('crypto');

exports. createTestRegister = async (data) => {
  try {
    if (!data || typeof data !== 'object') {
      throw new Error('Invalid data provided to fetchTestRegister');
    }
    const {
      name,
      pseudonym,
      email,
      password,
      hrm_id,
      role_id,
      designation,
      company_id,
      status,
      created_by,
      canCreateUsers,
      canCreateBrand,
      team_lead,
    } = data;
console.log(  name,
      pseudonym,
      email,
      password,
      hrm_id,
      role_id,
      designation,
      company_id,
      status,
      created_by,
      canCreateUsers,
      canCreateBrand,
      team_lead)
    const hashedPassword = await bcrypt.hash(password, 10);
    const chat_hash = hrm_id ? crypto.createHash('md5').update(hrm_id).digest('hex') : null;

    const [result] = await db.query(
      `INSERT INTO users
        (name, pseudonym, email, password, hrm_id, chat_hash, role_id, designation, company_id, status, created_by, canCreateUsers, canCreateBrand, team_lead, created_at)
       VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`,
      [
        name,
        pseudonym,
        email,
        hashedPassword,
        hrm_id,
        chat_hash,
        role_id,
        designation,
        company_id,
        status,
        created_by,
        canCreateUsers,
        canCreateBrand,
        team_lead
      ]
    );

    return { userId: result.insertId, success: true };
  } catch (error) {
    console.error('❌ Error creating test user:', error);
    return { success: false, error: error.message };
  }
};
