const express = require("express");
const { v4: uuidv4 } = require("uuid");
const mysql = require("mysql2");
const http = require("http");
const socketIo = require("socket.io");
const jwt = require("jsonwebtoken");
const geoip = require("geoip-lite"); // Import the geoip-lite library
const countries = require("countries-list").countries;
const app = express();
const PORT = process.env.PORT || 3002;
const fs = require("fs");
const path = require("path");
const https = require("https");
const cors = require("cors");
const bodyParser = require("body-parser");
const cookieParser = require("cookie-parser");
const errorHandler = require("./middleware/errorHandler");
app.use(cors());

// CORS Configuration (Allow credentials and dynamic origins)
// Enable CORS with a dynamic origin handler
// app.use(cors({
//   origin: function(origin, callback) {
//     // Allow all origins
//     callback(null, true); // Pass `true` to allow any origin
//   },
//   credentials: true,  // Allow cookies to be sent
//   methods: ['GET', 'POST', 'PUT', 'DELETE'],  // Allowed HTTP methods
// }));
app.use(cookieParser());

app.use(bodyParser.json());
// app.use((req, res, next) => {
//   res.header('Access-Control-Allow-Credentials', 'true');
//   res.header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
//   res.header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
//   next();
// });
const { checkUserSession } = require("./models/CheckUserSession.js");

require("dotenv").config();

// Create a connection to the MySQL database
const connection = mysql.createConnection({
  host: process.env.DB_HOST,
  user: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  port: process.env.DB_PORT,
  database: process.env.DB_DATABASE,
});

// Serve the static files
app.use(express.static("public"));

//socket.io for real time communication
app.get("/api/ip", (req, res) => {
  const forwarded = req.headers["x-forwarded-for"];
  const ip = forwarded
    ? forwarded.split(/, /)[0]
    : req.connection.remoteAddress;
  console.log();

  res.json({ ip });
});
// Load SSL certificate and key
const options = {
  key: fs.readFileSync(
    path.join(
      __dirname,
      "../../ssl/keys",
      "efc10_f9ec1_4329841e2b52e06014a467a840000e42.key"
    )
  ), // Replace with your key file
  cert: fs.readFileSync(
    path.join(
      __dirname,
      "../../ssl/certs",
      "v2_vchat_ourprojectdemo_com_efc10_f9ec1_1741688769_1defcb7fcdb42a548bbb2680f0db45d4.crt"
    )
  ), // Replace with your certificate file
};
// const options = {
//   key: fs.readFileSync(
//     path.join(
//       __dirname,
//       "../../ssl/keys",
//       "d7581_f6b6b_f02fa14ab248bd7df85d90e2118bc5d4.key"
//     )
//   ), // Replace with your key file
//   cert: fs.readFileSync(
//     path.join(
//       __dirname,
//       "../../ssl/certs",
//       "test_vchat_ourprojectdemo_com_d7581_f6b6b_1737122676_d8d5d785f0ba4b23c5e5ab8509873094.crt"
//     )
//   ), // Replace with your certificate file
// };

const server = https.createServer(options, app);
const io = new socketIo.Server(server, {
  cors: {
    origin: "*",
  },
});

const ADMIN_CONNECTION_LIMIT = 30;
const ADMIN_CONNECTION_WINDOW = 60000;
const CLIENT_CONNECTION_LIMIT = 30;
const CLIENT_CONNECTION_WINDOW = 30000;
const EMIT_LIMIT = 25;
const EMIT_WINDOW = 1000;

// Optimized storage using sliding window counters instead of arrays
const connectionAttempts = new Map();
const emitAttempts = new Map();
// const connectedClients = new Map(); // More efficient than object
const tokenCache = new Map();


// // Helper function to get admin socket by user_id

// Function to get brand_id from the public_key

const connectedClients = {}; // To keep track of connected clients

// io.use(async (socket, next) => {
//   const token = socket.handshake.auth.token;

//   if (!token) {
//     console.error("Authentication error: Token missing");
//     return next(new Error("Authentication error: Token missing"));
//   }

//   try {
//     jwt.verify(token, process.env.JWT_SECRET, async (err, decoded) => {
//       if (err) {
//         console.error("Authentication error: Invalid token", err);
//         console.error(decoded)
//         return next(new Error("Authentication error: Invalid token"));
//       }

//       try {

//         // Admin/Users logic
//         if (decoded.userId) {
//           const deviceId = socket.handshake.auth.device_id;
//           const user = await fetchuserRole(decoded.userId);
//           console.log('Token:', token);
// console.log('Device ID:', deviceId);
// console.log(' process.env.JWT_SECRET:',  process.env.JWT_SECRET);

//           if (!user) {
//             console.error("User not found for userId:", decoded.userId);
//             return next(new Error("User not found"));
//           }
//         const checkUser = await checkUserSession(decoded.userId,deviceId)
//         console.log("checkUser value:", checkUser, typeof checkUser);

//         console.log(checkUser);

//         if (!checkUser) {
//           console.error("User session not found for userId:", decoded.userId, deviceId);
//           socket.emit(
//             "Logged_in_to_other_device",
//             {
//                 user: decoded.user_id,
//                 message: "You have been logged out because you logged in on another device.",
//             }

//           )
//            // Disconnect the socket
//           //  socket.disconnect(true);

//           return next(new Error("User session not found"));
//         }
//           const userInfo = {
//             userId: decoded.userId,
//             role: user.role_id,
//             company_id: user.company_id,
//             name: user.pseudonym,
//           };
//           console.log(userInfo);

//           if ([1, 2, 3, 4].includes(userInfo.role)) {
//             socket.user = {
//               user_id: userInfo.userId,
//               name: userInfo.name,
//             };
//           } else {
//             console.error("Invalid user role:", userInfo.role);
//             return next(new Error("Invalid user role"));
//           }
//         }
//         // Client logic
//         else if (decoded.clientId && decoded.public_key) {

//           // Proceed with the new connection
//           socket.user = {
//             client_id: decoded.clientId,
//             public_key: decoded.public_key,
//           };
//            // Ensure the clientId exists in the object as an array
//   if (!connectedClients[decoded.clientId]) {
//     connectedClients[decoded.clientId] = [];
//   }
//           // Store the connected client
//       // Add the new socket.id to the array
//            connectedClients[decoded.clientId].push(socket.id);
//           console.log(`Client connected: ${decoded.clientId}`);
//         }
//         // Invalid token structure
//         else {
//           console.error("Client data missing in token:", decoded);
//           return next(new Error("Client data missing"));
//         }
//         socket.on('connect_error', (err) => {
//           console.error('Connection error:', err.message);
//         });
//         next();
//       } catch (fetchError) {
//         console.error("Error fetching user data:", fetchError);
//         return next(new Error("Error fetching user data"));
//       }
//     });

//   } catch (globalError) {
//     console.error("Unexpected error during authentication:", globalError);
//     next(new Error("Unexpected error during authentication"));
//   }
// });
// io.use(async (socket, next) => {
//   const token = socket.handshake.auth.token;

//   if (!token) {
//     console.error("Authentication error: Token missing");
//     return next(new Error("Authentication error: Token missing"));
//   }

//   try {
//     jwt.verify(token, process.env.JWT_SECRET, async (err, decoded) => {
//       if (err) {
//         console.error("Authentication error: Invalid token", err);
//         return next(new Error("Authentication error: Invalid token"));
//       }
      
//     const currentTime = Date.now();

    
//       try {
//         if (decoded.userId) {
//           const deviceId = socket.handshake.auth.device_id;
//           const user = await fetchuserRole(decoded.userId);

//           if (!user) {
//             console.error("User not found for userId:", decoded.userId);
//             return next(new Error("User not found"));
//           }
//           const checkUser = await checkUserSession(decoded.userId, deviceId);

//           if (!checkUser) {
//             console.error(
//               "User session not found for userId:",
//               decoded.userId,
//               deviceId
//             );

//             // Emit the event to notify the user
//             socket.emit("Logged_in_to_other_device", encryptData( {
//               user: decoded.userId,
//               message:
//                 "You have been logged out because you logged in on another device.",
//             }));

//             // Delay disconnection to ensure the event is sent
//             setTimeout(() => {
//               socket.disconnect(true);
//             }, 200);
//           }
//           // Proceed if the user session is valid
//           const userInfo = {
//             userId: decoded.userId,
//             role: user.role_id,
//             company_id: user.company_id,
//             name: user.pseudonym,
//           };
//           if (!connectionLimitMap.has(decoded.userId)) {
//             connectionLimitMap.set(decoded.userId, []);
//           }
      
//           const attempts = connectionLimitMap.get(decoded.userId);
//           const recentAttempts = attempts.filter((time) => currentTime - time < CONNECTION_WINDOW);
      
//           if (recentAttempts.length >= CONNECTION_LIMIT) {
//             return next(new Error("Rate limit exceeded for connections. Try again later."));
//           }
      
//           recentAttempts.push(currentTime);
//           connectionLimitMap.set(userId, recentAttempts);
      
      
//           if ([1, 2, 3, 4].includes(userInfo.role)) {
//             socket.user = {
//               user_id: userInfo.userId,
//               name: userInfo.name,
//             };
//           } else {
//             console.error("Invalid user role:", userInfo.role);
//             return next(new Error("Invalid user role"));
//           }
//         } else if (decoded.clientId && decoded.public_key) {
//           // Client logic
//           socket.user = {
//             client_id: decoded.clientId,
//             public_key: decoded.public_key,
//           };

//           if (!connectedClients[decoded.clientId]) {
//             connectedClients[decoded.clientId] = [];
//           }

//           connectedClients[decoded.clientId].push(socket.id);
//           console.log(`Client connected: ${decoded.clientId}`);
//         } else {
//           console.error("Client data missing in token:", decoded);
//           return next(new Error("Client data missing"));
//         }

//         next(); // Move to the next middleware only when all checks pass
//       } catch (fetchError) {
//         console.error("Error fetching user data:", fetchError);
//         next(new Error("Error fetching user data"));
//       }
//     });
//   } catch (globalError) {
//     console.error("Unexpected error during authentication:", globalError);
//     next(new Error("Unexpected error during authentication"));
//   }
// });
 
// Improved token verification with cache cleanup
async function verifyToken(token) {
    if (tokenCache.has(token)) {
        const { decoded, expires } = tokenCache.get(token);
        if (Date.now() < expires) return decoded;
    }

    return new Promise((resolve, reject) => {
        jwt.verify(token, process.env.JWT_SECRET, (err, decoded) => {
            if (err) return reject(err);
            tokenCache.set(token, {
                decoded,
                expires: Date.now() + 60000
            });
            resolve(decoded);
        });
    });
}

// Optimized rate limiter
function checkLimit(store, key, window, limit) {
    const currentTime = Date.now();
    const entry = store.get(key) || { count: 0, startTime: currentTime };

    // Reset counter if window has expired
    if (currentTime - entry.startTime > window) {
        entry.count = 0;
        entry.startTime = currentTime;
    }

    if (entry.count >= limit) return false;
    
    entry.count++;
    store.set(key, entry);
    return true;
}
// Periodic cleanup of stale data
// setInterval(() => {
//     const now = Date.now();
    
//     // Clean token cache
//     tokenCache.forEach((value, key) => {
//         if (now >= value.expires) tokenCache.delete(key);
//     });

//     // Clean connection attempts
//     connectionAttempts.forEach((value, key) => {
//         if (now - value.startTime > Math.max(ADMIN_CONNECTION_WINDOW, CLIENT_CONNECTION_WINDOW)) {
//             connectionAttempts.delete(key);
//         }
//     });

//     // Clean emit attempts
//     emitAttempts.forEach((value, key) => {
//         if (now - value.startTime > EMIT_WINDOW) {
//             emitAttempts.delete(key);
//         }
//     });
// }, 60000); // Run every 30 seconds

const CLEANUP_INTERVAL = 60000; // 1 minute
let cleanupInterval = setInterval(() => {
    const now = Date.now();

    if (tokenCache.size > 0) {
        for (const [key, value] of tokenCache) {
            if (now >= value.expires) tokenCache.delete(key);
        }
    }

    if (connectionAttempts.size > 0) {
        for (const [key, value] of connectionAttempts) {
            if (now - value.startTime > Math.max(ADMIN_CONNECTION_WINDOW, CLIENT_CONNECTION_WINDOW)) {
                connectionAttempts.delete(key);
            }
        }
    }

    if (emitAttempts.size > 0) {
        for (const [key, value] of emitAttempts) {
            if (now - value.startTime > EMIT_WINDOW) {
                emitAttempts.delete(key);
            }
        }
    }

}, CLEANUP_INTERVAL);

// Clear interval when shutting down
process.on("SIGINT", () => {
    clearInterval(cleanupInterval);
    console.log("Cleanup interval stopped.");
    process.exit();
});

// io.use(async (socket, next) => {
//     const token = socket.handshake.auth.token;
  
//     if (!token) {
//       console.error("Authentication error: Token missing");
//       return next(new Error("Authentication error: Token missing"));
//     }
  
//     try {
//     //   jwt.verify(token, process.env.JWT_SECRET, async (err, decoded) => {
//         // if (err) {
//         //   console.error("Authentication error: Invalid token", err);
//         //   return next(new Error("Authentication error: Invalid token"));
//         // }
//         let decoded;
//         try{

//              decoded = await verifyToken(token);
//         }
//         catch(err){
//             console.error("Authentication error: Invalid token", err);
//             return next(new Error("Authentication error: Invalid token"));
//         }
//         const currentTime = Date.now();
  
//         try {
//           if (decoded.userId) {
//             const deviceId = socket.handshake.auth.device_id;
//             const user = await fetchuserRole(decoded.userId);
  
//             if (!user) {
//               console.error("User not found for userId:", decoded.userId);
//               return next(new Error("User not found"));
//             }
  
//             const checkUser = await checkUserSession(decoded.userId, deviceId);
//             if (!checkUser) {
//               socket.emit(
//                 "Logged_in_to_other_device",
//                 encryptData({
//                   user: decoded.userId,
//                   message:
//                     "You have been logged out because you logged in on another device.",
//                 })
//               );
  
//               setTimeout(() => {
//                 socket.disconnect(true);
//               }, 200);
//               return;
//             }
  
//             const userInfo = {
//               userId: decoded.userId,
//               role: user.role_id,
//               company_id: user.company_id,
//               name: user.pseudonym,
//             };
  
//             // Apply Admin Rate Limiting
//             if ([1, 2, 3, 4].includes(userInfo.role)) {
//               socket.user = {
//                 user_id: userInfo.userId,
//                 name: userInfo.name,
//               };
  
//               const key = `admin_${userInfo.userId}`;
//               if (!connectionAttempts.has(key)) {
//                 connectionAttempts.set(key, []);
//               }
  
//               const attempts = connectionAttempts.get(key).filter(
//                 (time) => currentTime - time < ADMIN_CONNECTION_WINDOW
//               );
//               console.log(attempts,"attempts")
//               if (attempts.length >= ADMIN_CONNECTION_LIMIT) {
//                 console.error("Admin rate limit exceeded:", userInfo.userId);
//                 return next(new Error("Rate limit exceeded for admins. Try again later."));
//               }
//               console.log("connectionAttempts");
//               console.log(connectionAttempts);
              
//               attempts.push(currentTime);
//               connectionAttempts.set(key, attempts);
//             } else {
//               console.error("Invalid user role:", userInfo.role);
//               return next(new Error("Invalid user role"));
//             }
//           } else if (decoded.clientId && decoded.public_key) {
//             socket.user = {
//               client_id: decoded.clientId,
//               public_key: decoded.public_key,
//             };
  
//             if (!connectedClients[decoded.clientId]) {
//               connectedClients[decoded.clientId] = [];
//             }
  
//             connectedClients[decoded.clientId].push(socket.id);
//             console.log(`Client connected: ${decoded.clientId}`);
  
//             // Apply Client Rate Limiting
//             const key = `client_${decoded.clientId}`;
//             if (!connectionAttempts.has(key)) {
//               connectionAttempts.set(key, []);
//             }
  
//             const attempts = connectionAttempts.get(key).filter(
//               (time) => currentTime - time < CLIENT_CONNECTION_WINDOW
//             );
//             console.log(attempts,"attempts")
//             console.log(attempts.length)
//             if (attempts.length >= CLIENT_CONNECTION_LIMIT) {
//               console.error("Client rate limit exceeded:", decoded.clientId);
//               return next(new Error("Rate limit exceeded for clients. Try again later."));
//             }
//             console.log("connectionAttempts");
//             console.log(connectionAttempts);
//             attempts.push(currentTime);
//             connectionAttempts.set(key, attempts);
//           } else {
//             console.error("Client data missing in token:", decoded);
//             return next(new Error("Client data missing"));
//           }
  
//           next();
//         } catch (fetchError) {
//           console.error("Error fetching user data:", fetchError);
//           next(new Error("Error fetching user data"));
//         }
//     //   });
//     } catch (globalError) {
//       console.error("Unexpected error during authentication:", globalError);
//       next(new Error("Unexpected error during authentication"));
//     }
//   });
io.use(async (socket, next) => {
    try {
        const token = socket.handshake.auth.token;
        if (!token) throw new Error('Authentication error: Token missing');

        const decoded = await verifyToken(token);
        const currentTime = Date.now();

        if (decoded.userId) {
            const deviceId = socket.handshake.auth.device_id;
            const [user, validSession] = await Promise.all([
                fetchuserRole(decoded.userId),
                checkUserSession(decoded.userId, deviceId)
            ]);
            console.log('valid session :')
            console.log(validSession)
            if (!user) throw new Error('User not found');
            // if (!validSession) {
            //   console.log('logging out...')
            //   console.log('Socket connected:', socket.connected);
              
            //   // when user reconnect check is valid if not valid then been logout
            //     // socket.emit("Logged_in_to_other_device", encryptData({
            //     //     user: decoded.userId,
            //     //     message: "You have been logged out because you logged in on another device."
            //     // }));
            //     // setTimeout(() => socket.disconnect(true), 400);
            //     return;
            // }
            if (!validSession) {
              console.log('Socket connected:', socket.connected);

              // console.log('logging out...')
              //               socket.emit(
              //                 "Logged_in_to_other_device",
              //                 encryptData({
              //                   user: decoded.userId,
              //                   message:
              //                     "You have been logged out because you logged in on another device.",
              //                 })
              //               );
              next();
              setTimeout(() => {
                  socket.emit("Logged_in_to_other_device", encryptData({
                      user: decoded.userId,
                      message: "You have been logged out because you logged in on another device."
                  }));
                  socket.disconnect(true);
              }, 200);
              
                            // setTimeout(() => {
                            //   socket.disconnect(true);
                            // }, 200);
                            // return;
                          }
            const isAdmin = [1, 2, 3, 4].includes(user.role_id);
            const limitConfig = isAdmin ? {
                window: ADMIN_CONNECTION_WINDOW,
                limit: ADMIN_CONNECTION_LIMIT
            } : {
                window: CLIENT_CONNECTION_WINDOW,
                limit: CLIENT_CONNECTION_LIMIT
            };

            if (!checkLimit(connectionAttempts, decoded.userId, limitConfig.window, limitConfig.limit)) {
                throw new Error(`Rate limit exceeded. Try again later.`);
            }

            socket.user = {
                user_id: decoded.userId,
                name: user.pseudonym,
                role:user.role_id,
                type: isAdmin ? 'admin' : 'user'
            };
        } else if (decoded.clientId && decoded.public_key) {
            if (!checkLimit(connectionAttempts, `client_${decoded.clientId}`, 
                CLIENT_CONNECTION_WINDOW, CLIENT_CONNECTION_LIMIT)) {
                throw new Error('Client rate limit exceeded');
            }

            socket.user = {
                client_id: decoded.clientId,
                public_key: decoded.public_key,
                type: 'client'
            };

            // Update connected clients
            // const sockets = connectedClients.get(decoded.clientId) || new Set();
            // sockets.add(socket.id);
            if (!connectedClients[decoded.clientId]) {
                              connectedClients[decoded.clientId] = [];
                            }
                  
                            connectedClients[decoded.clientId].push(socket.id);
            // connectedClients.set(decoded.clientId, sockets);
        } else {
            throw new Error('Invalid token payload');
        }

        next();
    } catch (error) {
        console.error(error.message);
        next(new Error(error.message));
    }
});

const offlineAdminChats = {};
const adminSockets = {};
const connectDisconnect = {};
const disconnectedClients = {};
const visitorState = {}; // Store state for each client_id
const DISCONNECTIMEOUT = 1 * 30 * 1000;
const INACTIVITYT_IMEOUT = 10 * 60 * 1000;
const STATUS5TIMEOUT = 20 * 1000;
const notifyAssignedAdmins = (
  public_key,
  connection,
  adminSockets,
  emitEvent,
  emitData
) => {
  const assignedAdminsQuery = `
  SELECT 
      user_id 
  FROM 
      brand_assignees 
  WHERE 
      brand_id = (SELECT id FROM brands WHERE public_key = ?)
      AND status = 1
`;

  connection.query(assignedAdminsQuery, [public_key], (err, adminResults) => {
    if (err) {
      console.error("Error fetching assigned admins:", err);
      return;
    }
    console.log("Admins fetched");

    // Notify each assigned admin with the specific event and data
    adminResults.forEach((row) => {
      console.log(row);
      const adminConnections = adminSockets[row.user_id];
      if (adminConnections && adminConnections.length > 0) {
        adminConnections.forEach((connection) => {
          connection.socket.emit(emitEvent, encryptData(emitData));
          console.log(
            `Admin ${row.user_id} notified with event '${emitEvent}' and data:`,
            emitData
          );
        });
      } else {
        console.log(`No active connections found for admin ${row.user_id}`);
      }
    });
  });
};

// const notifyChatParticipants = (public_key,clientSocket, client_id, a_replied, connection, adminSockets, emitEvent, emitData) => {
//   const assignedAdminsQuery = `
//       SELECT user_id 
//       FROM brand_assignees 
//       WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
//       AND status = 1
//   `;

//   connection.query(assignedAdminsQuery, [public_key], (err, adminResults) => {
//       if (err) {
//           console.error("Error fetching assigned admins:", err);
//           return;
//       }

//       console.log("Admins fetched");

//       adminResults.forEach(({ user_id }) => {
//           const adminId = Number(user_id);
//           const adminConnections = adminSockets[adminId];

//           if (!adminConnections || adminConnections.length === 0) {
//               console.log(`No active connections found for admin ${adminId}`);
//               return;
//           }

//           adminConnections.forEach((connection) => {
//               const unseenCount = emitData.notifyAllAdmins ? emitData.totalMessages : (emitData.unseenCounts[adminId] || 0);

//               connection.socket.emit(emitEvent, encryptData({
//                   ...emitData,
//                   unseenCount,
//               }));

//               console.log(`Admin ${adminId} notified with unseen count: ${unseenCount}`);
//           });
//       });
//   });
// };
// const notifyChatParticipants = (public_key, clientSocket, client_id, a_replied, connection, adminSockets, emitEvent, emitData, chatKey) => {
//   const assignedAdminsQuery = `
//       SELECT user_id 
//       FROM brand_assignees 
//       WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
//       AND status = 1
//   `;

//   connection.query(assignedAdminsQuery, [public_key], (err, adminResults) => {
//       if (err) {
//           console.error("Error fetching assigned admins:", err);
//           return;
//       }

//       console.log("Admins fetched");
       
//       let isAdminOnline = false;

//       adminResults.forEach(({ user_id }) => {
//           const adminId = Number(user_id);
//           const adminConnections = adminSockets[adminId];
//         console.log("admin is online ")
//           if (adminConnections && adminConnections.length > 0) {
//               isAdminOnline = true;
//               adminConnections.forEach((connection) => {
//                   const unseenCount = emitData.notifyAllAdmins ? emitData.totalMessages : (emitData.unseenCounts[adminId] || 0);
//                   connection.socket.emit(emitEvent, encryptData({ ...emitData, unseenCount }));
//                   console.log(`Admin ${adminId} notified with unseen count: ${unseenCount}`);
//               });
//           }
//       });
      
//       if (!isAdminOnline) {
//         console.log('sending auto reply')
//           // Check chat session status
//           const sessionQuery = `SELECT is_replied , session_id FROM chat_sessions WHERE client_id = ? and is_active = 1 ORDER BY session_id DESC LIMIT 1`;
//           connection.query(sessionQuery,[client_id], (err, sessionResult) => {
//               if (err) {
//                   console.error("Error fetching chat session:", err);
//                   return;
//               }
//               console.log(sessionResult[0])
//               const is_replied = sessionResult[0]?.is_replied || 0;
//               const session_id = sessionResult[0].session_id;
//               if ( is_replied === 0) {
//                   // Fetch first auto-reply
//                   const autoReplyQuery = `SELECT auto_reply1 FROM auto_replies WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)`;
//                   connection.query(autoReplyQuery, [public_key], (err, autoResult) => {
//                       if (err || autoResult.length === 0) {
//                           console.error("Error fetching auto-reply:", err);
//                           return;
//                       }

//                       const autoReplyMsg = autoResult[0].auto_reply1;
//                       sendAutoReply(clientSocket, client_id, autoReplyMsg,session_id, chatKey, connection, 1);
//                   });
//               } else if (is_replied === 1) {
//                   // Fetch second auto-reply
//                   const autoReplyQuery = `SELECT auto_reply2 FROM auto_replies WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)`;
//                   connection.query(autoReplyQuery, [public_key], (err, autoResult) => {
//                       if (err || autoResult.length === 0) {
//                           console.error("Error fetching auto-reply:", err);
//                           return;
//                       }

//                       const autoReplyMsg = autoResult[0].auto_reply2;
//                       sendAutoReply(clientSocket, client_id, autoReplyMsg, session_id,chatKey, connection, 2);
//                   });
//               }
//           });
//       }
//   });
// };
const checkAllowedUserAreOnlineOrNot = (public_key, clientSocket, client_id,  connection, adminSockets , chatKey)=>{
  // TODO: Implement logic to check if allowed user types are online or not.
  // For demonstration purposes, we'll return true for simplicity.
  const ignoreAutoReplyQuery = `
  SELECT user_type, status 
  FROM ignore_auto_reply 
  WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
`;

connection.query(ignoreAutoReplyQuery, [public_key], (err, ignoreResults) => {
  if (err) {
      console.error("Error fetching ignore_auto_reply:", err);
      return;
  }

  if (ignoreResults.length === 0) {
    
      return;
  }

  // Determine roles to check
  const userTypeStatus = {
      'admin': ignoreResults.find(r => r.user_type === 'admin')?.status || 0,
      'sales': ignoreResults.find(r => r.user_type === 'sales')?.status || 0,
      'marketing': ignoreResults.find(r => r.user_type === 'marketing')?.status || 0
  };

  const rolesToCheck = [];
  if (userTypeStatus.admin === 0) rolesToCheck.push(2);
  if (userTypeStatus.sales === 0) rolesToCheck.push(3);
  if (userTypeStatus.marketing === 0) rolesToCheck.push(4);
  console.log("checked roles to check");
  
 

  if (rolesToCheck.length === 0) {
    sendAutoReplyForNewClient(clientSocket, client_id, connection, public_key, chatKey);
      return;
  }
  console.log(rolesToCheck)
  const assignedUsersQuery = `
      SELECT user_id 
      FROM brand_assignees 
      WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
      AND status = 1
  `;

  connection.query(assignedUsersQuery, [public_key], (err, userResults) => {
      if (err) {
          console.error("Error fetching assigned users:", err);
          return;
      }

      let shouldSendAutoReply = true;

      userResults.forEach(({ user_id }) => {
          const userId = Number(user_id);
          let role = null;

          if (adminSockets[userId] && adminSockets[userId].length > 0) {
              role = adminSockets[userId][0]?.socket?.user?.role || null;
              console.log(`Users ${userId} have role: ${role}`);
          } else {
              console.log(`User ${userId} is not online or not found in adminSockets`);
          }

          if (role !== null) {
              const userRole = Number(role);
           
            console.log("checking role")
            console.log(rolesToCheck.includes(userRole))
              if (rolesToCheck.includes(userRole)) {
                console.log('marking auto reply false');
                
                  shouldSendAutoReply = false;
              }

          
             
          }  
      });

      // ✅ Ensure Auto-Reply is Sent Only Once
      if (shouldSendAutoReply) {
         
        sendAutoReplyForNewClient(clientSocket, client_id, connection, public_key, chatKey);
      }
  });
});
  
}

const sendAutoReplyForNewClient = (clientSocket, client_id, connection, public_key, chatKey) => {
  
 
      
      const replyType = is_replied = 'auto_reply1' ;
       
      const autoReplyQuery = `SELECT ${replyType} FROM auto_replies WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)`;
      connection.query(autoReplyQuery, [public_key], (err, autoResult) => {
          if (err || !autoResult.length) {
            if(autoResult.length == 0){
              console.log("No auto-reply found for this brand, sending default auto-reply")
              
            }
            
              console.error("Error fetching auto-reply:", err);
              return;
          }

          sendAutoReplyWithoutAddingNewMessageinTable(              
              client_id,
              autoResult[0][replyType],
              chatKey ,
              clientSocket
          );
      });
 
};
const sendAutoReplyWithoutAddingNewMessageinTable = (  client_id, autoReplyMsg, chatKey,clientSocket ) => {
  
  const sessionQuery = `SELECT is_replied, session_id FROM chat_sessions WHERE client_id = ? AND is_active = 1 ORDER BY session_id DESC LIMIT 1`;

  connection.query(sessionQuery, [client_id], (err, sessionResult) => {
    if (err) {
      console.error("Error fetching session:", err);
      return;
    }

    if (sessionResult.length === 0) {
    
 
     
      const clientSocketIds = connectedClients[client_id]; // Get all sockets for the client

      setTimeout(() => {
       
        clientSocket.emit("chat message", {
          from: 'system',
          msg: autoReplyMsg,
          type: "admin",
          room: chatKey,
          msgtype: "auto-reply",
          sent_at: new Date().toISOString(),
          messageId: 'unknown',
      });
      
              if (clientSocketIds && clientSocketIds.length > 0) {
                  clientSocketIds.forEach(socketId => {
                      const socket = io.sockets.sockets.get(socketId); // Get socket instance
                      if (socket) {
                         
                           socket.emit("auto-reply", {
                              is_re: 1,
                          });
      
                          console.log(`Auto-reply sent to client socket: ${socketId}`);
                      }
                  });
              } else {
                  console.log(`No active sockets found for client_id: ${client_id}`);
              }
           
      }, 1000); // 1-second delay
      
   

      // const updateClientQuery = `UPDATE clients SET a_replied = ? WHERE id = ?`;
      // connection.query(updateClientQuery, [a_replied_value, client_id]);

      console.log(`Auto-reply sent: ${autoReplyMsg} with message ID: `);
          
    }
    })
};

const handleIsUserReceivedAutoReply = (client_id, chatKey, connection, public_key, a_replied_value) => {
  return new Promise((resolve, reject) => {
      const sessionQuery = `SELECT is_replied, session_id FROM chat_sessions WHERE client_id = ? AND is_active = 1 ORDER BY session_id DESC LIMIT 1`;

      connection.query(sessionQuery, [client_id], (err, sessionResult) => {
          if (err) {
              console.error("Error fetching session:", err);
              return reject(err);
          }

          if (sessionResult.length === 0) {
              console.log("No active chat session found. Skipping auto-reply.");
              return resolve(); // No session, nothing to reply
          }

          const { is_replied, session_id } = sessionResult[0];
          let replyType = a_replied_value === 1 ? 'auto_reply1' : 'auto_reply2';

          const autoReplyQuery = `SELECT ${replyType} FROM auto_replies WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)`; 
          
          connection.query(autoReplyQuery, [public_key], (err, autoResult) => {
              if (err || !autoResult.length) {
                  console.error("Error fetching auto-reply:", err);
                  return reject(err);
              }

              if ((a_replied_value === 1 && is_replied === 0) || (a_replied_value === 2 && is_replied === 1)) {
                  const autoReplyMsg = autoResult[0][replyType];

                  console.log(autoReplyMsg);

                  const insertMessageQuery = `
                      INSERT INTO chat_messages (session_id, sender_id, message, type) 
                      VALUES (?, ?, ?, 'auto-reply')
                  `;

                  connection.query(insertMessageQuery, [session_id, 'system', autoReplyMsg], (err, result) => {
                      if (err) {
                          console.error("Error inserting auto-reply:", err);
                          return reject(err);
                      }

                      const messageId = result.insertId; 

                      const updateChatSessionQuery = `UPDATE chat_sessions SET is_replied = ? WHERE session_id = ?`;
                      connection.query(updateChatSessionQuery, [a_replied_value, session_id], (err) => {
                          if (err) {
                              console.error("Error updating chat session:", err);
                              return reject(err);
                          }

                          console.log(`Auto-reply (${replyType}) sent: ${autoReplyMsg} with message ID: ${messageId}`);
                          resolve();
                      });
                  });
              } else {
                  console.log("No auto-reply needed.");
                  resolve();
              }
          });
      });
  });
};

const notifyChatParticipants = (public_key, clientSocket, client_id, a_replied, connection, adminSockets, emitEvent, emitData, chatKey) => {
  console.log('chat key');
  console.log(chatKey);

  const ignoreAutoReplyQuery = `
      SELECT user_type, status 
      FROM ignore_auto_reply 
      WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
  `;

  connection.query(ignoreAutoReplyQuery, [public_key], (err, ignoreResults) => {
      if (err) {
          console.error("Error fetching ignore_auto_reply:", err);
          return;
      }

      if (ignoreResults.length === 0) {
          handleOriginalAdminCheck(public_key, clientSocket, client_id, connection, adminSockets, emitEvent, emitData, chatKey);
          return;
      }

      // Determine roles to check
      const userTypeStatus = {
          'admin': ignoreResults.find(r => r.user_type === 'admin')?.status || 0,
          'sales': ignoreResults.find(r => r.user_type === 'sales')?.status || 0,
          'marketing': ignoreResults.find(r => r.user_type === 'marketing')?.status || 0
      };

      const rolesToCheck = [];
      if (userTypeStatus.admin === 0) rolesToCheck.push(2);
      if (userTypeStatus.sales === 0) rolesToCheck.push(3);
      if (userTypeStatus.marketing === 0) rolesToCheck.push(4);

      console.log("Roles to check:", rolesToCheck);

      if (rolesToCheck.length === 0) {
          sendAutoReplyBasedOnSession(clientSocket, client_id, connection, public_key, chatKey,a_replied);
          return;
      }

      const assignedUsersQuery = `
          SELECT user_id 
          FROM brand_assignees 
          WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
          AND status = 1
      `;

      connection.query(assignedUsersQuery, [public_key], (err, userResults) => {
          if (err) {
              console.error("Error fetching assigned users:", err);
              return;
          }

          let shouldSendAutoReply = true;

          userResults.forEach(({ user_id }) => {
              const userId = Number(user_id);
              let role = null;

              if (adminSockets[userId] && adminSockets[userId].length > 0) {
                  role = adminSockets[userId][0]?.socket?.user?.role || null;
                  console.log(`User ${userId} has role: ${role}`);
              } else {
                  console.log(`User ${userId} is not online or not found in adminSockets`);
              }

              if (role !== null) {
                  const userRole = Number(role);
                  console.log(`User role is: ${userRole}`);
                  console.log(`User role checked: ${rolesToCheck.includes(userRole)}`);

                  if (rolesToCheck.includes(userRole)) {
                      shouldSendAutoReply = false;
                  }

                  const connections = adminSockets[userId];
                  if (connections && connections.length > 0) {
                      connections.forEach(conn => {
                          const unseenCount = emitData.notifyAllAdmins
                              ? emitData.totalMessages
                              : (emitData.unseenCounts[userId] || 0);

                          console.log(emitEvent);
                          conn.socket.emit(emitEvent, encryptData({ ...emitData, unseenCount }));
                          console.log(`Admin ${userId} notified with unseen count: ${unseenCount}`);
                      });
                  }
              } else {
                  console.log(`Skipping user ${userId} as role is undefined or null`);
              }
          });

          // ✅ Ensure Auto-Reply is Sent Only Once
          if (shouldSendAutoReply) {
              console.log("✅ Sending Auto-Reply as no relevant user is online...");
              sendAutoReplyBasedOnSession(clientSocket, client_id, connection, public_key, chatKey,a_replied);
          }
      });
  });
};


const handleOriginalAdminCheck = (public_key, clientSocket, client_id, connection, adminSockets, emitEvent, emitData,chatKey) => {
  const assignedAdminsQuery = `
      SELECT user_id 
      FROM brand_assignees 
      WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
      AND status = 1
  `;

  connection.query(assignedAdminsQuery, [public_key], (err, adminResults) => {
      if (err) {
          console.error("Error fetching assigned admins:", err);
          return;
      }

      let isAdminOnline = false;
      adminResults.forEach(({ user_id }) => {
          const adminId = Number(user_id);
          const connections = adminSockets[adminId];
          if (connections && connections.length > 0) {
              isAdminOnline = true;
              connections.forEach(conn => {
                  const unseenCount = emitData.notifyAllAdmins ? emitData.totalMessages : (emitData.unseenCounts[adminId] || 0);
                  conn.socket.emit(emitEvent, encryptData({ ...emitData, unseenCount }));
              });
          }
      });

      if (!isAdminOnline) {
          sendAutoReplyBasedOnSession(clientSocket, client_id, connection, public_key, chatKey,a_replied);
      }
  });
};

const sendAutoReplyBasedOnSession = (clientSocket, client_id, connection, public_key, chatKey,a_replied) => {
  const sessionQuery = `SELECT is_replied, session_id FROM chat_sessions WHERE client_id = ? AND is_active = 1 ORDER BY session_id DESC LIMIT 1`;
  connection.query(sessionQuery, [client_id], (err, sessionResult) => {
      if (err) {
          console.error("Error fetching session:", err);
          return;
      }
      if(sessionResult.length == 0){
        console.log(`No active chat session found for client_id: ${client_id}`)
        return;
      }

      const { is_replied, session_id } = sessionResult[0];
      if(is_replied == 2){
        console.log("Chat session already replied, skipping auto-reply")
        return;
      }
      let replyType = is_replied === 0 ? 'auto_reply1' : 'auto_reply2';
      if(a_replied == 1){
        replyType = 'auto_reply2'
      }
      const autoReplyQuery = `SELECT ${replyType} FROM auto_replies WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)`;
      connection.query(autoReplyQuery, [public_key], (err, autoResult) => {
          if (err || !autoResult.length) {
            if(autoResult.length == 0){
              console.log("No auto-reply found for this brand, sending default auto-reply")
              
            }
            
              console.error("Error fetching auto-reply:", err);
              return;
          }

          sendAutoReply(
              clientSocket,
              client_id,
              autoResult[0][replyType],
              session_id,
              chatKey,
              connection,
              is_replied === 0 ? 1 : 2,
              a_replied
          );
      });
  });
};

// Existing sendAutoReply function remains unchanged

const sendAutoReply = (clientSocket, client_id, autoReplyMsg, session_id,chatKey, connection, a_replied_value,a_replied) => {
  const messageTime = new Date().toISOString();
    console.log(a_replied);
    
  // Insert auto-reply into chat_messages and get the generated message ID
  const insertMessageQuery = `
      INSERT INTO chat_messages (session_id, sender_id, message,  type) 
      VALUES (?, ?, ?, 'auto-reply')
  `;
  console.log('inserting message from sendAutoReply');
  connection.query(insertMessageQuery, [session_id, 'system', autoReplyMsg], (err, result) => {
      if (err) {
          console.error("Error inserting auto-reply:", err);
          return;
      }
      console.log(chatKey)
      const messageId = result.insertId; // Get the last inserted message ID
      const clientSocketIds = connectedClients[client_id]; // Get all sockets for the client

      setTimeout(() => {
          const room = io.sockets.adapter.rooms.get(chatKey); // Get room data
        console.log(room);
        
         
      
              if (clientSocketIds && clientSocketIds.length > 0) {
                  clientSocketIds.forEach(socketId => {
                      const socket = io.sockets.sockets.get(socketId); // Get socket instance
                      if (socket) {
                          socket.emit("chat message", {
                              from: 'system',
                              msg: autoReplyMsg,
                              type: "admin",
                              room: chatKey,
                              msgtype: "auto-reply",
                              sent_at: new Date().toISOString(),
                              messageId: messageId,
                          });
      
                          console.log(`Auto-reply sent to client socket: ${socketId}`);
                      }
                  });
              } else {
                  console.log(`No active sockets found for client_id: ${client_id}`);
              }
           
      }, 1000); // 1-second delay
      
      // let update_a_replied = a_replied == 1 
      // Update chat_sessions and client data
      const updateChatSessionQuery = `UPDATE chat_sessions SET is_replied = ? WHERE session_id = ?`;
      connection.query(updateChatSessionQuery, [a_replied_value, session_id]);

      // const updateClientQuery = `UPDATE clients SET a_replied = ? WHERE id = ?`;
      // connection.query(updateClientQuery, [a_replied_value, client_id]);

      console.log(`Auto-reply sent: ${autoReplyMsg} with message ID: ${messageId} having replied as ${a_replied}`);
  });
};



// Fetch user name by user ID using callback
const getUserNameById = (userId, callback) => {
  try {
    console.log(`Fetching user name for userId: ${userId}`);

    const query = `SELECT pseudonym FROM users WHERE id = ? LIMIT 1`;

    connection.query(query, [userId], (err, results) => {
      if (err) {
        console.error(
          `Database error while fetching user real name: ${err.message}`
        );
        return callback(
          new Error(`Error fetching user real name: ${err.message}`),
          null
        );
      }

      const pseudonym = results.length ? results[0].pseudonym : null;

      if (!pseudonym) {
        console.warn(`No user found with userId: ${userId}`);
      }

      callback(null, pseudonym);
    });
  } catch (error) {
    console.error(`Unexpected error in getUserNameById: ${error.message}`);
    callback(new Error(`Unexpected error: ${error.message}`), null);
  }
};

// Fetch client name by client ID using callback
const getClientNameById = (clientId, callback) => {
  const query = `SELECT name FROM client WHERE client_id = ? LIMIT 1`;

  connection.query(query, [clientId], (err, results) => {
    if (err) {
      return callback(
        new Error(`Error fetching client name: ${err.message}`),
        null
      );
    }
    const clientName = results.length ? results[0].name : null;
    callback(null, clientName);
  });
};

// Fetch participants by session ID and their names using callbacks
function getParticipantsWithNames(sessionId, callback) {
  const participantsQuery = `SELECT * FROM chat_participants WHERE session_id = ?`;

  connection.query(participantsQuery, [sessionId], (err, participants) => {
    if (err) {
      return callback(err, null);
    }

    const participantsWithNames = [];
    let count = 0;

    participants.forEach((participant) => {
      if (participant.role === "admin") {
        // Fetch admin name
        getUserNameById(participant.user_id, (nameErr, pseudonym) => {
          participantsWithNames.push({
            ...participant,
            pseudonym: pseudonym || "Unknown",
          });
          count++;
          if (count === participants.length) {
            callback(null, participantsWithNames);
          }
        });
      } else if (participant.role === "client") {
        // Fetch client name
        getClientNameById(participant.user_id, (nameErr, pseudonym) => {
          participantsWithNames.push({
            ...participant,
            pseudonym: pseudonym || "Unknown",
          });
          count++;
          if (count === participants.length) {
            callback(null, participantsWithNames);
          }
        });
      }
    });
  });
}

// Fetch messages by session ID
function getMessagesBySessionId(sessionId, callback) {
  const query = `SELECT * FROM chat_messages WHERE session_id = ? ORDER BY sent_at ASC`;

  connection.query(query, [sessionId], (err, messages) => {
    if (err) {
      return callback(err, null);
    }

    callback(null, messages);
  });
}

const activeChats = {}; // Added activeChats initialization
const activechatsparticipants = {};

const getGeolocationData = async (ipAddress) => {
  // Get geolocation data

  const geo = geoip.lookup(ipAddress);

  if (geo) {
    const { country, region, city } = geo;

    // Get full country name
    const fullCountryName = countries[country]?.name || country;

    return {
      countryName: fullCountryName,
      cityName: city || "Unknown",
    };
  } else {
    console.log("Geolocation data not found.");
    return {
      countryName: "Unknown",
      cityName: "Unknown",
    };
  }
};
// Function to check rating and emit the event if a rating exists
function checkAndEmitRating(socket, sessionId, client_id) {
  const checkRatingQuery = `SELECT rating FROM chat_rate WHERE chat_id = ?`;
  connection.query(checkRatingQuery, [sessionId], (err, ratingResults) => {
    if (err) {
      console.error("Error checking rating:", err);
      return;
    }

    if (ratingResults.length > 0 && ratingResults[0].rating !== null) {
      // Emit socket event with the rating
      socket.emit("chat rating", encryptData({
        session_id: sessionId,
        rating: ratingResults[0].rating,
        client_id: client_id,
      }));
      console.log(
        `Rating emitted for session ${sessionId}:`,
        ratingResults[0].rating
      );
    } else {
      console.log(`No rating found for session ${sessionId}`);
      socket.emit("chat rating", encryptData({
        session_id: sessionId,
        rating: 3,
        client_id: client_id,
      }));
    }
  });
}
const getChatMeta = (client_id, public_key, sockets) => {
  try {
    const chatKey = `${public_key}_${client_id}`;

    // Step 1: Fetch chat session and participants
    const sessionAndUsersQuery = `
      SELECT cs.session_id, cs.served_by, cp.user_id, cp.join_time
      FROM chat_sessions cs
      JOIN chat_participants cp ON cs.session_id = cp.session_id
      WHERE cs.chat_key = ? 
        AND cs.is_active = 1 
        AND cp.role = 'admin'
      ORDER BY cp.join_time ASC
      LIMIT 1
    `;

    connection.query(
      sessionAndUsersQuery,
      [chatKey],
      (err, sessionAndUsers) => {
        if (err || sessionAndUsers.length === 0) {
          console.error("Error fetching chat session:", err);
          sockets.forEach((socket) =>
            socket.emit("served by", {
              isServed: false,
              message: "No active chat session found",
            })
          );
          return;
        }

        const { session_id, user_id } = sessionAndUsers[0];

        // Step 2: Fetch admin details
        const adminQuery = `
        SELECT pseudonym, designation , profile
        FROM users 
        WHERE id = ? LIMIT 1
      `;

        connection.query(adminQuery, [user_id], (err, admin) => {
          if (err || admin.length === 0) {
            console.error("Error fetching admin details:", err);
            sockets.forEach((socket) =>
              socket.emit("served by", {
                isServed: false,
                message: "Served admin not found",
              })
            );
            return;
          }

          const { pseudonym, designation, profile } = admin[0];
          const profile_url_admin = `${process.env.BACKEND_URL}/${encodeURIComponent(profile)}`;
          // Step 3: Fetch brand logo
          const brandQuery = `
          SELECT logo 
          FROM brands 
          WHERE public_key = ? LIMIT 1
        `;

          connection.query(brandQuery, [public_key], (err, brand) => {
            const logoPath = brand.length > 0 ? brand[0].logo : null;
            const logourl = logoPath
              ? `https://test.vchat.ourprojectdemo.com:3001/${logoPath}`
              : null;

            // Step 4: Check rating
            const ratingQuery = `
            SELECT rating 
            FROM chat_rate 
            WHERE chat_id = ? LIMIT 1
          `;

            connection.query(ratingQuery, [session_id], (err, ratingResult) => {
              const rating =
                ratingResult.length > 0 ? ratingResult[0].rating : 0;

              // Emit final visitor status
              const visitorStatus = {
                isServed: true,
                served_by: pseudonym,
                designation: designation,
                logo: profile_url_admin,
                rating: rating,
              };

              sockets.forEach((socket) =>
                socket.emit("served by",visitorStatus)
              );
            });
          });
        });
      }
    );
  } catch (error) {
    console.error("Unexpected error in getChatMeta:", error);
    sockets.forEach((socket) =>
      socket.emit(
        "error",
        encryptData({ message: "Unexpected error occurred" })
      )
    );
  }
};

// Function to check if rating is given for a chat session
const checkIfRatingGiven = (client_id, chatKey, socket) => {
  // Step 1: Fetch session_id from chat_sessions using chatKey
  const getSessionQuery = `SELECT session_id FROM chat_sessions WHERE chat_key = ? AND is_active = 1 LIMIT 1`;

  connection.query(getSessionQuery, [chatKey], (err, sessionResults) => {
    if (err) {
      console.error("Error fetching session:", err);
      return;
    }

    if (sessionResults.length > 0) {
      const sessionId = sessionResults[0].session_id;

      // Step 2: Check if rating exists in the chat_rate table
      const checkRatingQuery = `SELECT * FROM chat_rate WHERE chat_id = ? LIMIT 1`;

      connection.query(checkRatingQuery, [sessionId], (err, ratingResults) => {
        if (err) {
          console.error("Error checking rating:", err);
          return;
        }

        // Step 3: Emit result to the client based on whether a rating exists
        if (ratingResults.length > 0) {
          socket.emit("rating chat", encryptData({ rating: true })); // Rating is given
        } else {
          socket.emit("rating chat", encryptData({ rating: false })); // Rating not given
        }
      });
    } else {
      socket.emit("rating", encryptData({ rating: false })); // No active session found
    }
  });
};
function fetchClientDetails(client_id, sockets) {
  // Assume you have a database connection available
  const query = "SELECT name, email, phone FROM client WHERE client_id = ?";

  connection.query(query, [client_id], (error, results) => {
    if (error) {
      console.error("Error fetching client details:", error);
      return;
    }

    if (results.length > 0) {
      const clientDetails = results[0];
      console.log("client details");
      console.log(clientDetails);

      sockets.forEach((socket) => {
        socket.emit("client profile details",  {
          name: clientDetails.name,
          email: clientDetails.email,
          phone: clientDetails.phone,
        });
      });
      console.log("client profile details sent ");

      // Emit the client details to the client socket
    }
  });
}
function fetchUnseenMessagesForAdmins(
  connection,
  public_key,
  client_id,
  io,
  chatKey
) {
  // Step 1: Check for active chat session
  const activeChatSessionQuery = `
    SELECT session_id 
    FROM chat_sessions 
    WHERE chat_key = ? AND is_active = 1
  `;

  connection.query(activeChatSessionQuery, [chatKey], (err, sessionResults) => {
    if (err) {
      console.error("Error checking active chat session:", err);
      return;
    }
    console.log(sessionResults);
    if (sessionResults.length === 0) {
      console.log("No active chat session found.");
      return;
    }

    const sessionId = sessionResults[0].session_id;

    // Step 2: Fetch admin user IDs from chat_participants
    const adminParticipantsQuery = `
      SELECT user_id 
      FROM chat_participants 
      WHERE session_id = ? AND role = 'admin'
    `;

    connection.query(
      adminParticipantsQuery,
      [sessionId],
      (err, adminResults) => {
        if (err) {
          console.error("Error fetching admin participants:", err);
          return;
        }

        // Extract user IDs
        const adminUserIds = adminResults.map((admin) => admin.user_id);

        if (adminUserIds.length === 0) {
          console.log("No admins found for this session.");
          return;
        }

        // Step 3: Count unseen messages for all admins
        const unseenMessagesPromises = adminUserIds.map((userId) => {
          return new Promise((resolve, reject) => {
            const unseenMessagesQuery = `
            SELECT COUNT(*) AS unseenCount 
            FROM chat_messages 
            WHERE session_id = ? AND sender_id = ? AND is_seen = 0 AND type !='comment'
          `;

            connection.query(
              unseenMessagesQuery,
              [sessionId, userId],
              (err, countResults) => {
                if (err) {
                  reject(err);
                } else {
                  resolve(countResults[0].unseenCount);
                }
              }
            );
          });
        });

        // Resolve all unseen message counts
        Promise.all(unseenMessagesPromises)
          .then((unseenCounts) => {
            // Combine unseen counts
            const totalUnseenMessages = unseenCounts.reduce(
              (total, count) => total + count,
              0
            );

            // Emit the total unseen messages count to the client
            io.to(chatKey).emit("unseen messages from admin", encryptData({
              unseenMessages: totalUnseenMessages,
              client_id: client_id,
            }));

            console.log(
              `Emitting total unseen messages to client ${client_id}: ${totalUnseenMessages}`
            );
          })
          .catch((err) => {
            console.error("Error counting unseen messages:", err);
          });
      }
    );
  });
}

const typingUsers = new Map();
io.on("connection", (socket) => {
  const user = socket.user;
  console.log(`User connected: ${socket.user.user_id || socket.user.client_id}`);

//   socket.use((packet, next) => {
//     const userId = socket.user.user_id || socket.user.client_id;
//     const key = `emit_${userId}`;
//     const currentTime = Date.now();

//     if (!emitAttempts.has(key)) {
//       emitAttempts.set(key, []);
//     }

//     const attempts = emitAttempts.get(key).filter(
//       (time) => currentTime - time < EMIT_WINDOW
//     );

//     if (attempts.length >= EMIT_LIMIT) {
//       console.error(`Emit rate limit exceeded for user: ${userId}`);
//       return next(new Error("Too many messages. Slow down."));
//     }

//     attempts.push(currentTime);
//     emitAttempts.set(key, attempts);
//     next();
//   });
socket.use((packet, next) => {
    if (['ping', 'pong'].includes(packet[0])) return next();
    
    const userId = socket.user.user_id || socket.user.client_id;
    if (!checkLimit(emitAttempts, `emit_${userId}`, EMIT_WINDOW, EMIT_LIMIT)) {
        return next(new Error("Too many messages. Slow down."));
    }
    
    next();
});
  if (user) {
    // When an admin connects
    if (user.user_id) {
      // Perform the session check using promises (if applicable)

      // Admin handling
      console.log("Admin connected:", user.user_id);

      // Initialize storage for this user if it doesn't exist
      if (!adminSockets[user.user_id]) {
        adminSockets[user.user_id] = [];
      }

      // Add the new connection for the user
      adminSockets[user.user_id].push({
        socketId: socket.id,
        deviceId: socket.handshake.auth.device_id,
        socket: socket, // Optional: Store the socket instance if needed
      });

      // Emit the connection event to all active admins
      for (const adminId in adminSockets) {
        adminSockets[adminId].forEach((adminSocket) => {
          adminSocket.socket.emit("online_user",encryptData({
            userId: user.user_id,
          }));
        });
      }
 
      socket.on("Check_Logged_in_to_other_device", (data) => {
        const { user_id, device_id } = data;
      
         

        if (adminSockets[user.user_id]) {
          // Iterate through all connections for this user
          adminSockets[user.user_id].forEach((conn) => {
            if (conn.deviceId !== device_id) {
              // Emit the event only to connections with a different deviceId
              conn.socket.emit("Logged_in_to_other_device",encryptData( {
                user: user.user_id,
                message:
                  "You have been logged out because this user logged in on another device.",
              }));

              console.log(
                `Emitted "Logged_in_to_other_device" to socket ${conn.socketId} with device ID ${conn.deviceId}`
              );
            }
          });
        } else {
          console.log(`No active connections found for user ${user.user_id}`);
        }

        // Check the user's session
        checkUserSession(user.user_id, device_id)
          .then((checkUser) => {
            if (!checkUser) {
              console.error(
                `User session not found for userID: ${user.user_id} with device ID: ${device_id}`
              );
            } else {
              console.log(
                `User ${user.user_id} connected with valid session for device ID ${device_id}`
              );
              // Additional logic for valid sessions can be added here
            }
          })
          .catch((error) => {
            console.error(
              "Error during user session validation:",
              error.message
            );
          });
      });
      // Listen for the 'new-alert' event
      socket.on("new-alert", (data) => {
        const { msg, alertType } = data;

        // Emit the 'new-alert' event to all online admins
        for (const adminId in adminSockets) {
          adminSockets[adminId].forEach((adminSocket) => {
            adminSocket.socket.emit("new-alert",encryptData( {
              msg: msg, // Include the alert message
              alertType: alertType,
              createdBy: user.user_id, // Optional: Add the user ID who created the alert
            }));
          });
        }
      });
      // Handle 'get_online_users' event
      socket.on("get_online_users", () => {
        console.log("Received 'get_online_users' event from:", user?.user_id);

        // Gather all currently connected admin user IDs
        const onlineUsers = Object.keys(adminSockets).map((adminId) => ({
          userId: adminId,
        }));

        // Emit the list of online users to the requesting socket
        socket.emit("online_users", encryptData(onlineUsers));
      });
      // Listen for 'page load' event with brand_id from frontend
      socket.on("page load", async (data) => {
        const { brand_id } = data;
        console.log(adminSockets[user.user_id]);

        // Assuming `user_id` is stored in socket for the connected user/admin
        const user_id = user.user_id;
        

        if (!user_id) {
          console.error("User ID is not available in socket.");
          socket.emit("error", "User ID is not available in socket.");
          return;
        }

        if (brand_id) {
          // Logic when brand_id is provided
          console.log("Fetching visitors for brand ID:", brand_id);

          const checkAdminQuery = `
            SELECT COUNT(*) AS count 
            FROM brand_assignees 
            WHERE brand_id = ? AND user_id = ? and status  = 1

          `;
          connection.query(
            checkAdminQuery,
            [brand_id, user_id],
            (err, adminResults) => {
              if (err) {
                console.error("Error checking admin assignment:", err);
                socket.emit("error", "Error checking admin assignment.");
                return;
              }

              const adminExists = adminResults[0].count > 0;

              if (!adminExists) {
                console.log("Admin is not assigned to this brand.");
                socket.emit("error", "Admin is not assigned to this brand.");
                return;
              }

              // Fetch the public key and brand name for the given brand_id
              const publicKeyQuery =
                "SELECT public_key, name FROM brands WHERE id = ?";
              connection.query(
                publicKeyQuery,
                [brand_id],
                (err, brandResults) => {
                  if (err) {
                    console.error("Error fetching public key:", err);
                    return;
                  }

                  if (brandResults.length > 0) {
                    const public_key = brandResults[0].public_key;
                    const brand_name = brandResults[0].name;
                    console.log("Fetched public key:", public_key);

                    fetchVisitorsByPublicKey(public_key, brand_name);
                  } else {
                    console.log("No public key found for the given brand ID.");
                  }
                }
              );
            }
          );
        } else {
          // Logic when brand_id is not provided
          console.log(
            "No brand ID provided, fetching visitors for all assigned brands."
          );

          // Fetch public keys and names for all brands assigned to this admin
          const assignedBrandsQuery = `
            SELECT b.public_key, b.name 
            FROM brand_assignees ba 
            JOIN brands b ON ba.brand_id = b.id 
            WHERE ba.user_id = ? AND ba.status = 1
          `;
          connection.query(
            assignedBrandsQuery,
            [user_id],
            (err, brandResults) => {
              if (err) {
                console.error("Error fetching assigned brands:", err);
                socket.emit("error", "Error fetching assigned brands.");
                return;
              }

              if (brandResults.length > 0) {
                const brandData = brandResults.map((brand) => ({
                  public_key: brand.public_key,
                  name: brand.name,
                }));

                // Fetch visitors for all assigned brands
                fetchVisitorsByPublicKeys(brandData,user.user_id);
              } else {
                console.log("No assigned brands found for the admin.");
                socket.emit("error", "No assigned brands found.");
              }
            }
          );
        }

        // Helper function to fetch visitors by a single public key
        function fetchVisitorsByPublicKey(public_key, brand_name) {
          const visitorDataQuery = `
              SELECT 
                vs.id AS visitor_session_id, 
                vs.client_id, 
                vs.landing_url, 
                vs.public_key, 
                vs.join_time, 
                vs.status, 
                cs.served_by,
                c.name AS client_name,
                v.os, 
                v.ip, 
                v.browser,
                v.country,
                (SELECT COUNT(*) 
                 FROM chat_messages cm
                 WHERE cm.session_id = cs.session_id
                   AND cm.is_seen = 0
                   AND EXISTS (
                      SELECT 1
                      FROM chat_participants cp
                      WHERE cp.session_id = cm.session_id
                        AND cp.user_id = cm.sender_id
                        AND cp.role = 'client'
                   )) AS unseen_count,
                (SELECT COUNT(*) 
                 FROM chat_messages cm_total
                 WHERE cm_total.session_id = cs.session_id and AND cm_total.type <> 'comment'
                ) AS total_msg_count
              FROM visitor_session vs
              LEFT JOIN chat_sessions cs ON vs.id = cs.visitor_id
              LEFT JOIN client c ON vs.client_id = c.client_id
              LEFT JOIN visitors v ON vs.client_id = v.client_id AND v.created_at = (
                SELECT MAX(created_at) FROM visitors WHERE client_id = vs.client_id
              )
              WHERE vs.status != 4 AND vs.public_key = ?
              ORDER BY vs.join_time DESC
            `;

          // Execute the SQL query
          connection.query(
            visitorDataQuery,
            [public_key],
            (err, visitorResults) => {
              if (err) {
                console.error("Error fetching visitor data:", err);
                return;
              }

              // Iterate through the results and emit the data via socket
              visitorResults.forEach((visitor) => {
                socket.emit("active visitors",encryptData( {
                  client_id: visitor.client_id,
                  client_name: visitor.client_name,
                  public_key: visitor.public_key,
                  join_time: visitor.join_time,
                  status: visitor.status,
                  served_by: visitor.served_by,
                  landing_url: visitor.landing_url,
                  visitor_session_id: visitor.visitor_session_id,
                  os: visitor.os,
                  ip: visitor.ip,
                  country: visitor.country,
                  browser: visitor.browser,
                  unseenMsg: visitor.unseen_count,
                  totalMsgCount: visitor.total_msg_count, // Include total message count
                  brand_name: brand_name, // Emit the brand name along with visitor data
                }));
                console.log(
                  `Emitting visitor data for client ${visitor.client_id} to frontend (Brand: ${brand_name})`
                );
              });
            }
          );
        }

       
        // function fetchVisitorsByPublicKeys(brandData,user_id) {
        //   const publicKeys = brandData.map((brand) => brand.public_key);
        //   const brandNamesMap = Object.fromEntries(
        //     brandData.map((brand) => [brand.public_key, brand.name])
        //   );

        //   const visitorDataQuery = `
        //       SELECT 
        //         vs.id AS visitor_session_id, 
        //         vs.client_id, 
        //         vs.landing_url, 
        //         vs.public_key, 
        //         vs.join_time, 
        //         vs.status, 
        //         cs.served_by,
        //         c.name AS client_name,
        //         v.os, 
        //         v.ip, 
        //         v.browser,
        //         v.country,
        //         (SELECT COUNT(*) 
        //          FROM chat_messages cm
        //          WHERE cm.session_id = cs.session_id
        //            AND cm.is_seen = 0
        //            AND EXISTS (
        //               SELECT 1
        //               FROM chat_participants cp
        //               WHERE cp.session_id = cm.session_id
        //                 AND cp.user_id = cm.sender_id
        //                 AND cp.role = 'client'
        //            )) AS unseen_count,
        //         (SELECT COUNT(*) 
        //          FROM chat_messages cm_total
        //          WHERE cm_total.session_id = cs.session_id AND cm_total.type <> 'comment'
        //         ) AS total_msg_count
        //       FROM visitor_session vs
        //       LEFT JOIN chat_sessions cs ON vs.id = cs.visitor_id
        //       LEFT JOIN client c ON vs.client_id = c.client_id
        //       LEFT JOIN visitors v ON vs.client_id = v.client_id AND v.created_at = (
        //         SELECT MAX(created_at) FROM visitors WHERE client_id = vs.client_id
        //       )
        //       WHERE vs.status != 4 AND vs.public_key IN (?)
        //       ORDER BY vs.join_time DESC
        //     `;

        //   // Execute the SQL query
        //   connection.query(
        //     visitorDataQuery,
        //     [publicKeys],
        //     (err, visitorResults) => {
        //       if (err) {
        //         console.error("Error fetching visitor data:", err);
        //         return;
        //       }

        //       // Iterate through the results and emit the data via socket
        //       visitorResults.forEach((visitor) => {
        //         const brand_name = brandNamesMap[visitor.public_key];
        //         socket.emit("active visitors", encryptData({
        //           client_id: visitor.client_id,
        //           client_name: visitor.client_name,
        //           public_key: visitor.public_key,
        //           join_time: visitor.join_time,
        //           status: visitor.status,
        //           served_by: visitor.served_by,
        //           landing_url: visitor.landing_url,
        //           visitor_session_id: visitor.visitor_session_id,
        //           os: visitor.os,
        //           ip: visitor.ip,
        //           country: visitor.country,
        //           browser: visitor.browser,
        //           unseenMsg: visitor.unseen_count,
        //           totalMsgCount: visitor.total_msg_count, // Include total message count
        //           brand_name: brand_name, // Emit the brand name along with visitor data
        //         }));
        //         console.log(
        //           `Emitting visitor data for client ${visitor.client_id} on brand ${brand_name}`
        //         );
        //       });
        //     }
        //   );
        // }
        // updated here 
        function fetchVisitorsByPublicKeys(brandData, user_id) {
          const publicKeys = brandData.map((brand) => brand.public_key);
          const brandNamesMap = Object.fromEntries(
              brandData.map((brand) => [brand.public_key, brand.name])
          );
      
          const visitorDataQuery = `
           SELECT 
    vs.id AS visitor_session_id, 
    vs.client_id, 
    vs.landing_url, 
    vs.public_key, 
    vs.join_time, 
    vs.status, 
    cs.served_by,
    c.name AS client_name,
    v.os, 
    v.ip, 
    v.browser,
    v.country,
    (
        CASE 
            -- If no admin is a participant, count all non-comment messages
            WHEN NOT EXISTS (
                SELECT 1 
                FROM chat_participants cp_admin
                WHERE cp_admin.session_id = cs.session_id 
                AND cp_admin.role = 'admin'
            ) 
            THEN (
                SELECT COUNT(*) 
                FROM chat_messages cm_no_admin
                WHERE cm_no_admin.session_id = cs.session_id 
                AND cm_no_admin.type <> 'comment'
            )
            -- Otherwise, count only unseen messages
            ELSE (
                SELECT COUNT(*) 
                FROM chat_messages cm
                WHERE cm.session_id = cs.session_id
                AND cm.sender_id IN (
                    SELECT cp.user_id 
                    FROM chat_participants cp
                    WHERE cp.session_id = cm.session_id 
                    AND cp.role = 'client'
                )
                AND NOT EXISTS (
                    SELECT 1 
                    FROM chat_seens csn
                    WHERE csn.session_id = cm.session_id
                    AND csn.message_id = cm.message_id
                    AND csn.participant_id = ?
                )
                AND (
                    -- Check if user is a participant
                    EXISTS (
                        SELECT 1 
                        FROM chat_participants cp_user
                        WHERE cp_user.session_id = cm.session_id 
                        AND cp_user.user_id = ?
                    ) 
                    OR (
                        -- If another participant exists, it must be user_id
                        NOT EXISTS (
                            SELECT 1 
                            FROM chat_participants cp_other
                            WHERE cp_other.session_id = cm.session_id 
                            AND cp_other.user_id != ?
                        )
                    )
                )
            )
        END
    ) AS unseen_count,
    (SELECT COUNT(*) 
     FROM chat_messages cm_total
     WHERE cm_total.session_id = cs.session_id AND cm_total.type <> 'comment'
    ) AS total_msg_count,
    EXISTS (
        SELECT 1 FROM chat_participants cp
        WHERE cp.session_id = cs.session_id AND cp.user_id = ?
    ) AS is_participant,
    EXISTS (
        SELECT 1 FROM chat_participants cp
        WHERE cp.session_id = cs.session_id AND cp.role = 'admin'
    ) AS has_admin
FROM visitor_session vs
LEFT JOIN chat_sessions cs ON vs.id = cs.visitor_id
LEFT JOIN client c ON vs.client_id = c.client_id
LEFT JOIN visitors v ON vs.client_id = v.client_id AND v.created_at = (
    SELECT MAX(created_at) FROM visitors WHERE client_id = vs.client_id
)
WHERE vs.status != 4 AND vs.public_key IN (?)
ORDER BY vs.join_time DESC;

          `;
      
          // Execute the SQL query
          connection.query(
              visitorDataQuery,
              [user_id, user_id, user_id, user_id, publicKeys], 
              (err, visitorResults) => {
                  if (err) {
                      console.error("Error fetching visitor data:", err);
                      return;
                  }
      
                  // Iterate through the results and emit the data via socket
                  visitorResults.forEach((visitor) => {
                      const brand_name = brandNamesMap[visitor.public_key];
      
                      socket.emit("active visitors", encryptData({
                          client_id: visitor.client_id,
                          client_name: visitor.client_name,
                          public_key: visitor.public_key,
                          join_time: visitor.join_time,
                          status: visitor.status,
                          served_by: visitor.served_by,
                          landing_url: visitor.landing_url,
                          visitor_session_id: visitor.visitor_session_id,
                          os: visitor.os,
                          ip: visitor.ip,
                          country: visitor.country,
                          browser: visitor.browser,
                          unseenMsg: visitor.unseen_count,
                          totalMsgCount: visitor.total_msg_count,
                          brand_name: brand_name,
                          notifyAllAdmins: !visitor.has_admin, // Notify all admins if no admin exists
                      }));
      
                      console.log(
                          `Emitting visitor data for client ${visitor.client_id} on brand ${brand_name}`
                      );
                  });
              }
          );
      }
      
        
      });

      socket.on("join chat", (data) => {
        const { client_id, public_key, pseudonym, userId, visitor_session_id } =
          data;
          console.log("admin joined chat - with visitor session id :",visitor_session_id)
        const chatKey = `${public_key}_${client_id}`;

        // Check if the chatKey exists in activeChats, if not, create it
        if (!activeChats[chatKey]) {
          activeChats[chatKey] = {
            participants: new Set(), // Use Set to prevent duplicates
            messages: [], // Optional: store chat messages
          };
        }
        if (!activechatsparticipants[chatKey]) {
          activechatsparticipants[chatKey] = {
            participants: new Set(), // Use Set to prevent duplicates
            
          };
        }

        // activeChats[chatKey].participants.add(user.user_id);
        // Check if there is an active session for the client_id
        const checkSessionQuery = `SELECT * FROM chat_sessions WHERE client_id = ? AND is_active = 1`;
        connection.query(checkSessionQuery, [client_id], (err, results) => {
          if (err) {
            console.error("Error checking active session:", err);
            return;
          }

          if (results.length > 0) {
            //if chat session exists
            const sessionId = results[0].session_id;
            // if chat session exists but not served by any admin
            if (!results[0].served_by) {
              console.log("No admin assigned to this client");
             

              // Update the chat_sessions table with the pseudonym
              const updateSessionQuery = `
             UPDATE chat_sessions 
             SET served_by = ? 
             WHERE session_id = ?
             `;
              const sessionId = results[0].session_id;
              connection.query(
                updateSessionQuery,
                [pseudonym, results[0].session_id],
                (err) => {
                  if (err) {
                    console.error(
                      "Error updating session with served_by:",
                      err
                    );
                    return;
                  }
                  // Check if participant already exists
                  const checkParticipantQuery = `
            SELECT * FROM chat_participants 
            WHERE session_id = ? AND user_id = ? AND role = 'admin'
            `;

                  connection.query(
                    checkParticipantQuery,
                    [pseudonym, results[0].session_id, userId],
                    (err, results) => {
                      if (err) {
                        console.error("Error checking participant:", err);
                        return;
                      }

                      if (results.length > 0) {
                        // Participant already exists

                        socket.join(chatKey);
                        activeChats[chatKey].participants.add(user.user_id);
                        activechatsparticipants[chatKey].participants.add(
                          user.user_id
                        );
                        console.log(
                          "Active session exists for client:",
                          results[0].session_id
                        );
                        console.log(
                          `Admin ${userId} joined chat with client ${results[0].session_id}`
                        );
                      } else {
                        // Participant does not exist, insert new participant
                        const insertParticipantQuery = `
INSERT INTO chat_participants (session_id, user_id, role, join_time)
VALUES (?, ?, 'admin', NOW())
`;

                        connection.query(
                          insertParticipantQuery,
                          [sessionId, userId],
                          (err) => {
                            if (err) {
                              console.error(
                                "Error inserting participant:",
                                err
                              );
                              return;
                            }

                            const msg = `${pseudonym} has joined the chat`;
                            // Now use getChatMeta to emit data to the client
                            const clientSocketIds = connectedClients[client_id]; // Get all socket IDs for the client

                            if (clientSocketIds && clientSocketIds.length > 0) {
                              // Filter out invalid socket IDs and map to valid socket instances
                              const validSockets = clientSocketIds
                                .map((socketId) =>
                                  io.sockets.sockets.get(socketId)
                                ) // Get the socket instance
                                .filter((socket) => socket); // Keep only valid socket instances

                              if (validSockets.length > 0) {
                                getChatMeta(
                                  client_id,
                                  public_key,
                                  validSockets
                                ); // Pass valid socket instances
                              }
                            } else {
                              socket.emit("visitor_already_left",encryptData( {
                                client_id,
                                msg: "Visitor already left the chat",
                              }));
                            }

                            // Insert message and get the message ID
                            const insertMessageQuery = `
    INSERT INTO chat_messages (session_id, sender_id, message, type, sent_at)
    VALUES (?, ?, ?, ?, NOW())
  `;

                            connection.query(
                              insertMessageQuery,
                              [sessionId, user.user_id, msg, "comment"],
                              (err, result) => {
                                if (err) {
                                  console.error(
                                    "Error inserting message:",
                                    err
                                  );
                                  return;
                                }

                                const messageId = result.insertId; // Get the ID of the inserted message
                                const messageTime = new Date().toISOString(); // Get current time in ISO format

                                // Add the participant to the active chat
                                activeChats[chatKey].participants.add(
                                  user.user_id
                                );
                                activechatsparticipants[
                                  chatKey
                                ].participants.add(user.user_id);

                                console.log("chat message emit for comment");

                                // Emit the chat message with the message ID
                                io.to(chatKey).emit("chat message", {
                                  from: pseudonym, // sender's name
                                  msg, // the actual message
                                  type: "admin", // message type (admin)
                                  msgtype: "comment", // message subtype (e.g., comment)
                                  room: chatKey, // room identifier
                                  sent_at: messageTime, // time of message
                                  messageId: messageId, // message ID
                                });
                                notifyAssignedAdmins(
                                  public_key,
                                  connection,
                                  adminSockets,
                                  "visitor served by update",
                                  {
                                    client_id,
                                    pseudonym,
                                    public_key,
                                    served_by: pseudonym,
                                  }
                                );
                                console.log("New participant inserted");
                                socket.join(chatKey);
                              }
                            );
                          }
                        );
                      }
                    }
                  );
                }
              );
            }
            // Use the common function to check and emit rating
            checkAndEmitRating(socket, sessionId, client_id);
           
            // Active session exists, verify participants
            const checkParticipantQuery = `
            SELECT * FROM chat_participants 
            WHERE session_id = ? AND user_id = ? AND role = 'admin'
            `;
            connection.query(
              checkParticipantQuery,
              [pseudonym, results[0].session_id, userId],
              (err, results) => {
                if (err) {
                  console.error("Error checking participant:", err);
                  return;
                }
                if (results.length > 0) {
                  activechatsparticipants[chatKey].participants.add(
                    user.user_id
                  );
                  console.log("participants addeed in local memory..");
                }
                //
                else{

                }
              }
            );

            console.log(results);
            console.log("room key", chatKey);
            activeChats[chatKey].participants.add(user.user_id);
            //here wil be condition will check served by
            socket.join(chatKey);
            console.log("Active session exists for client:", client_id);
            console.log(
              `Admin ${user.user_id} joined chat with client ${client_id}`
            );
            // activeChats[chatKey].participants.add(user.user_id);
            return;
          } else {
            //check any active visitor 
            const checkActiveVisitor =
              "SELECT * FROM visitor_session WHERE client_id = ? AND status != ?";
            connection.query(
              checkActiveVisitor,
              [client_id, 4],
              (err, result) => {
                if (err) {
                  console.error("Error inserting3 new chat session:", err);
                  return;
                }
                if (result.length > 0) {
                  // Add the current socket (user) to the active participants
                  activeChats[chatKey].participants.add(user.user_id);
                  activechatsparticipants[chatKey].participants.add(
                    user.user_id
                  );
                  // No active session exists, create a new session
                  const insertSessionQuery = `
              INSERT INTO chat_sessions (
                chat_key, public_key, served_by, client_id, visitor_id, chat_initiated_time, is_active
              ) VALUES (?, ?, ?, ?, ?, NOW(), 1)
            `;

                  connection.query(
                    insertSessionQuery,
                    [
                      chatKey,
                      public_key,
                      pseudonym,
                      client_id,
                      visitor_session_id,
                    ],
                    (err, result) => {
                      if (err) {
                        console.error(
                          "Error inserting4 new chat session:",
                          err
                        );
                        return;
                      }

                      const newSessionId = result.insertId;
                      // Now update the visitor_session with the new chat_session_id
                      const updateVisitorSessionQuery = `
                  UPDATE visitor_session
                 SET chat_session_id = ?
                  WHERE id = ?
                     `;
                      connection.query(
                        updateVisitorSessionQuery,
                        [newSessionId, visitor_session_id],
                        (updateErr) => {
                          if (updateErr) {
                            console.error(
                              "Error updating visitor session with chat_session_id:",
                              updateErr
                            );
                            return;
                          }

                          console.log(
                            `Successfully updated visitor session with chat_session_id: ${newSessionId}`
                          );
                        }
                      );
                      // Use the common function to check and emit rating for the new session
                      checkAndEmitRating(socket, newSessionId, client_id);
                      // Add participant data
                      const insertParticipantQuery = `
                INSERT INTO chat_participants (session_id, user_id, role, join_time)
                VALUES (?, ?, 'admin', NOW())
              `;

                      connection.query(
                        insertParticipantQuery,
                        [newSessionId, userId],
                        (err) => {
                          if (err) {
                            console.error("Error inserting participant:", err);
                            return;
                          }

                          // Here code for inserting the message of the joined chat
                          const joinmsg = `${pseudonym} has joined the chat`;
                          // Now use getChatMeta to emit data to the client
                          //   const clientSocketId = connectedClients[client_id];  // Get the client's socket ID
                          //   if (clientSocketId && io.sockets.sockets.get(clientSocketId)) {
                          // const clientSocket = io.sockets.sockets.get(clientSocketId);
                          // getChatMeta(client_id, public_key, clientSocket);  // Call getChatMeta with the client socket
                          //   }
                          const clientSocketIds = connectedClients[client_id]; // Get all socket IDs for the client

                          if (clientSocketIds && clientSocketIds.length > 0) {
                            // Filter out invalid socket IDs and map to valid socket instances
                            const validSockets = clientSocketIds
                              .map((socketId) =>
                                io.sockets.sockets.get(socketId)
                              ) // Get the socket instance
                              .filter((socket) => socket); // Keep only valid socket instances

                            if (validSockets.length > 0) {
                              getChatMeta(client_id, public_key, validSockets); // Pass valid socket instances
                            }
                          } else {
                            socket.emit("visitor_already_left",encryptData( {
                              client_id,
                              msg: "Visitor already left the chat",
                            }));
                          }

                          // Send the message
                          const insertMessageQ = `
  INSERT INTO chat_messages (session_id, sender_id, message, type, sent_at)
  VALUES (?, ?, ?, ?, NOW())
`;

                          // Insert the join message and retrieve the messageId
                          connection.query(
                            insertMessageQ,
                            [newSessionId, user.user_id, joinmsg, "comment"],
                            (err, result) => {
                              if (err) {
                                console.error("Error inserting message:", err);
                                return;
                              }

                              // Retrieve the inserted message ID
                              const messageId = result.insertId; // MySQL provides the last inserted ID

                              const messageTime = new Date().toISOString();

                              // Fetch admins assigned to the brand associated with the client_id
                              const fetchAdminsQuery = `
                        SELECT user_id 
                        FROM brand_assignees 
                        WHERE brand_id = (
                          SELECT id 
                          FROM brands 
                          WHERE public_key = ?
                        ) 
                        AND status = 1
                      `;

                              connection.query(
                                fetchAdminsQuery,
                                [public_key],
                                (err, admins) => {
                                  if (err) {
                                    console.error(
                                      "Error fetching admins:",
                                      err
                                    );
                                    return;
                                  }
                                 

                                  // Emit socket message to all admins
                                  admins.forEach((admin) => {
                                    // Ensure admin has active sockets
                                    const adminConnections =
                                      adminSockets[admin.user_id];
                                    if (
                                      adminConnections &&
                                      adminConnections.length > 0
                                    ) {
                                      adminConnections.forEach((connection) => {
                                        connection.socket.emit(
                                          "visitor served by update",
                                          encryptData( {
                                            client_id,
                                            pseudonym,
                                            served_by: pseudonym,
                                          })
                                        );
                                        console.log(
                                          `Admin ${admin.user_id} notified of visitor ${client_id} served by ${pseudonym}.`
                                        );
                                      });
                                    } else {
                                      console.log(
                                        `No active connections found for admin ${admin.user_id}`
                                      );
                                    }
                                  });

                                  console.log("new session served by emitted");

                                  // Join the chat room
                                  socket.join(chatKey);
                                  console.log(
                                    `Admin ${user.user_id} joined chat with client ${client_id}`
                                  );

                                  // Update chat session as joined by admin
                                  const updateQuery = `
        UPDATE chat_sessions SET is_join = 1, chat_start_time = NOW()
        WHERE chat_key = ?
      `;
                                  connection.query(
                                    updateQuery,
                                    [chatKey],
                                    (err, result) => {
                                      if (err) {
                                        console.error(
                                          "Error updating chat session:",
                                          err
                                        );
                                      } else {
                                        console.log(
                                          "Chat session updated as joined:",
                                          result.affectedRows
                                        );
                                      }
                                    }
                                  );

                                  console.log("chat message emit for comment");

                                  // Emit the chat message with the messageId
                                  io.to(chatKey).emit("chat message",  {
                                    from: pseudonym, // from: sender name
                                    msg: joinmsg,
                                    type: "admin",
                                    msgtype: "comment",
                                    room: chatKey,
                                    sent_at: messageTime, // time of message
                                    messageId: messageId, // include the messageId
                                  });

                                  // Notify the admin that they joined the chat
                                  socket.emit(
                                    "chat joined",
                                    encryptData(
                                    `Joined chat with client ${client_id}`
                                    )
                                  );

                                  delete offlineAdminChats[user.user_id];
                                }
                              );
                            }
                          );
                        }
                      );
                    }
                  );
                }
              }
            );
          }
        });
      });
      socket.on("blocked_visitor_to_chat", (data) => {
        const { client_id, public_key, value } = data;
        const chatKey = `${public_key}_${client_id}`;
        console.log("client id", client_id);
        console.log("public ", public_key);

        console.log(`Visitor ${client_id} blocked by admin.`);
        // Emit the chat message with the messageId
        io.to(chatKey).emit("toggle chat widget", {
          value: value,
          client_id,
        });
      });
      //socket for typing and joining admin to chat
      socket.on("typing admin", (data) => {
        const { chatKey, from } = data;
        if (activeChats[chatKey]) {
          //activechatsparticipants will help us to know whether user is joined chat - or - (open chat) 
          // it iwll be remain until socket disconnect  - (admin)
          const participants = activechatsparticipants[chatKey].participants;
          io.to(chatKey, {
            type: "typing",
            from,
            chatKey,
          });
          // Check if the user ID is already in the Set of participants
          if (!participants.has(user.user_id)) {
            participants.add(user.user_id);

            const getSessionIdQuery = `
    SELECT session_id FROM chat_sessions WHERE chat_key = ? AND is_active = 1
  `;

            connection.query(getSessionIdQuery, [chatKey], (err, results) => {
              if (err) {
                console.error("Error fetching session_id:", err);
                return;
              }

              if (results.length > 0) {
                const sessionId = results[0].session_id;

                // Check if participant already exists
                const checkParticipantQuery = `
        SELECT * FROM chat_participants 
        WHERE session_id = ? AND user_id = ? AND role = 'admin'
      `;
                
                connection.query(
                  checkParticipantQuery,
                  [sessionId, user.user_id],
                  (err, results) => {
                    if (err) {
                      console.error("Error checking participant:", err);
                      return;
                    }
                    console.log(results);

                    if (results.length > 0) {
                      socket.join(chatKey);
                      console.log(
                        "Active session exists for client:",
                        sessionId
                      );
                      console.log(
                        `Admin ${user.user_id} joined chat with client ${sessionId}`
                      );
                    }else {
                      // Insert new participant into chat_participants
                      const insertParticipantQuery = `
                        INSERT INTO chat_participants (session_id, user_id, role, join_time)
                        VALUES (?, ?, 'admin', NOW())
                      `;
                    
                      connection.query(insertParticipantQuery, [sessionId, user.user_id], (err) => {
                        if (err) {
                          console.error("Error inserting participant:", err);
                          return;
                        }
                    
                        const msg = `${from} has joined the chat`;
                    
                        // Insert the system message
                        const insertMessageQuery = `
                          INSERT INTO chat_messages (session_id, sender_id, message, type, sent_at)
                          VALUES (?, ?, ?, ?, NOW())
                        `;
                    
                        connection.query(insertMessageQuery, [sessionId, user.user_id, msg, "comment"], (err, result) => {
                          if (err) {
                            console.error("Error inserting message:", err);
                            return;
                          }
                    
                          const messageId = result.insertId; // Get the inserted message ID
                          const messageTime = new Date().toISOString(); // Current timestamp
                    
                          // Fetch user's profile image
                          const query = `SELECT profile FROM users WHERE id = ? LIMIT 1`;
                          
                          
                          connection.query(query, [user.user_id], (err, results) => {
                            if (err) {
                              console.error(`Database error while fetching user profile: ${err.message}`);
                              return;
                            }
                    
                            // Ensure `results[0]` exists before accessing `.profile`
                            let profile_url = null;
                            if (results.length > 0 && results[0].profile) {
                              profile_url = `${process.env.BACKEND_URL}/${encodeURIComponent(results[0].profile)}`;
                            }
                    
                            // Add participant to active chat
                            activeChats[chatKey].participants.add(user.user_id);
                            activechatsparticipants[chatKey].participants.add(user.user_id);
                    
                            console.log("Chat message emit for comment");
                            console.log("Sending profile image:", profile_url);
                    
                            // Emit chat message with or without profile_url
                            io.to(chatKey).emit("chat message", {
                              from, // Sender's name
                              msg, // Message content
                              type: "admin", // Message type (admin)
                              msgtype: "comment", // Message subtype
                              room: chatKey, // Room ID
                              sent_at: messageTime, // Time of message
                              messageId, // Message ID
                              ...(profile_url && { profile_url }) // Only add profile_url if it exists
                            });
                    
                            console.log("New participant inserted");
                            socket.join(chatKey);
                          });
                        });
                      });
                    }
                    
                  }
                );
              } else {
                console.log("Chat session not found.");
              }
            });

            console.log("Participant added.");
          } else {
            // Broadcast typing event to all clients in the chat room
            socket
              .to(chatKey)
              .emit("typing", { userId: socket.id, name: from, chatKey });
          }
        } else {
          console.log("Chat not found.");
        }
      });

      // Handle stop typing event
      socket.on("stop typing admin", (data) => {
        const { chatKey, from } = data;
        // Broadcast stop typing event to all clients in the chat room
        socket
          .to(chatKey)
          .emit("stop typing",  { userId: socket.id, name: from, chatKey });
      });
      //handle to update client data name email phone notes tags
      // Listen for 'update client data' event from frontend
      socket.on("update client data", (data) => {
        const { client_id, public_key, name, email, phone, notes, tags } = data;
        console.log("Received client data update:", {
          client_id,
          public_key,
          name,
          email,
          phone,
          notes,
          tags,
        });

        // Fetch the chat session using chat_key (public_key + _ + client_id)
        const chatKey = `${public_key}_${client_id}`;
        const getChatSessionQuery = `
            SELECT * FROM chat_sessions 
            WHERE chat_key = ? AND is_active = 1
          `;

        connection.query(
          getChatSessionQuery,
          [chatKey],
          (err, chatSessionResult) => {
            if (err) {
              console.error("Error fetching chat session:", err);
              socket.emit("error", "Error fetching chat session.");
              return;
            }

            if (chatSessionResult.length === 0) {
              console.error(
                "No chat session found with the provided chat_key."
              );
              socket.emit("error", "No chat session found.");
              return;
            }

            // Update the client data in the `client` table
            const updateClientQuery = `
              UPDATE client 
              SET name = ?, email = ?, phone = ? 
              WHERE client_id = ? 
            `;

            const tagString = JSON.stringify(tags); // Store tags as JSON string
            connection.query(
              updateClientQuery,
              [name, email, phone, client_id],
              (err, result) => {
                if (err) {
                  console.error("Error updating client data:", err);
                  socket.emit("error", "Error updating client data.");
                  return;
                }

                console.log(
                  "Client data updated successfully for client_id:",
                  client_id
                );

                // Update the tags in the `chat_sessions` table
                const updateChatSessionQuery = `
                  UPDATE chat_sessions 
                  SET tags = ? , notes = ? 
                  WHERE chat_key = ? AND is_active = 1
                `;

                connection.query(
                  updateChatSessionQuery,
                  [tagString, notes, chatKey],
                  (err, chatUpdateResult) => {
                    if (err) {
                      console.error("Error updating chat session tags:", err);
                      socket.emit("error", "Error updating chat session tags.");
                      return;
                    }

                    console.log(
                      "Chat session tags updated successfully for chat_key:",
                      chatKey
                    );

                    const emitEvent = "client data updated";
                    const emitData = {
                      client_id,
                      public_key,
                      name,
                      email,
                      phone,
                      notes,
                      tags,
                    };

                    // Call the function with dynamic event and data
                    notifyAssignedAdmins(
                      public_key,
                      connection,
                      adminSockets,
                      emitEvent,
                      emitData
                    );
                  }
                );
              }
            );
          }
        );
      });
      //updated here 
      // handle seen messages by admin
//       socket.on("is_chat_seen", (data) => {
//         const { chatKey, client_id, public_key, isSeen ,user_id } = data;

//         console.log("Marking all unseen messages as seen for chat:", chatKey);

//         // Update all unseen messages for the session to seen
//         const updateSeenQuery = `
//     UPDATE chat_messages
//     SET is_seen = 1
//     WHERE session_id = (
//         SELECT session_id 
//         FROM chat_sessions 
//         WHERE public_key = ? 
//         AND client_id = ? 
//         AND is_active = ?
//     )
//     AND sender_id = ?
//     AND is_seen = 0
// `;

//         connection.query(
//           updateSeenQuery,
//           [public_key, client_id, 1, client_id],
//           (err, result) => {
//             if (err) {
//               console.error("Error updating messages as seen:", err);
//               return;
//             }

//             if (result.affectedRows > 0) {
//               console.log(
//                 `All unseen messages marked as seen for chat ${chatKey}.`
//               );

//               const emitEvent = "message_seen";
//               const emitData = {
//                 client_id,
//                 public_key,
//                 isSeen,
//               };

//               // Notify admins that all messages were marked as seen
//               notifyAssignedAdmins(
//                 public_key,
//                 connection,
//                 adminSockets,
//                 emitEvent,
//                 emitData
//               );
//             } else {
//               console.log(`No unseen messages found for chat ${chatKey}.`);
//             }
//           }
//         );
//       });
socket.on("is_chat_seen", (data) => {
  const { chatKey, client_id, public_key, isSeen, user_id } = data;
  const user_type = 'admin';
  console.log(`Marking unseen messages as seen for user ${user_id} in chat: ${chatKey}`);

  // Query to get session_id
  const sessionQuery = `
      SELECT session_id FROM chat_sessions 
      WHERE public_key = ? AND client_id = ? AND is_active = 1
  `;

  connection.query(sessionQuery, [public_key, client_id], (err, results) => {
      if (err) {
          console.error("Error fetching session:", err);
          return;
      }

      if (results.length === 0) {
          console.log("No active session found.");
          return;
      }

      const session_id = results[0].session_id;

      // Insert into chat_seens table (ignores duplicates)
      const seenQuery = `
          INSERT IGNORE INTO chat_seens (session_id, message_id, participant_id, participant_type)
          SELECT ?, message_id, ?, ? FROM chat_messages 
          WHERE session_id = ? AND sender_id != ? AND message_id NOT IN (
              SELECT message_id FROM chat_seens WHERE participant_id = ?
          )
      `;

      connection.query(
          seenQuery,
          [session_id, user_id, user_type, session_id, user_id, user_id],
          (err, result) => {
              if (err) {
                  console.error("Error marking messages as seen:", err);
                  return;
              }

              if (result.affectedRows > 0) {
                  console.log(`Messages marked as seen for user ${user_id} in chat ${chatKey}`);

                  const emitEvent = "message_seen";
                  const emitData = { client_id, public_key, isSeen, user_id };

                  // Notify admins that this user has seen the messages
                  notifyAssignedAdmins(public_key, connection, adminSockets, emitEvent, emitData);
              } else {
                  console.log(`No new messages to mark as seen for user ${user_id} in chat ${chatKey}`);
              }
          }
      );
  });
});

      // Listen for 'admin file' event
      socket.on("admin file", async (fileData) => {
        try {
          console.log("File received:", fileData);

          // Decode Base64 file string and get the file extension
          const base64Data = fileData.file.split(";base64,").pop();
          const extension = fileData.fileType.split("/")[1]; // e.g., jpg, png

          // Generate a unique file name using uuid
          const fileName = `${uuidv4()}.${extension}`;
          const filePath = path.join(__dirname, "uploads", fileName);

          // Write the file to the server's filesystem
          fs.writeFile(filePath, base64Data, { encoding: "base64" }, (err) => {
            if (err) {
              console.error("Error saving the file:", err);
              return;
            }

            console.log(`File saved successfully: ${fileName}`);

            // Now emit the file URL back to the clients
            io.emit("chat file",encryptData( {
              fileUrl: `/uploads/${fileName}`, // Send back the path where the file is stored
              fileName: fileData.fileName,
              fileType: fileData.fileType,
              from: fileData.from,
              sent_at: fileData.sent_at,
            }));
          });
        } catch (error) {
          console.error("Error processing file:", error);
        }
      });
      // Handle admin messages
      socket.on("admin message", (data) => {
        const { client_id, msg, public_key, from, type } = data;
        const chatKey = `${public_key}_${client_id}`;

        //on admin message will recieve admin name and admin id

        //no need to check from database directly get from ram memory for faster
        // Check if there's an active session
        const checkSessionQuery = `SELECT * FROM chat_sessions WHERE client_id = ? AND is_active = 1`;
        connection.query(checkSessionQuery, [client_id], (err, results) => {
          if (err) {
            console.error("Error checking active session:", err);
            return;
          }

          let sessionId;
          if (results.length > 0) {
            // Active session exists
            sessionId = results[0].session_id;
          } else {
            const checkVisitorStatusQuery = `SELECT id FROM visitor_session WHERE client_id = ? AND status != ?`;
            connection.query(
              checkVisitorStatusQuery,
              [client_id, 4],
              (err, visitorResults) => {
                if (err) {
                  console.error("Error checking client status:", err);
                  return;
                }
                if (visitorResults.length > 0) {
                  const visitorId = visitorResults[0].id;
                  const insertSessionQuery = `
              INSERT INTO chat_sessions (
                chat_key, public_key, served_by, client_id, visitor_id, chat_initiated_time, is_active
              ) VALUES (?, ?, ?, ?, ?, NOW(), 1)
            `;

                  connection.query(
                    insertSessionQuery,
                    [chatKey, public_key, user.user_id, client_id, visitorId],
                    (err, result) => {
                      if (err) {
                        console.error(
                          "Error inserting1 new chat session:",
                          err
                        );
                        return;
                      }

                      sessionId = result.insertId;
                      console.log(
                        "New chat session created by admin:",
                        sessionId
                      );

                      // Add admin as a participant
                      const insertParticipantQuery = `
                  INSERT INTO chat_participants (session_id, user_id, role, join_time)
                  VALUES (?, ?, 'admin', NOW())
                `;

                      connection.query(
                        insertParticipantQuery,
                        [sessionId, user.user_id],
                        (err) => {
                          if (err) {
                            console.error("Error inserting participant:", err);
                            return;
                          }

                          const msg = `${user.pseudonym} has joined the chat`;

                          // Insert welcome message and get message ID
                          const insertMessageQuery = `
                      INSERT INTO chat_messages (session_id, sender_id, message, type, sent_at)
                      VALUES (?, ?, ?, ?, NOW())
                    `;

                          connection.query(
                            insertMessageQuery,
                            [sessionId, user.user_id, msg, "comment"],
                            (err, result) => {
                              if (err) {
                                console.error("Error inserting message:", err);
                                return;
                              }

                              const messageId = result.insertId; // Get the inserted message ID
                              const messageTime = new Date().toISOString(); // Get current time in ISO format

                              // Emit the welcome message with message ID
                              io.to(chatKey).emit("chat message",  {
                                from: user.pseudonym, // sender's name
                                msg, // the actual message
                                type: "admin", // message type (admin)
                                msgtype: "comment", // message subtype (e.g., comment)
                                room: chatKey, // room identifier
                                sent_at: messageTime, // time of message
                                messageId: messageId, // message ID
                              });

                              console.log(
                                "Admin added as participant and message emitted."
                              );
                              socket.join(chatKey);
                            }
                          );
                        }
                      );
                    }
                  );
                } else {
                  socket.emit("visitor_already_left",encryptData( {
                    client_id,
                    msg: "Visitor already left the chat",
                  }));
                }
                // No active session exists, create a new session...
              }
            );
          }
          console.log("session id = ", sessionId);
          // Send the message
          const insertMessageQuery = `
            INSERT INTO chat_messages (session_id, sender_id, message, type,sent_at)
            VALUES (?, ?, ?, ?, NOW())
          `;
          connection.query(
            insertMessageQuery,
            [sessionId, user.user_id, msg, type],
            (err, result) => {
              if (err) {
                console.error("Error inserting message:", err);
                return;
              }

              // Retrieve the inserted message ID
              const messageId = result.insertId; // MySQL provides the last inserted ID

              const messageTime = new Date().toISOString();

              // Emit the chat message with the messageId
              io.to(chatKey).emit("chat message",  {
                from: from, // from: sender name
                msg,
                type: "admin",
                msgtype: type,
                room: chatKey,
                sent_at: messageTime, // time of message
                messageId: messageId, // include the messageId
              });

              console.log(
                `Admin ${user.user_id} sent message to chat ${chatKey}: ${msg}`
              );
              // --- Check the status of the client in visitor_session ---
              const checkVisitorStatusQuery = `SELECT status FROM visitor_session WHERE client_id = ? AND status = ?`;
              connection.query(
                checkVisitorStatusQuery,
                [client_id, 3],
                (err, visitorResults) => {
                  if (err) {
                    console.error("Error checking client status:", err);
                    return;
                  }
                  console.log(visitorResults);

                  if (visitorResults.length > 0) {
                    const clientStatus = visitorResults[0].status;
                    console.log(clientStatus);
                    console.log(user.user_id);
                    console.log(sessionId);

                    // If the client status is 3, count the unseen messages
                    if (clientStatus === 3) {
                      const countUnseenMessagesQuery = `
              SELECT COUNT(*) AS unseenCount
              FROM chat_messages
              WHERE session_id = ? AND sender_id = ? AND is_seen = 0 AND type = ?
            `;

                      connection.query(
                        countUnseenMessagesQuery,
                        [sessionId, user.user_id, "chat"],
                        (err, messageCountResults) => {
                          if (err) {
                            console.error(
                              "Error counting unseen messages:",
                              err
                            );
                            return;
                          }

                          const unseenMessages =
                            messageCountResults[0].unseenCount;

                          // Emit the unseen messages count to the client
                          io.to(chatKey).emit("unseen messages from admin",  {
                            unseenMessages,
                            client_id: client_id,
                          });

                          console.log(
                            `Emitting unseen messages to client: ${unseenMessages}`
                          );
                        }
                      );
                    }
                  }
                }
              );
            }
          );
        });
      });
      socket.on("admin_closed_chat", (user) => {
        const chatKey = `${user.public_key}_${user.client_id}`;
        console.log("admin left the chat from", chatKey);
        console.log(activeChats[chatKey]);
        //active chats will handle where user open chat or closed
        activeChats[chatKey]?.participants.delete(user.user_id);
        console.log(activeChats[chatKey]);
      });

      socket.on("disconnect", () => {
        console.log(`Admin ${user.user_id} disconnected`);

        // Remove user from all active chat rooms
        for (const chatKey in activeChats) {
          if (activeChats[chatKey]?.participants) {
            activeChats[chatKey].participants.delete(user.user_id);
          }
          if (activechatsparticipants[chatKey]?.participants) {
            activechatsparticipants[chatKey].participants.delete(user.user_id);
          }

          // Optional: Clean up empty chats if no participants left
          if (activeChats[chatKey]?.participants.size === 0) {
            delete activeChats[chatKey];
            console.log(`Removed empty chat room: ${chatKey}`);
          }
        }

        // Remove the specific socket connection for this user and device
        if (adminSockets[user.user_id]) {
          adminSockets[user.user_id] = adminSockets[user.user_id].filter(
            (conn) => conn.socketId !== socket.id
          );

          // If no active connections are left for the user, remove the entry
          if (adminSockets[user.user_id].length === 0) {
            delete adminSockets[user.user_id];
            console.log(`All connections removed for user ${user.user_id}`);

            // Emit offline_admin event to all connected admins
            for (const adminId in adminSockets) {
              adminSockets[adminId].forEach((adminSocket) => {
                adminSocket.socket.emit("offline_admin",encryptData( {
                  userId: user.user_id,
                  message: `Admin ${user.user_id} is now offline`,
                }));
              });
            }
          }
        }
      });
    } else {
      
      console.log("Client connected");
      const { client_id, public_key } = user;
      console.log(connectedClients[client_id]);
      console.log(connectedClients);

      const chatKey = `${public_key}_${client_id}`;

      socket.join(chatKey);

      if (!visitorState[client_id]) {
        // Initialize a new visitor state if it doesn't exist
        visitorState[client_id] = {
          inactivityTimeout: null,
          disconnectTimeout: null,
          statusTimeout: null,
          lastStatus: 1, // Initialize as active (status 1)
          currentStatus: 1,
          isConnected: true,
          public_key: public_key || null, // Set public key if available
        };
        console.log("New visitor session created for client", client_id);
      } else {
        console.log("Existing session found for client", client_id);

        // Clear any existing timeouts to avoid duplication
        if (visitorState[client_id].inactivityTimeout) {
          clearTimeout(visitorState[client_id].inactivityTimeout);
          visitorState[client_id].inactivityTimeout = null;
          console.log(
            "Cleared existing inactivityTimeout for client",
            client_id
          );
        }

        if (visitorState[client_id].statusTimeout) {
          clearTimeout(visitorState[client_id].statusTimeout);
          visitorState[client_id].statusTimeout = null;
          console.log("Cleared existing statusTimeout for client", client_id);
        }

        if (visitorState[client_id].disconnectTimeout) {
          clearTimeout(visitorState[client_id].disconnectTimeout);
          visitorState[client_id].disconnectTimeout = null;
          console.log(
            "Cleared existing disconnectTimeout for client",
            client_id
          );
        }

        // Reset status based on last known status (before disconnection)
        let visitorStatus = visitorState[client_id].lastStatus === 3 ? 3 : 1;
        const resetStatusQuery = `
    UPDATE visitor_session
    SET status = ?
    WHERE client_id = ? AND status != 4
  `;
        connection.query(
          resetStatusQuery,
          [visitorStatus, client_id],
          (err) => {
            if (err) {
              console.error("Error resetting visitor session status:", err);
            } else {
              console.log(
                `Visitor session status reset to active for client ${client_id}`
              );
              notifyUser(public_key, visitorStatus, "Visitor status change");
              checkAllowedUserAreOnlineOrNot(public_key, socket, client_id,  connection, adminSockets , chatKey)
            }
          }
        );
        // clearTimeout(visitorState[client_id].public_key);
        visitorState[client_id].isConnected = true;
        visitorState[client_id].public_key = public_key;
      }
      console.log("visotor is here");
      //function for sending auto reply if no valid users online 
     
      // Function to handle the final disconnection and database updates after 2 minutes

      const handleDisconnectTimeout = (client_id, public_key) => {
        console.log("Handling disconnection for:", client_id, public_key);
        const chatKey = `${public_key}_${client_id}`;
        const disconnectTime = new Date();
        const getSessionQuery = `   SELECT session_id FROM chat_sessions 
    WHERE client_id = ? AND is_active = 1 LIMIT 1`;

        connection.query(
          getSessionQuery,
          [client_id],
          (err, sessionResults) => {
            if (err) {
              console.error("Error fetching session:", err);
              socket.emit("rating submission failed", {
                success: false,
                message: "Error fetching active session.",
              });
              return;
            }

            if (sessionResults.length > 0) {
              const sessionId = sessionResults[0].session_id;

              const insertMessageQuery = `
                INSERT INTO chat_messages (session_id, sender_id, message, type, sent_at)
                VALUES (?, ?, ?, ?, NOW())
              `;

              connection.query(
                insertMessageQuery,
                [sessionId, client_id, "visitor left the chat", "comment"],
                (err, result) => {
                  if (err) {
                    console.error("Error inserting message:", err);
                    return;
                  }
                  if (result && result.insertId) {
                    // Extract the message ID
                    const messageId = result.insertId;
                    // Emit the socket event after successful insertion
                    io.to(chatKey).emit("chat message", {
                      from: client_id, // sender's name
                      msg: "visitor left the chat", // the actual message
                      type: "client", // message type (admin)
                      msgtype: "comment", // message subtype (e.g., comment)
                      room: chatKey, // room identifier
                      sent_at: new Date().toISOString(), // time of message
                      messageId: messageId, // message ID
                    });
                  }
                }
              );
            }
          }
        );

        // Update visitor session status to disconnected (status = 4)
        const updateStatusQuery =
          "UPDATE visitor_session SET status = 4, left_time = ? WHERE client_id = ? AND status != 4";

        connection.query(
          updateStatusQuery,
          [disconnectTime, client_id],
          (err) => {
            if (err) {
              console.error("Error updating visitor session status to 4:", err);
            } else {
              notifyUser(public_key, 4, "client disconnected");
              console.log(
                `Visitor session status set to 4 for client ${client_id}`
              );
              delete activeChats[chatKey];
              delete connectedClients[client_id];
              delete visitorState[client_id];
              delete activechatsparticipants[chatKey];
              // Fetch client details to emit
              const clientDataQuery = `
    SELECT 
        c.client_id, 
        c.name AS client_name, 
        cs.served_by, 
        cs.session_id AS chat_session_id, 
        ab.name AS brand_name, 
        vs.landing_url,
        vs.id AS visitor_session_id, 
        vs.IP_Health, 
        v.created_at, 
        v.ip, 
        v.country, 
        v.browser, 
        v.os, 
        vs.join_time, 
        vs.left_time 
    FROM 
        visitor_session vs 
    JOIN 
        visitors v ON v.client_id = vs.client_id 
    JOIN 
        chat_sessions cs ON vs.chat_session_id = cs.session_id 
    JOIN 
        client c ON cs.client_id = c.client_id 
    JOIN 
        brands ab ON vs.public_key = ab.public_key 
    WHERE 
        vs.client_id = ? 
        AND vs.status = 4 
        AND v.created_at = (
            SELECT MAX(created_at) 
            FROM visitors 
            WHERE client_id = vs.client_id
        )
    ORDER BY 
        vs.join_time DESC 
    LIMIT 1;
`;

              connection.query(clientDataQuery, [client_id], (err, results) => {
                if (err) {
                  console.error("Error fetching client data:", err);
                } else {
                  const clientInfo = results[0]; // Assuming only one record for a client

                  // Emit the client data to assigned admins
                  if (clientInfo) {
                    const updateFields = {
                      client_id: clientInfo.client_id,
                      client_name: clientInfo.client_name,
                      served_by: clientInfo.served_by,
                      chat_session_id: clientInfo.chat_session_id,
                      brand_name: clientInfo.brand_name,
                      landing_url: clientInfo.landing_url,
                      IP_Health: clientInfo.IP_Health,
                      created_at: clientInfo.created_at,
                      ip: clientInfo.ip,
                      visitor_session_id: clientInfo.visitor_session_id,
                      country: clientInfo.country,
                      browser: clientInfo.browser,
                      os: clientInfo.os,
                      join_time: clientInfo.join_time,
                      left_time: clientInfo.left_time, // Use the disconnect time
                    };

                    notifyAssignedAdmins(
                      public_key,
                      connection,
                      adminSockets,
                      "client History updated",
                      updateFields
                    );
                  }
                }
              });

              console.log(
                `Status updated to 4 after disconnection for client ${client_id}`
              );
            }
          }
        );

        // Update chat_sessions to inactive (is_active = 0)
        const updateChatSessionQuery =
          "UPDATE chat_sessions SET is_active = 0 WHERE client_id = ? AND is_active = 1";

        connection.query(updateChatSessionQuery, [client_id], (err) => {
          if (err) {
            console.error(
              "Error updating chat session status to inactive:",
              err
            );
          } else {
            console.log(`Chat session set to inactive for client ${client_id}`);
          }
        });

        // Clear inactivity timeout if it exists
        if (visitorState[client_id]?.inactivityTimeout) {
          clearTimeout(visitorState[client_id].inactivityTimeout);
          delete visitorState[client_id].inactivityTimeout; // Optionally delete the timeout
          console.log(`Inactivity timeout cleared for client ${client_id}`);
        }

        // Clear disconnect timeout
        delete visitorState[client_id]; // Clear visitor state after disconnect
      };

      const handleStatusChange = (client_id, public_key, newStatus) => {
        if (visitorState[client_id]?.statusLock) return;
        visitorState[client_id].statusLock = true;

        const updateStatusQuery = `
            UPDATE visitor_session
            SET status = ?
            WHERE client_id = ? AND status != 4 `;
        connection.query(updateStatusQuery, [newStatus, client_id], (err) => {
          visitorState[client_id].statusLock = false; // Release lock
          if (err) {
            console.error("Error updating visitor session:", err);
          } else {
            console.log(
              `Visitor status updated to ${newStatus} for client ${client_id}`
            );
            notifyUser(public_key, newStatus, "Visitor status change");
          }
        });
      };

      const resetInactivityTimeout = (client_id, public_key) => {
        // Check if visitorState[client_id] exists
        if (!visitorState[client_id]) {
          visitorState[client_id] = {}; // Initialize if it doesn't exist
        }

        // Clear existing timeout if it exists
        if (visitorState[client_id].inactivityTimeout) {
          clearTimeout(visitorState[client_id].inactivityTimeout);

          notifyUser(public_key, 1, "active");
        }

        // Update public_key (avoid overwriting entire visitor state)
        visitorState[client_id].public_key = public_key;

        // Set new inactivity timeout
        visitorState[client_id].inactivityTimeout = setTimeout(() => {
          // Check for public_key in the state, fallback to function argument
          const currentPublicKey =
            visitorState[client_id].public_key || public_key;
          handleInactivity(client_id, currentPublicKey);
        }, INACTIVITYT_IMEOUT); // 5 minutes for inactivity
      };

      // Handle inactivity
      function handleInactivity(client_id, public_key) {
        const updateStatusQuery =
          "UPDATE visitor_session SET status = 2 WHERE client_id = ? AND status != 4";
        connection.query(updateStatusQuery, [client_id], (err) => {
          if (err) {
            console.error(
              "Error updating visitor session status due to inactivity:",
              err
            );
          } else {
            const status = 2;
            notifyUser(public_key, status, "visitor is idle");
            console.log(
              `Status updated to 2 due to inactivity for client ${client_id}`
            );
          }
        });
      }

      function notifyUser(public_key, status, message) {
        // Query to fetch the latest visitor_id for the given client_id
        if (visitorState[client_id]) {
          // Update currentStatus if the client_id exists in visitorState
          visitorState[client_id].currentStatus = status;
        } else {
          // Handle the case where client_id is not in visitorState
          console.error(
            `client_id ${client_id} does not exist in visitorState`
          );
          // Optionally, you can initialize it if required:
          // visitorState[client_id] = { currentStatus: status };
        }

        const visitorQuery = `
            SELECT id
            FROM visitor_session
            WHERE client_id = ?
            ORDER BY join_time DESC
            LIMIT 1
        `;

        connection.query(visitorQuery, [client_id], (err, visitorResults) => {
          if (err) {
            console.error("Error fetching latest visitor_id:", err);
            return;
          }

          // Ensure visitor_id is fetched successfully
          const visitor_id =
            visitorResults.length > 0 ? visitorResults[0].id : null;

          // Query to fetch all assigned admins for the brand
          const assignedAdminsQuery = `
             SELECT user_id 
FROM brand_assignees 
WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
AND status = 1

                `;

          connection.query(
            assignedAdminsQuery,
            [public_key],
            (err, adminResults) => {
              if (err) {
                console.error(
                  "Error fetching assigned admins on disconnect:",
                  err
                );
                return;
              }

              // Client with ID m3fwv77vpd is not connected.
              // Notify each assigned admin about the visitor's status change
              // Notify each assigned admin about the visitor's status change
              adminResults.forEach((row) => {
                const adminConnections = adminSockets[row.user_id];
                if (adminConnections && adminConnections.length > 0) {
                  adminConnections.forEach((connection) => {
                    connection.socket.emit("visitor status change",encryptData( {
                      client_id,    
                      visitor_id, // Include the latest visitor_id in the emitted data
                      status,
                      public_key,
                    }));
                  });
                } else {
                  console.log(
                    `No active connections found for admin ${row.user_id}`
                  );
                }
              });
            }
          );
        });
      }

      // Check if there is an active visitor session with status != 4 (4 == left the website)
      const checkQuery =
        "SELECT * FROM visitor_session WHERE client_id = ? AND status != ?";
      connection.query(checkQuery, [client_id, 4], (error, results) => {
        if (error) {
          console.error("Error checking visitor session:", error);
          return;
        }

        // if existing session found
        if (results.length > 0) {
          // status will  be check if it's change like 2,3, then it will be one
          //..................code..................

          // Emit chat history to the visitor for the existing active chat session
          function emitChatHistory(client_id, chatKey) {
            const getActiveSessionQuery = `SELECT * FROM chat_sessions WHERE chat_key = ? AND is_active = 1 LIMIT 1`;
          
            connection.query(getActiveSessionQuery, [chatKey], (err, activeSession) => {
              if (err) {
                console.error("Error fetching active session:", err);
                return;
              }
          
              if (activeSession.length > 0) {
                const sessionId = activeSession[0].session_id;
          
                // Fetch participants and messages for the session
                getParticipantsWithNames(sessionId, (participantsErr, participants) => {
                  if (participantsErr) {
                    console.error("Error fetching participants:", participantsErr);
                    return;
                  }
          
                  getMessagesBySessionId(sessionId, (messagesErr, messages) => {
                    if (messagesErr) {
                      console.error("Error fetching messages:", messagesErr);
                      return;
                    }
          
                    // Get admin participants and fetch their profile URLs
                    const adminParticipants = participants.filter((p) => p.role === "admin");
          
                    if (adminParticipants.length > 0) {
                      const adminIds = adminParticipants.map((admin) => admin.user_id);
                      const getAdminProfilesQuery = `SELECT id, profile FROM users WHERE id IN (?)`;
          
                      connection.query(getAdminProfilesQuery, [adminIds], (profileErr, adminProfiles) => {
                        if (profileErr) {
                          console.error("Error fetching admin profiles:", profileErr);
                          return;
                        }
          
                        // Create joined_users array
                        const joined_users = adminParticipants.map((admin) => {
                          console.log('admin profile details ');
                          
                          console.log(admin)
                          const adminProfile = adminProfiles.find((p) => p.id == admin.user_id);
                          console.log(adminProfile)
                          return {
                            name: admin.pseudonym,
                            p_m: adminProfile ? `${process.env.BACKEND_URL}/${encodeURIComponent(adminProfile.profile)}` : null,
                          };
                        });
          
                        // Format messages
                        const formattedMessages = messages.map((message) => {
                          const sender = participants.find((p) => p.user_id === message.sender_id);
          
                          let senderType = "system";
                          if (sender) {
                            senderType = sender.role === "admin" ? "admin" : "client";
                          }
          
                          return {
                            from: sender ? sender.pseudonym : "system",
                            msg: message.message,
                            type: senderType,
                            msgtype: message.type,
                            room: chatKey,
                            sent_at: message.sent_at,
                            messageId: message.message_id,
                            is_seen: message.is_seen,
                          };
                        });
          
                        // Emit chat history with joined_users
                        socket.emit("chat history", {
                          messages: formattedMessages,
                          joined_users,
                        });
                      });
                    } else {
                      // Emit without joined_users if no admins are present
                      const formattedMessages = messages.map((message) => {
                        const sender = participants.find((p) => p.user_id === message.sender_id);
          
                        let senderType = "system";
                        if (sender) {
                          senderType = sender.role === "admin" ? "admin" : "client";
                        }
          
                        return {
                          from: sender ? sender.pseudonym : "system",
                          msg: message.message,
                          type: senderType,
                          msgtype: message.type,
                          room: chatKey,
                          sent_at: message.sent_at,
                          messageId: message.message_id,
                          is_seen: message.is_seen,
                        };
                      });
          
                      socket.emit("chat history", {
                        messages: formattedMessages,
                        joined_users: [],
                      });
                    }
                  });
                });
              }
            });
          }
          
          // If a visitor session exists, check the last disconnect time
          const visitorSession = results[0];

          //chat will be emit to visitor
          // socket.emit('chat history', visitorSession);
          const visitorStatus = {
            status: visitorSession.status,
            client_id: client_id,
          };

          console.log(
            "Reconnect within one minute, using the existing session."
          );

          socket.on("get chat history", (data) => {
            const clientSocketIds = connectedClients[client_id];

            if (clientSocketIds && clientSocketIds.length > 0) {
              console.log(clientSocketIds);
              console.log("clientSocketIds");

              // Filter out invalid sockets
              const validSockets = clientSocketIds
                .map((socketId) => io.sockets.sockets.get(socketId))
                .filter((socket) => socket);

              if (validSockets.length > 0) {
                console.log(
                  "Valid sockets found:",
                  validSockets.map((s) => s.id)
                );

                // Emit visitor status and other data
                validSockets.forEach((socket) =>
                  socket.emit("visitor status", visitorStatus)
                );

                fetchClientDetails(client_id, validSockets);
                emitChatHistory(client_id, `${public_key}_${client_id}`);
                getChatMeta(client_id, public_key, validSockets);
              } else {
                console.log("No valid sockets connected for this client.");
              }
            } else {
              socket.emit(
                "error",
                encryptData({ message: "No connected sockets for this client" })
              );
            }
          });

          resetInactivityTimeout(client_id, public_key);
          // Continue using the existing session, notify the admin, etc.
        } else {
          // No active visitor session found. Creating a new session...
          console.log(
            "No active visitor session found. Creating a new session..."
          );
          // Function to handle rating submission
          socket.on("get chat history", (data) => {
            const clientSocketIds = connectedClients[client_id];

            if (clientSocketIds && clientSocketIds.length > 0) {
              console.log(clientSocketIds);
              console.log("clientSocketIds");

              // Filter out invalid sockets
              const validSockets = clientSocketIds
                .map((socketId) => io.sockets.sockets.get(socketId))
                .filter((socket) => socket);

              if (validSockets.length > 0) {
                fetchClientDetails(client_id, validSockets);
              } else {
                console.log("No valid sockets connected for this client.");
              }
            } else {
              socket.emit(
                "error",
                encryptData({ message: "No connected sockets for this client" })
              );
            }
          });
          socket.on("new client", (data) => {
            console.log("new client", data);

            const { clientId, public_key, url, os, browser } = data;
            const client_id = clientId;
            const ip =
              socket.handshake.headers["x-forwarded-for"] ||
              socket.handshake.address;

            // Check if the client already exists in the `client` table by name
            const checkClientQuery = `
              SELECT name FROM client WHERE client_id = ? LIMIT 1
            `;

            connection.query(
              checkClientQuery,
              [client_id],
              (err, clientResult) => {
                if (err) {
                  console.error("Error checking client existence:", err);
                  return;
                }

                const existingClientName =
                  clientResult.length > 0 ? clientResult[0].name : null;

                // Check for an active session in the `visitor_sessions` table where status != 4
                const checkActiveSessionQuery = `
                SELECT * FROM visitor_session 
                WHERE client_id = ? AND status != 4 LIMIT 1
              `;

                connection.query(
                  checkActiveSessionQuery,
                  [client_id],
                  (err, sessionResult) => {
                    if (err) {
                      console.error(
                        "Error checking active visitor session:",
                        err
                      );
                      return;
                    }

                    if (sessionResult.length > 0) {
                      console.log(
                        `Active session already exists for client ${client_id}:`,
                        sessionResult[0]
                      );
                      // checkAllowedUserAreOnlineOrNot(public_key, socket, client_id,  connection, adminSockets , chatKey)
                      return; // Stop execution if an active session already exists
                    }

                    // If no active visitor session exists, create a new one
                    console.log(
                      "No active visitor session found. Creating a new session..."
                    );

                    createNewVisitorSession(
                      client_id,
                      public_key,
                      url,
                      (err, result) => {
                        if (err) {
                          console.error(
                            "Error creating new visitor session:",
                            err
                          );
                       
                          return;
                        }

                        resetInactivityTimeout(clientId, public_key);
                        console.log("New visitor session created:", result);

                        // Notify the admin of the new visitor session
                        const assignedAdminsQuery = `
                      SELECT 
                          ba.user_id, 
                          ba.brand_id, 
                          b.name AS brand_name
                      FROM 
                          brand_assignees ba
                      JOIN 
                          brands b 
                      ON 
                          ba.brand_id = b.id
                      WHERE 
                          ba.brand_id = (SELECT id FROM brands WHERE public_key = ?) 
                          AND ba.status = 1
                    `;

                        connection.query(
                          assignedAdminsQuery,
                          [public_key],
                          async (err, adminResults) => {
                            if (err) {
                              console.error(
                                "Error fetching assigned admins:",
                                err
                              );
                              return;
                            }

                            // Fetch country and city from the IP address using the getGeolocationData function
                            const { countryName, cityName } =
                              await getGeolocationData(ip);

                            adminResults.forEach((row) => {
                              const adminConnections =
                                adminSockets[row.user_id];
                              if (
                                adminConnections &&
                                adminConnections.length > 0
                              ) {
                                adminConnections.forEach((connection) => {
                                  connection.socket.join(chatKey);
                                  connection.socket.emit("new client", encryptData({
                                    client_id,
                                    public_key,
                                    join_time: result.insertId
                                      ? new Date()
                                      : null, // Assuming join_time is NOW()
                                    landing_url: url,
                                    os,
                                    ip,
                                    country: countryName,
                                    city: cityName,
                                    visitor_session_id:
                                      result.sessionResult.insertId,
                                    status: 1,
                                    brand_id: row.brand_id,
                                    brand_name: row.brand_name, // Emit the brand name
                                    browser: browser.name,
                                    client_name: existingClientName, // Include the client's name if it exists
                                  }));

                                  console.log(
                                    `Admin ${
                                      row.user_id
                                    } notified of existing chat with client ${client_id} (${
                                      existingClientName || "New Client"
                                    }) from ${countryName} (${cityName}) on brand ${
                                      row.brand_name
                                    }`
                                  );
                                });
                              } else {
                                console.log(
                                  `No active connections found for admin ${row.user_id}`
                                );
                              }
                            });
                          }
                        );
                      }
                    );
                  }
                );
              }
            );
          });
        }
      });

      // Function to create a new visitor session using a callback
      function createNewVisitorSession(client_id, public_key, url, callback) {
        // Query to create a new visitor session
        const newSessionQuery = `
          INSERT INTO visitor_session (client_id, public_key, landing_url, status, join_time) 
          VALUES (?, ?, ?, ?, NOW())
        `;

        // Execute the query to create the new session
        connection.query(
          newSessionQuery,
          [client_id, public_key, url, 1],
          (err, result) => {
            if (err) {
              console.error("Error creating new visitor session:", err);
              return callback(err, null); // Pass the error to the callback
            }

            // Query to update the last added row in the visitors table
            const updateVisitorQuery = `
            UPDATE visitors
            SET v_session_id = ?
            WHERE client_id = ? 
            ORDER BY created_at DESC 
            LIMIT 1
          `;

            // Execute the query to update the visitor table with the new session ID
            connection.query(
              updateVisitorQuery,
              [result.insertId, client_id],
              (updateErr, updateResult) => {
                if (updateErr) {
                  console.error(
                    "Error updating the visitors table:",
                    updateErr
                  );
                  return callback(updateErr, null); // Pass the update error to the callback
                }
                console.log('new visitor auto reply sending...');
                          
                checkAllowedUserAreOnlineOrNot(public_key, socket, client_id,  connection, adminSockets , chatKey)
                // Pass the result of both queries back to the callback
                callback(null, {
                  sessionResult: result,
                  visitorUpdateResult: updateResult,
                });
              }
            );
          }
        );
      }

      // Track typing users
      const typingUsers = new Map();

      socket.on("startTyping", ({ client_id, text }) => {
        const chatKey = `${public_key}_${client_id}`;
        socket.to(chatKey).emit("displayTyping", encryptData({ client_id, chatKey, text }));

        // Start or refresh typing timeout
        // refreshTypingTimeout(client_id, chatKey);
      });

      socket.on("stillTyping", ({ client_id, text }) => {
        const chatKey = `${public_key}_${client_id}`;

        // Emit the typed text to the room
        socket
          .to(chatKey)
          .emit("updateTypingText",encryptData({ client_id, chatKey, text }));

        // Refresh typing timeout
        // refreshTypingTimeout(client_id, chatKey);
      });

      socket.on("endTyping", ({ client_id }) => {
        const chatKey = `${public_key}_${client_id}`;
        socket.to(chatKey).emit("hideTyping",encryptData( { client_id, chatKey }));
        typingUsers.delete(client_id);
      });

      // Helper function to refresh typing timeout
      function refreshTypingTimeout(client_id, chatKey) {
        // Clear existing timeout for this client
        if (typingUsers.has(client_id)) {
          clearTimeout(typingUsers.get(client_id));
        }

        // Set a new timeout to end typing if no activity
        const timeout = setTimeout(() => {
          socket.to(chatKey).emit("hideTyping", encryptData({ client_id, chatKey }));
          typingUsers.delete(client_id);
        }, 1500); // 1.5-second timeout after the last typing event

        typingUsers.set(client_id, timeout);
      }

      socket.on("submit rating", (data) => {
        const { client_id, public_key, rating } = data; // Assuming rating will be either 1 or 2

        // Step 1: Build chatKey based on client_id and public_key
        const chatKey = `${public_key}_${client_id}`;

        // Step 2: Fetch session_id from chat_sessions using chatKey
        const getSessionQuery = `SELECT session_id FROM chat_sessions WHERE chat_key = ? AND is_active = 1 LIMIT 1`;

        connection.query(getSessionQuery, [chatKey], (err, sessionResults) => {
          if (err) {
            console.error("Error fetching session:", err);
            socket.emit("rating submission failed", {
              success: false,
              message: "Error fetching active session.",
            });
            return;
          }

          if (sessionResults.length > 0) {
            const sessionId = sessionResults[0].session_id;

            // Step 3: Check if the rating is valid (1 or 2)
            const isPositiveRating = rating === 1;

            // Step 4: Insert rating into chat_rate table
            const insertRatingQuery = `INSERT INTO chat_rate (chat_id, rating) VALUES (?, ?)`;

            connection.query(
              insertRatingQuery,
              [sessionId, isPositiveRating ? 1 : 0],
              (err, ratingResults) => {
                if (err) {
                  console.error("Error inserting rating:", err);
                  socket.emit("rating submission failed", {
                    success: false,
                    message: "Error inserting rating.",
                  });
                  return;
                }
                notifyAssignedAdmins(
                  public_key,
                  connection,
                  adminSockets,
                  "rating submit by client",
                  {
                    client_id: client_id,
                    public_key: public_key,
                    rating: rating,
                  }
                );
                const clientSocketIds = connectedClients[client_id];
                if (clientSocketIds && clientSocketIds.length > 0) {
                  // Filter out invalid socket IDs and map to valid socket instances
                  const validSockets = clientSocketIds
                    .map((socketId) => io.sockets.sockets.get(socketId)) // Get the socket instance
                    .filter((socket) => socket); // Keep only valid socket instances

                  if (validSockets.length > 0) {
                    // Step 5: Emit success message back to the client
                    validSockets.forEach((socket) => {
                      socket.emit("rating chat",  {
                        rating: true,
                      }); // Pass valid socket instances
                    });
                  }
                }
              }
            );
          } else {
            // No active session found
            socket.emit("rating submission failed", {
              success: false,
              message: "No active session found.",
            });
          }
        });
      });
      socket.on("update profile of client", (data) => {
        console.log("Updating profile of client:", data);

        const { client_id, name, email, phone } = data;

        // Prepare an object to hold the update fields
        const updateFields = { client_id }; // Include client_id in updateFields

        // Check which fields are provided and add them to the updateFields object
        if (name) {
          updateFields.name = name; // Update name if provided
        }
        if (email) {
          updateFields.email = email; // Update email if provided
        }
        if (phone) {
          updateFields.phone = phone; // Update phone if provided
        }

        // Perform the update operation (e.g., database update)
        if (Object.keys(updateFields).length > 0) {
          // Assuming you have a function to handle the database update
          updateClientProfile(client_id, updateFields)
            .then(() => {
              console.log("Profile updated successfully:", updateFields);
              // Optionally, emit a success message back to the client
              socket.emit("profile update success", {
                message: "Profile updated successfully!",
              });

              notifyAssignedAdmins(
                public_key,
                connection,
                adminSockets,
                "client data updated",
                updateFields
              );
            })
            .catch((error) => {
              console.error("Error updating profile:", error);
              // Optionally, emit an error message back to the client
              socket.emit("profile update error", {
                message: "Failed to update profile.",
              });
            });
        } else {
          console.log("No profile fields provided for update.");
        }
      });

      // Function to update client profile in the database (pseudo-code)
      function updateClientProfile(client_id, updateFields) {
        return new Promise((resolve, reject) => {
          // Example pseudo-code for database update
          const sql = "UPDATE client SET ? WHERE client_id = ?";
          connection.query(sql, [updateFields, client_id], (error, results) => {
            if (error) {
              return reject(error); // Reject promise on error
            }
            resolve(results); // Resolve promise on success
          });
        });
      }

      // Handle visitor status change to 3
      socket.on("visitor status change", (data) => {
        const { client_id, public_key, status } = data;

        // Update the visitorState
        if (visitorState[client_id]) {
          visitorState[client_id].statusTimeout = status;
          visitorState[client_id].lastStatus = status;
        }

        // Notify user with the new status
        notifyUser(public_key, status, "visitor chat status changed");

        // Update visitor session status in the database
        const updateStatusQuery =
          "UPDATE visitor_session SET status = ? WHERE client_id = ? AND status != 4";

        connection.query(updateStatusQuery, [status, client_id], (err) => {
          if (err) {
            console.error("Error updating visitor session status:", err);
          } else {
            console.log(
              `Visitor session status set to ${status} for client ${client_id}`
            );
          }
        });

        // Fetch all connected sockets for the client and emit status change to all
        const clientSocketIds = connectedClients[client_id];
        if (clientSocketIds && clientSocketIds.length > 0) {
          // Filter out invalid socket IDs and map to valid socket instances
          const validSockets = clientSocketIds
            .map((socketId) => io.sockets.sockets.get(socketId)) // Get the socket instance
            .filter((socket) => socket); // Keep only valid socket instances

          if (validSockets.length > 0) {
            // Emit the status change to all valid sockets
            validSockets.forEach((socket) => {
              socket.emit("status changed",  { client_id, status });
            });
          }
        }
      });
      //updated here
      // socket.on("client seen message", (data) => {
      //   const { client_id, public_key, message_id } = data;
      //   console.log("Client seen message ID:", message_id);

      //   const chatKey = `${public_key}_${client_id}`;
      //   console.log("Marking message as seen for chat:", chatKey);

      //   const isSeen = 1;

      //   // Query to update the specific message as seen
      //   const updateMessageSeenQuery = `
      //     UPDATE chat_messages
      //     SET is_seen = ?
      //     WHERE message_id = ?
         
      //   `;

      //   // Query to update all unseen messages in the session as seen (if needed)
      //   const updateAllUnseenQuery = `
      //     UPDATE chat_messages
      //     SET is_seen = ?
      //     WHERE session_id = (
      //       SELECT session_id
      //       FROM chat_sessions
      //       WHERE public_key = ?
      //       AND client_id = ?
      //       AND is_active = ?
      //     )
      //     AND sender_id != ?
      //     AND is_seen = 0
      //   `;

      //   // Update the specific message as seen
      //   connection.query(
      //     updateMessageSeenQuery,
      //     [isSeen, message_id],
      //     (err, result) => {
      //       if (err) {
      //         console.error(
      //           "Error updating the specific message as seen:",
      //           err
      //         );
      //         return;
      //       }

      //       if (result.affectedRows > 0) {
      //         console.log(
      //           `Message ID ${message_id} marked as seen for chat ${chatKey}.`
      //         );

      //         // Notify the assigned admins that the message has been seen
      //         const emitEvent = "message_seen by client";
      //         const emitData = {
      //           client_id,
      //           public_key,
      //           is_seen: isSeen,
      //           message_id,
      //         };

      //         notifyAssignedAdmins(
      //           public_key,
      //           connection,
      //           adminSockets,
      //           emitEvent,
      //           emitData
      //         );
      //       } else {
      //         console.log(
      //           `Message ID ${message_id} is already marked as seen or not found.`
      //         );
      //       }
      //     }
      //   );
      // });
      socket.on("client seen message", (data) => {
        const { client_id, public_key, message_id } = data;
        console.log("Client seen message ID:", message_id);
    
        const chatKey = `${public_key}_${client_id}`;
        console.log("Marking message as seen for chat:", chatKey);
    
        const sessionQuery = `
         SELECT session_id FROM chat_messages WHERE message_id = ?;

        `;
    
        connection.query(sessionQuery, [message_id], (err, results) => {
            if (err) {
                console.error("Error fetching session:", err);
                return;
            }
    
            if (results.length === 0) {
                console.log("No active session found.");
                return;
            }
    
            const session_id = results[0].session_id;
    
            // Insert seen status for the specific message
            const insertSeenQuery = `
                INSERT IGNORE INTO chat_seens (session_id, message_id, participant_id, participant_type)
                VALUES (?, ?, ?, 'client')
            `;
    
            connection.query(insertSeenQuery, [session_id, message_id, client_id], (err, result) => {
                if (err) {
                    console.error("Error marking message as seen:", err);
                    return;
                }
    
                if (result.affectedRows > 0) {
                    console.log(`Message ID ${message_id} marked as seen for client ${client_id} in chat ${chatKey}.`);
    
                    // Notify assigned admins that the client has seen the message
                    const emitEvent = "message_seen by client";
                    const emitData = { client_id, public_key, message_id };
    
                    notifyAssignedAdmins(public_key, connection, adminSockets, emitEvent, emitData);
                } else {
                    console.log(`Message ID ${message_id} already marked as seen.`);
                }
            });
    
            // Insert seen status for all previous unseen messages (excluding client's own messages)
            const insertAllUnseenQuery = `
                INSERT IGNORE INTO chat_seens (session_id, message_id, participant_id, participant_type)
                SELECT ?, id, ?, 'client' FROM chat_messages 
                WHERE session_id = ? AND sender_id != ? AND id NOT IN (
                    SELECT message_id FROM chat_seens WHERE participant_id = ?
                )
            `;
    
            // connection.query(insertAllUnseenQuery, [session_id, client_id, session_id, client_id, client_id], (err, result) => {
            //     if (err) {
            //         console.error("Error marking all unseen messages as seen:", err);
            //         return;
            //     }
    
            //     if (result.affectedRows > 0) {
            //         console.log(`All unseen messages marked as seen for client ${client_id} in chat ${chatKey}.`);
            //     } else {
            //         console.log(`No new unseen messages for client ${client_id}.`);
            //     }
            // });
        });
    });
   
      // Handle visitor messages
      socket.on("chat message", (data) => {
        const { client_id, public_key, message, msgtype,a_replied } = data;
        const msg = message;
        socket.join(chatKey);
        //updated here
        // Function to handle message after session is created or found 
        const handleMessage = async (sessionId) => {
          console.log("Handling message for session:", sessionId);
      
          const checkParticipantQuery = `
              SELECT * FROM chat_participants 
              WHERE session_id = ? AND user_id = ? AND role = 'client'
          `;
      
          connection.query(checkParticipantQuery, [sessionId, client_id], async (err, participantResults) => {
              if (err) {
                  console.error("Error checking participant:", err);
                  return;
              }
      
              if (participantResults.length === 0) {
                  const insertParticipantQuery = `
                      INSERT INTO chat_participants (session_id, user_id, role, join_time)
                      VALUES (?, ?, 'client', NOW())
                  `;
      
                  connection.query(insertParticipantQuery, [sessionId, client_id], (err) => {
                      if (err) {
                          console.error("Error inserting participant:", err);
                          return;
                      }
      
                      console.log(`Visitor added as participant in session ${sessionId}`);
                  });
              }
      
              // **Ensure auto-reply function completes before inserting the message**
              await handleIsUserReceivedAutoReply(client_id, chatKey, connection, public_key, a_replied);
      
              const insertMessageQuery = `
                  INSERT INTO chat_messages (session_id, sender_id, message, type, sent_at)
                  VALUES (?, ?, ?, ?, NOW())
              `;
      
              connection.query(insertMessageQuery, [sessionId, client_id, msg, msgtype], (err, result) => {
                  if (err) {
                      console.error("Error inserting message:", err);
                      return;
                  }
      
                  const messageId = result.insertId;
                  const messageTime = new Date().toISOString();
       // Query to fetch the latest visitor_id for the given client_id
       if (visitorState[client_id]) {
        if (visitorState[client_id].currentStatus == 2) {
          console.log("visitor status is 2 now changing it to 1");

          const resetStatusQuery = `
UPDATE visitor_session
SET status = ?
WHERE client_id = ? AND status != 4
`;
          connection.query(
            resetStatusQuery,
            [1, client_id],
            (err) => {
              if (err) {
                console.error(
                  "Error resetting visitor session status:",
                  err
                );
              } else {
                console.log(
                  `Visitor session status reset to active for client ${client_id}`
                );
                notifyUser(public_key, 1, "Visitor status change");
                resetInactivityTimeout(client_id, public_key);
              }
            }
          );
        }
      } else {
        // Handle the case where client_id is not in visitorState
        console.error(
          `client_id ${client_id} does not exist in visitorState`
        );
        // Optionally, you can initialize it if required:
        // visitorState[client_id] = { currentStatus: status };
      }
                  io.to(chatKey).emit("chat message", {
                      from: client_id,
                      msg,
                      type: "client",
                      room: chatKey,
                      msgtype,
                      sent_at: messageTime,
                      messageId,
                  });
                  
                  console.log(`Visitor sent message to chat ${chatKey}: ${msg}`);
      
                  const countMessagesQuery = `SELECT COUNT(*) AS totalMessages FROM chat_messages WHERE session_id = ? AND type <> 'comment'`;
      
                  connection.query(countMessagesQuery, [sessionId], (err, countResult) => {
                      if (err) {
                          console.error("Error counting total messages:", err);
                          return;
                      }
      
                      const totalMessages = countResult[0].totalMessages;
      
                      const unseenQuery = `
                          SELECT 
                              cp.user_id AS participantId,
                              (SELECT COUNT(*) FROM chat_messages cm
                               WHERE cm.session_id = ? AND cm.sender_id = ? 
                               AND NOT EXISTS (
                                   SELECT 1 FROM chat_seens cs 
                                   WHERE cs.session_id = cm.session_id 
                                   AND cs.message_id = cm.message_id
                                   AND cs.participant_id = cp.user_id
                               )) AS unseenCount
                          FROM chat_participants cp
                          WHERE cp.session_id = ? AND cp.user_id != ?
                      `;
      
                      connection.query(unseenQuery, [sessionId, client_id, sessionId, client_id], (err, unseenResults) => {
                          if (err) {
                              console.error("Error fetching unseen message count:", err);
                              return;
                          }
      
                          const unseenMap = {};
                          let hasParticipants = false;
      
                          unseenResults.forEach(({ participantId, unseenCount }) => {
                              hasParticipants = true;
                              unseenMap[participantId] = unseenCount;
                          });
      
                          notifyChatParticipants(
                              public_key,
                              socket,
                              client_id,
                              a_replied,
                              connection,
                              adminSockets,
                              "New message blink",
                              {
                                  messageId,
                                  is_seen: false,
                                  client_id,
                                  unseenCounts: unseenMap,
                                  totalMessages,
                                  public_key,
                                  notifyAllAdmins: !hasParticipants,
                              }
                          );
                      });
                  });
              });
          });
      };
      
       
      


        // Check if there's an active session for the client
        const checkSessionQuery = `SELECT * FROM chat_sessions WHERE client_id = ? AND is_active = 1`;

        connection.query(checkSessionQuery, [client_id], (err, results) => {
          if (err) {
            console.error("Error checking active session:", err);
            return;
          }

          let sessionId;

          if (results.length > 0) {
            // Active session exists
            sessionId = results[0].session_id;
            console.log("Active session exists for client:", client_id);
            handleMessage(sessionId);
          } else {
            // No active session, create a new one
            const findVisitorSessionQuery = `
        SELECT id 
        FROM visitor_session 
        WHERE client_id = ? 
        AND status != 4
        ORDER BY id DESC
        LIMIT 1
      `;

            connection.query(
              findVisitorSessionQuery,
              [client_id],
              (err, result) => {
                if (err) {
                  console.error("Error fetching visitor session:", err);
                  return;
                }

                let visitorId;

                if (result.length > 0) {
                  // Found an active session, use the existing visitor_id
                  visitorId = result[0].id;
                  console.log("Using existing visitor session:", visitorId);
                } else {
                  // No active session exists, use socket.id as visitor_id
                  visitorId = socket.id;
                  console.log(
                    "No active session found, using socket.id as visitor_id:",
                    visitorId
                  );
                  return;
                }

                // Insert new chat session with either the found visitor_id or socket.id
                const insertSessionQuery = `
          INSERT INTO chat_sessions (
            chat_key, public_key, served_by, client_id, visitor_id, chat_initiated_time, is_active
          ) VALUES (?, ?, '', ?, ?, NOW(), 1)
        `;

                connection.query(
                  insertSessionQuery,
                  [chatKey, public_key, client_id, visitorId],
                  (err, result) => {
                    if (err) {
                      console.error("Error inserting2 new chat session:", err);
                      return;
                    }

                    sessionId = result.insertId;
                    // Now update the visitor_session with the new chat_session_id
                    const updateVisitorSessionQuery = `
                  UPDATE visitor_session
                  SET chat_session_id = ?
                  WHERE id = ?
                     `;
                    connection.query(
                      updateVisitorSessionQuery,
                      [sessionId, visitorId],
                      (updateErr) => {
                        if (updateErr) {
                          console.error(
                            "Error updating visitor session with chat_session_id:",
                            updateErr
                          );
                          return;
                        }
                      }
                    );
                    console.log(
                      "New chat session created by visitor:",
                      sessionId
                    );
                    handleMessage(sessionId);
                  }
                );
              }
            );
          }
        });
      });
      //2839 3116
      // Handle visitor URL updates
      socket.on("visitor url update", (data) => {
        console.log("Received visitor URL update:", data);

        // Destructure the data object
        const { public_key, url, clientId } = data;

        // Prepare the URL update event data
        const urlUpdateData = {
          url,

          public_key,
          clientId,
        };

        // Notify assigned admins
        notifyAssignedAdmins(
          public_key,
          connection,
          adminSockets,
          "visitor url update",
          urlUpdateData
        );
      });
      // handle visitor metadata

      // / Handle socket disconnection
      socket.on("disconnect", () => {
        console.log(`Client ${client_id} disconnected`);

        // Remove the disconnected socket ID from connectedClients
        if (connectedClients[client_id]) {
          connectedClients[client_id] = connectedClients[client_id].filter(
            (socketId) => socketId !== socket.id
          );
          console.log(
            `Removed socket ID: ${socket.id} for client ${client_id}`
          );
        }

        // Check if client exists in visitorState
        if (!visitorState[client_id]) {
          console.log(
            `No visitor state found for client ${client_id} on disconnect.`
          );
          return;
        }

        // Check if there are any other active sockets for the same client
        const clientSocketIds = connectedClients[client_id];
        const activeSockets = clientSocketIds
          ? clientSocketIds.filter((socketId) =>
              io.sockets.sockets.has(socketId)
            )
          : [];

        if (activeSockets.length > 0) {
          console.log(`Active sockets still exist for client ${client_id}.`);
          return; // Do not proceed with setting timeouts if any socket is still active
        }

        console.log(
          `No active sockets remaining for client ${client_id}. Proceeding with timeouts.`
        );

        // If no active sockets, set the statusTimeout
        if (!visitorState[client_id].statusTimeout) {
          visitorState[client_id].statusTimeout = setTimeout(() => {
            const publicKey = visitorState[client_id]?.public_key || public_key;
            handleStatusChange(client_id, publicKey, 5); // Set status to 5
            console.log("Status changed to 5 after 30 seconds of inactivity.");
            visitorState[client_id].statusTimeout = null; // Clear the reference
          }, STATUS5TIMEOUT); // 30 seconds timeout
        } else {
          console.log(
            `Status timeout already running for client ${client_id}.`
          );
        }

        // If no active sockets, set the disconnectTimeout
        if (!visitorState[client_id].disconnectTimeout) {
          visitorState[client_id].disconnectTimeout = setTimeout(() => {
            const publicKey = visitorState[client_id]?.public_key || public_key;
            handleDisconnectTimeout(client_id, publicKey);
            console.log("Handled final disconnection for client", client_id);
          }, DISCONNECTIMEOUT); // 2 minutes timeout
        } else {
          console.log(
            `Disconnect timeout already running for client ${client_id}.`
          );
        }
      });
    }
  }
});

// Routes
// Routes
const dashboardRoutes = require("./Routes/dashboardroutes");
const authRoutes = require("./Routes/auth");
const companyRoutes = require("./Routes/companyRoutes");
const brandRoutes = require("./Routes/brandRoutes");
const userRoutes = require("./Routes/userRoutes");
const widgetRoutes = require("./Routes/widgetRoute");
const autoReplyRoutes = require("./Routes/AutoReplyRoute.js");

const scriptRoutes = require("./services/script-service/routes/scriptRoutes");
const messagingRoutes = require("./services/messaging-service/controllers/routes/messagingRoutes");
const chatRoutes = require("./Routes/chatRoutes");
const ChatPortal = require("./Routes/chatPortal");
const AlertRoute = require("./Routes/alertRoute.js");
const { fetchuserRole } = require("./models/userModel");

const { log } = require("console");
const { stat } = require("fs");
// chat api
app.use("/api/chat", chatRoutes);
app.use("/api", ChatPortal);
app.use("/api", AlertRoute);
app.use("/api", autoReplyRoutes);
// client api
const clientRoutes = require("./Routes/ClientRoutes");
const userShortcutsRoutes = require("./Routes/userShortcutsRoutes.js");
const userSettings = require("./Routes/settingsRoutes.js");
const { encryptData } = require("./middleware/EncryptDecryptData.js");

// Use the client routes
app.use("/api/client", clientRoutes);
app.use("/api/shortcuts", userShortcutsRoutes);
app.use("/api/settings", userSettings);
// chat widget routes
app.use("/api/script", scriptRoutes);
app.use("/api/message", messagingRoutes);
app.use("/api/script", widgetRoutes);

app.use("/api/dashboard", dashboardRoutes);
app.use("/api/auth", authRoutes);
app.use("/api", companyRoutes);
app.use("/api", brandRoutes);
app.use("/api", userRoutes);

// app.use('/api', logoRoutes);
// Error handling middleware should be used after all routes
app.use(errorHandler);
app.use(express.static("public"));
app.use("/uploads", express.static("images"));

// Endpoint to get company data
app.get("/api/get-company/:companyId", (req, res) => {
  const { companyId } = req.params;

  connection.query(
    "SELECT * FROM companies WHERE company_id = ?",
    [companyId],
    (err, results) => {
      if (err || results.length === 0) {
        return res.status(404).json({ error: "Company not found" });
      }
      res.json(results[0]);
    }
  );
});

server.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
