const { encryptData } = require('../middleware/EncryptDecryptData');
const settingsModel = require('../models/settingsModel');

// Controller to handle GET request for user tones
const getUserTones = async (req, res) => {
  const { user_id } = req.params;

  try {
    const userTones = await settingsModel.getUserTones(user_id);
    if (!userTones) {
      return res.status(404).json({ message: 'User tones not found' });
    }
    res.status(200).json(encryptData(userTones));
  } catch (error) {
    res.status(500).json({ message: 'Error retrieving user tones', error });
  }
};

// Controller to handle POST request to update user tones
const updateUserTones = async (req, res) => {
  const { user_id, new_visitor_tone, message_tone } = req.body;

  if (!user_id || !new_visitor_tone || !message_tone) {
    return res.status(400).json({ message: 'Missing required fields' });
  }

  try {
    await settingsModel.updateUserTones(user_id, new_visitor_tone, message_tone);
    const updatedUserTones = {
        user_id,
      new_visitor_tone,
      message_tone,
    }
    res.status(200).json(encryptData({ message: 'User tones updated successfully',updatedUserTones }));
  } catch (error) {
    res.status(500).json({ message: 'Error updating user tones', error });
  }
};

module.exports = {
  getUserTones,
  updateUserTones
};
