const crypto = require("crypto");
require("dotenv").config();

// Ensure SECRET_KEY is exactly 32 bytes
const SECRET_KEY = crypto.createHash("sha256")
  .update(process.env.SECRET_KEY, "utf8")
  .digest();

// AES requires a 16-byte IV
const IV_LENGTH = 16;

// Encrypt Function
const encryptData = (data) => {
  const iv = crypto.randomBytes(IV_LENGTH);
  const cipher = crypto.createCipheriv("aes-256-cbc", SECRET_KEY, iv);

  let encrypted = cipher.update(JSON.stringify(data), "utf8", "base64");
  encrypted += cipher.final("base64");

  return {
    e: encrypted,
    iv: iv.toString("base64"),
  };
};

// Decrypt Function
const decryptData = (e, iv) => {
  try {
    const decipher = crypto.createDecipheriv(
      "aes-256-cbc",
      SECRET_KEY,
      Buffer.from(iv, "base64")
    );

    let decrypted = decipher.update(e, "base64", "utf8");
    decrypted += decipher.final("utf8");

    return JSON.parse(decrypted);
  } catch (error) {
    console.error("Decryption failed:", error);
    return null;
  }
};

// Example Usage
const testData = { message: "Hello, Secure Next.js!" };
const encrypted = encryptData(testData);
console.log("Encrypted:", encrypted);

const decrypted = decryptData(encrypted.e, encrypted.iv);
console.log("Decrypted:", decrypted);

module.exports = { encryptData, decryptData };
