const jwt = require('jsonwebtoken');
const db = require('../config/database');
const { fetchuserRole } = require('../models/userModel');

 
const JWT_SECRET = process.env.JWT_SECRET;
// Middleware to fetch user role from the database using the JWT token
const fetchUserRole = async (req, res, next) => {
  const token = req.headers['authorization']?.split(' ')[1]; // Bearer token format

  if (!token) {
    return res.status(401).json({ message: 'Access Denied' });
  }

  try {
    // Verify the token
    const decoded = jwt.verify(token, JWT_SECRET);
    const userId = decoded.userId;

    // Fetch user data from the database
    const [rows] = await db.query('SELECT role FROM users WHERE id = ?', [userId]);

    if (rows.length === 0) {
      return res.status(404).json({ message: 'User not found' });
    }

    // Attach user role to the request object
    req.userRole = rows[0].role;

    next();
  } catch (error) {
    console.error('Error fetching user role:', error);
    res.status(403).json({ message: 'Invalid Token' });
  }
};

// Custom middleware for token verification
const verifyToken = async (req, res, next) => {
    // Extract token from the Authorization header
    const token = req.headers['authorization']?.split(' ')[1];
    console.log(token)
    console.log("token:")
    // If token is not provided, return a 401 response
    if (!token) {
      return res.status(401).json({ message: 'Access Denied: Token Missing' });
    }
  
    try {
      // Verify the token
      const verified = jwt.verify(token, JWT_SECRET);
  
      // Fetch user data based on userId from the token
      const user = await fetchuserRole(verified.userId);
      
      // Check if user data is found
      if (!user || user.length === 0) {
        return res.status(404).json({ message: 'User not found' });
      }
      
      // Prepare user information to attach to the request
      const userInfo = {
        userId: verified.userId,
        role: user.role_id,
        company_id: user.company_id
      };
  
      // Attach user data to the request object
      req.user = userInfo;
  
      // Proceed to the next middleware or route handler
      next();
    } catch (err) {
      console.error('Error verifying token:', err);
      // Handle different error types more precisely
      if (err.name === 'JsonWebTokenError') {
        console.log("invalid token you are using")
        return res.status(400).json({ message: 'Invalid Token' });
      } else if (err.name === 'TokenExpiredError') {
        return res.status(401).json({ message: 'Token Expired' });
      }
      return res.status(500).json({ message: 'Server Error' });
    }
  };
  

// Role-based middleware
const roleMiddleware = (roles) => (req, res, next) => {
  if (!roles.includes(req.user.role)) {
    return res.status(403).json({ message: 'Forbidden' });
  }
  next();
};
// Create a new role
const createRole = async (permission) => {
  const [result] = await db.query('INSERT INTO roles (permissions) VALUES (?)', [permission]);
  return { id: result.insertId, permissions: permission };
};


module.exports = { verifyToken, roleMiddleware, fetchUserRole ,createRole};
