const db = require('../config/database');

const AutoReplyModel = {
  create: async ({ brand_id, auto_reply1, is_active1, auto_reply2, is_active2 }) => {
    const query = `
      INSERT INTO auto_replies (brand_id, auto_reply1, is_active1, auto_reply2, is_active2) 
      VALUES (?, ?, ?, ?, ?)
      ON DUPLICATE KEY UPDATE 
        auto_reply1 = VALUES(auto_reply1), 
        is_active1 = VALUES(is_active1), 
        auto_reply2 = VALUES(auto_reply2), 
        is_active2 = VALUES(is_active2)
    `;
    return db.execute(query, [brand_id, auto_reply1, is_active1, auto_reply2, is_active2]);
  },

  findByBrandId: async (brand_id) => {
    const query = `SELECT * FROM auto_replies WHERE brand_id = ? LIMIT 1`;
    const [rows] = await db.execute(query, [brand_id]);
    return rows.length > 0 ? rows[0] : null;
  },

  update: async ({ brand_id, auto_reply1, is_active1, auto_reply2, is_active2 }) => {
    const query = `
      UPDATE auto_replies 
      SET auto_reply1 = ?, is_active1 = ?, auto_reply2 = ?, is_active2 = ?, updated_at = CURRENT_TIMESTAMP 
      WHERE brand_id = ?
    `;
    return db.execute(query, [auto_reply1, is_active1, auto_reply2, is_active2, brand_id]);
  },

  // **Manage Ignored Users**
  addOrUpdateIgnoredUser: async ({ brand_id, user_type, status }) => {
    const query = `
      INSERT INTO ignore_auto_reply (brand_id, user_type, status) 
      VALUES (?, ?, ?) 
      ON DUPLICATE KEY UPDATE status = VALUES(status), updated_at = CURRENT_TIMESTAMP
    `;
    return db.execute(query, [brand_id, user_type, status]);
  },

  getIgnoredUsers: async (brand_id) => {
    const query = `SELECT user_type, status FROM ignore_auto_reply WHERE brand_id = ?`;
    const [rows] = await db.execute(query, [brand_id]);
    return rows;
  }
};

module.exports = AutoReplyModel;
