const {
    connectedClients,
    offlineAdminChats,
    adminSockets,
    connectDisconnect,
    disconnectedClients,
    visitorState,
    DISCONNECTIMEOUT,
    INACTIVITYT_IMEOUT,
    STATUS5TIMEOUT,
    activeChats,
    activechatsparticipants,
    typingUsers
  } = require('../shared/globalState');
  const {
    handleDisconnectTimeout,
    handleStatusChange,
    notifyAssignedAdmins,
    fetchUnseenMessagesForAdmins,
    fetchClientDetails,
    checkIfRatingGiven,
    getChatMeta,
    checkAndEmitRating,
    getGeolocationData,
    getMessagesBySessionId,
    notifyChatParticipants,
    getParticipantsWithNames
  } = require('../sockets/utils');
const HandleClient = (io,socket, connection,user) => {
        console.log(user)
        console.log("Client connected");
        const { client_id, public_key } = user;
        console.log("public key", public_key);
  
        const chatKey = `${public_key}_${client_id}`;
        
  
        
  
        socket.join(chatKey);
  
        // Track connect time
        // socket.join(chatKey);
  
        // Initialize or reset visitor state
        if (!visitorState[client_id]) {
          // Initialize a new visitor state if it doesn't exist
          visitorState[client_id] = {
            inactivityTimeout: null,
            disconnectTimeout: null,
            statusTimeout: null,
            lastStatus: 1, // Initialize as active (status 1)
            isConnected: true,
            public_key: public_key || null, // Set public key if available
          };
          console.log("New visitor session created for client", client_id);
        } else {
          console.log("Existing session found for client", client_id);
        
          // Clear any existing timeouts to avoid duplication
          if (visitorState[client_id].inactivityTimeout) {
            clearTimeout(visitorState[client_id].inactivityTimeout);
            visitorState[client_id].inactivityTimeout = null;
            console.log("Cleared existing inactivityTimeout for client", client_id);
          }
          
          if (visitorState[client_id].statusTimeout) {
            clearTimeout(visitorState[client_id].statusTimeout);
            visitorState[client_id].statusTimeout = null;
            console.log("Cleared existing statusTimeout for client", client_id);
          }
        
          if (visitorState[client_id].disconnectTimeout) {
            clearTimeout(visitorState[client_id].disconnectTimeout);
            visitorState[client_id].disconnectTimeout = null;
            console.log("Cleared existing disconnectTimeout for client", client_id);
          }
        
        
    
          // Reset status based on last known status (before disconnection)
    let visitorStatus = visitorState[client_id].lastStatus === 3 ? 3 : 1;
    const resetStatusQuery = `
      UPDATE visitor_session
      SET status = ?
      WHERE client_id = ? AND status != 4
    `;
    connection.query(resetStatusQuery, [visitorStatus, client_id], (err) => {
      if (err) {
        console.error("Error resetting visitor session status:", err);
      } else {
        console.log(`Visitor session status reset to active for client ${client_id}`);
        notifyUser(public_key, visitorStatus, "Visitor status change");
      }
    });
          // clearTimeout(visitorState[client_id].public_key);
          visitorState[client_id].isConnected = true;
          visitorState[client_id].public_key = public_key;
        }
        console.log("visotor is here");
  
        // Function to handle the final disconnection and database updates after 2 minutes
  
        const handleDisconnectTimeout = (client_id, public_key) => {
          console.log("Handling disconnection for:", client_id, public_key);
          const chatKey = `${public_key}_${client_id}`;
          const disconnectTime = new Date();
          const getSessionQuery = `   SELECT session_id FROM chat_sessions 
      WHERE client_id = ? AND is_active = 1 LIMIT 1`;
        
          connection.query(getSessionQuery, [client_id], (err, sessionResults) => {
              if (err) {
                  console.error("Error fetching session:", err);
                  socket.emit("rating submission failed", { success: false, message: "Error fetching active session." });
                  return;
              }
        
              if (sessionResults.length > 0) {
                  const sessionId = sessionResults[0].session_id;
                  
                  const insertMessageQuery = `
                  INSERT INTO chat_messages (session_id, sender_id, message, type, sent_at)
                  VALUES (?, ?, ?, ?, NOW())
                `;
              
          connection.query(insertMessageQuery, [sessionId, client_id, 'visitor left the chat', "comment"],
              (err, result) => {
                if (err) {
                console.error(
                "Error inserting message:",err);     return;
  }
  if (result && result.insertId) {
    // Extract the message ID
    const messageId = result.insertId;
               // Emit the socket event after successful insertion
               io.to(chatKey).emit("chat message", {
                from: client_id, // sender's name
                msg:'visitor left the chat', // the actual message
                type: "client", // message type (admin)
                msgtype: "comment", // message subtype (e.g., comment)
                room: chatKey, // room identifier
                sent_at:  new Date().toISOString(), // time of message
                messageId: messageId, // message ID
              });
               
   
            }
  })
          }  })
          
          // Update visitor session status to disconnected (status = 4)
          const updateStatusQuery =
              "UPDATE visitor_session SET status = 4, left_time = ? WHERE client_id = ? AND status != 4";
      
          connection.query(updateStatusQuery, [disconnectTime, client_id], (err) => {
              if (err) {
                  console.error("Error updating visitor session status to 4:", err);
              } else {
                  notifyUser(public_key,4,'client disconnected')
                  console.log(`Visitor session status set to 4 for client ${client_id}`);
                  delete activeChats[chatKey] 
                  delete connectedClients[client_id];
                  delete visitorState[client_id];
                  delete activechatsparticipants[chatKey]
                  // Fetch client details to emit
                  const clientDataQuery = `
      SELECT 
          c.client_id, 
          c.name AS client_name, 
          cs.served_by, 
          cs.session_id AS chat_session_id, 
          ab.name AS brand_name, 
          vs.landing_url,
          vs.id AS visitor_session_id, 
          vs.IP_Health, 
          v.created_at, 
          v.ip, 
          v.country, 
          v.browser, 
          v.os, 
          vs.join_time, 
          vs.left_time 
      FROM 
          visitor_session vs 
      JOIN 
          visitors v ON v.client_id = vs.client_id 
      JOIN 
          chat_sessions cs ON vs.chat_session_id = cs.session_id 
      JOIN 
          client c ON cs.client_id = c.client_id 
      JOIN 
          brands ab ON vs.public_key = ab.public_key 
      WHERE 
          vs.client_id = ? 
          AND vs.status = 4 
          AND v.created_at = (
              SELECT MAX(created_at) 
              FROM visitors 
              WHERE client_id = vs.client_id
          )
      ORDER BY 
          vs.join_time DESC 
      LIMIT 1;
  `;
  
  connection.query(clientDataQuery, [client_id], (err, results) => {
      if (err) {
          console.error("Error fetching client data:", err);
      } else {
          const clientInfo = results[0]; // Assuming only one record for a client
  
          // Emit the client data to assigned admins
          if (clientInfo) {
              const updateFields = {
                  client_id: clientInfo.client_id,
                  client_name: clientInfo.client_name,
                  served_by: clientInfo.served_by,
                  chat_session_id: clientInfo.chat_session_id,
                  brand_name: clientInfo.brand_name,
                  landing_url: clientInfo.landing_url,
                  IP_Health: clientInfo.IP_Health,
                  created_at: clientInfo.created_at,
                  ip: clientInfo.ip,
                  visitor_session_id:clientInfo.visitor_session_id,
                  country: clientInfo.country,
                  browser: clientInfo.browser,
                  os: clientInfo.os,
                  join_time: clientInfo.join_time,
                  left_time: clientInfo.left_time, // Use the disconnect time
              };
  
              notifyAssignedAdmins(public_key, connection, adminSockets, 'client History updated', updateFields);
          }
      }
  });
  
      
                  console.log(`Status updated to 4 after disconnection for client ${client_id}`);
              }
          });
      
          // Update chat_sessions to inactive (is_active = 0)
          const updateChatSessionQuery =
              "UPDATE chat_sessions SET is_active = 0 WHERE client_id = ? AND is_active = 1";
      
          connection.query(updateChatSessionQuery, [client_id], (err) => {
              if (err) {
                  console.error("Error updating chat session status to inactive:", err);
              } else {
                  console.log(`Chat session set to inactive for client ${client_id}`);
              }
          });
      
          // Clear inactivity timeout if it exists
          if (visitorState[client_id]?.inactivityTimeout) {
              clearTimeout(visitorState[client_id].inactivityTimeout);
              delete visitorState[client_id].inactivityTimeout; // Optionally delete the timeout
              console.log(`Inactivity timeout cleared for client ${client_id}`);
          }
      
          // Clear disconnect timeout
          delete visitorState[client_id]; // Clear visitor state after disconnect
      };
      
        const handleStatusChange = (client_id, public_key, newStatus) => {
          if (visitorState[client_id]?.statusLock) return;
          visitorState[client_id].statusLock = true;
        
          const updateStatusQuery = `
              UPDATE visitor_session
              SET status = ?
              WHERE client_id = ? AND status != 4 `;
          connection.query(updateStatusQuery, [newStatus, client_id], (err) => {
            visitorState[client_id].statusLock = false; // Release lock
            if (err) {
              console.error("Error updating visitor session:", err);
            } else {
              console.log(`Visitor status updated to ${newStatus} for client ${client_id}`);
              notifyUser(public_key, newStatus, "Visitor status change");
            }
          });
        };
        
        const resetInactivityTimeout = (client_id, public_key) => {
          
  
          // Check if visitorState[client_id] exists
          if (!visitorState[client_id]) {
            visitorState[client_id] = {}; // Initialize if it doesn't exist
          }
  
        
  
          // Clear existing timeout if it exists
          if (visitorState[client_id].inactivityTimeout) {
            clearTimeout(visitorState[client_id].inactivityTimeout);
         
            notifyUser(public_key, 1, "active");
          }
  
          // Update public_key (avoid overwriting entire visitor state)
          visitorState[client_id].public_key = public_key;
      
  
          // Set new inactivity timeout
          visitorState[client_id].inactivityTimeout = setTimeout(() => {
         
  
            // Check for public_key in the state, fallback to function argument
            const currentPublicKey =
              visitorState[client_id].public_key || public_key;
            handleInactivity(client_id, currentPublicKey);
          }, INACTIVITYT_IMEOUT); // 5 minutes for inactivity
        };
  
        // Handle inactivity
        function handleInactivity(client_id, public_key) {
          const updateStatusQuery =
            "UPDATE visitor_session SET status = 2 WHERE client_id = ? AND status != 4";
          connection.query(updateStatusQuery, [client_id], (err) => {
            if (err) {
              console.error(
                "Error updating visitor session status due to inactivity:",
                err
              );
            } else {
              const status = 2;
              notifyUser(public_key, status, "visitor is idle");
              console.log(
                `Status updated to 2 due to inactivity for client ${client_id}`
              );
            }
          });
        }
  
        function notifyUser(public_key, status, message) {
          // Query to fetch the latest visitor_id for the given client_id
          const visitorQuery = `
              SELECT id
              FROM visitor_session
              WHERE client_id = ?
              ORDER BY join_time DESC
              LIMIT 1
          `;
      
          connection.query(visitorQuery, [client_id], (err, visitorResults) => {
              if (err) {
                  console.error("Error fetching latest visitor_id:", err);
                  return;
              }
      
              // Ensure visitor_id is fetched successfully
              const visitor_id = visitorResults.length > 0 ? visitorResults[0].id : null;
      
              // Query to fetch all assigned admins for the brand
              const assignedAdminsQuery = `
               SELECT user_id 
  FROM brand_assignees 
  WHERE brand_id = (SELECT id FROM brands WHERE public_key = ?)
  AND status = 1
  
                  `;
      
              connection.query(assignedAdminsQuery, [public_key], (err, adminResults) => {
                  if (err) {
                      console.error("Error fetching assigned admins on disconnect:", err);
                      return;
                  }
                  // Client with ID m3fwv77vpd is not connected.
                  // Notify each assigned admin about the visitor's status change
                  adminResults.forEach((row) => {
                      const adminSocket = adminSockets[row.user_id];
      
                      if (adminSocket) {
                          adminSocket.emit("visitor status change", {
                              client_id,
                              visitor_id, // Include the latest visitor_id in the emitted data
                              status,
                              public_key,
                            
                          });
                      }
                  });
              });
          });
      }
      
  
        // Check if there is an active visitor session with status != 4 (4 == left the website)
        const checkQuery =
          "SELECT * FROM visitor_session WHERE client_id = ? AND status != ?";
        connection.query(checkQuery, [client_id, 4], (error, results) => {
        
  
          if (error) {
            console.error("Error checking visitor session:", error);
            return;
          }
  
          // if existing session found
          if (results.length > 0) {
            // status will  be check if it's change like 2,3, then it will be one
            //..................code..................  
            
            
            
            
            // Emit chat history to the visitor for the existing active chat session
            function emitChatHistory(client_id, chatKey) {
              
              const getActiveSessionQuery = `SELECT * FROM chat_sessions WHERE chat_key = ? AND is_active = 1 LIMIT 1`;
  
              connection.query(
                getActiveSessionQuery,
                [chatKey],
                (err, activeSession) => {
                  if (err) {
                    console.error("Error fetching active session:", err);
                    return;
                  }
                 
  
                  if (activeSession.length > 0) {
                    const sessionId = activeSession[0].session_id;
                 
                    // Fetch participants and messages for the session
                    getParticipantsWithNames(
                      sessionId,
                      (participantsErr, participants) => {
                        if (participantsErr) {
                          console.error(
                            "Error fetching participants:",
                            participantsErr
                          );
                          return;
                        }
  
                        getMessagesBySessionId(
                          sessionId,
                          (messagesErr, messages) => {
                            if (messagesErr) {
                              console.error(
                                "Error fetching messages:",
                                messagesErr
                              );
                              return;
                            }
  
                            // Format and emit chat history
                            const formattedMessages = messages.map((message) => {
                              const sender = participants.find(
                                (p) => p.user_id === message.sender_id
                              );
  
                              let senderType = "Unknown";
                              if (sender) {
                                senderType =
                                  sender.role === "admin" ? "admin" : "client";
                              }
  
                              // Format the sent_at date to "HH:MM:SS AM/PM" format
  
                              return {
                                from: sender ? sender.real_name : "Unknown",
                                msg: message.message,
                                type: senderType,
                                msgtype: message.type,
                                room: chatKey,
                                sent_at: message.sent_at,
                                messageId: message.message_id,
                                is_seen:message.is_seen,
                              };
                            });
  
                            socket.emit("chat history", formattedMessages);
                       
                          }
                        );
                      }
                    );
                  }
                }
              );
            }
            // If a visitor session exists, check the last disconnect time
            const visitorSession = results[0];
           
            //chat will be emit to visitor
            // socket.emit('chat history', visitorSession);
            const visitorStatus = {
              status: visitorSession.status,
              client_id: client_id,
            };
      
  
            console.log(
              "Reconnect within one minute, using the existing session."
            );
  
            socket.on("get chat history", (data) => {
          
              socket.emit("visitor status", visitorStatus);
              emitChatHistory(client_id, chatKey);
              getChatMeta(client_id,public_key,socket)
              fetchUnseenMessagesForAdmins(connection, public_key, client_id, io, chatKey);
                // Check if rating is given for this chat session
            checkIfRatingGiven(client_id, chatKey, socket);
          // Fetch and emit client details
               fetchClientDetails(client_id, socket);
            });
  
         
  
            resetInactivityTimeout(client_id, public_key);
            // Continue using the existing session, notify the admin, etc.
          } else {
            // No active visitor session found. Creating a new session...
            console.log(
              "No active visitor session found. Creating a new session..."
            );
            // Function to handle rating submission
  
  
  socket.on("new client", (data) => {
    console.log("new client", data);
  
    const { clientId, public_key, url, os, browser } = data;
    const client_id = clientId;
    const ip =
      socket.handshake.headers["x-forwarded-for"] || socket.handshake.address;
  
    // Check for an active session in the `visitor_sessions` table where status != 4
    const checkActiveSessionQuery = `
      SELECT * FROM visitor_session 
      WHERE client_id = ? AND status != 4 LIMIT 1
    `;
  
    connection.query(checkActiveSessionQuery, [client_id], (err, sessionResult) => {
      if (err) {
        console.error("Error checking active visitor session:", err);
        return;
      }
  
      if (sessionResult.length > 0) {
        console.log(`Active session already exists for client ${client_id}:`, sessionResult[0]);
        return; // Stop execution if an active session already exists
      }
  
      // If no active visitor session exists, create a new one
      console.log("No active visitor session found. Creating a new session...");
  
      createNewVisitorSession(client_id, public_key, url, (err, result) => {
        if (err) {
          console.error("Error creating new visitor session:", err);
          return;
        }
  
        resetInactivityTimeout(clientId, public_key);
        console.log("New visitor session created:", result);
  
        // Notify the admin of the existing visitor session
        const assignedAdminsQuery = `
        SELECT 
            ba.user_id, 
            ba.brand_id, 
            b.name AS brand_name
        FROM 
            brand_assignees ba
        JOIN 
            brands b 
        ON 
            ba.brand_id = b.id
        WHERE 
            ba.brand_id = (SELECT id FROM brands WHERE public_key = ?) 
            AND ba.status = 1
    `;
    
  
        connection.query(assignedAdminsQuery, [public_key], async (err, adminResults) => {
          if (err) {
            console.error("Error fetching assigned admins:", err);
            return;
          }
  
          // Fetch country and city from the IP address using the getGeolocationData function
          const { countryName, cityName } = await getGeolocationData(ip);
  
          adminResults.forEach((row) => {
            const adminSocket = adminSockets[row.user_id];
  
            if (adminSocket) {
              // Emit the 'new client' event with the brand name included
              adminSocket.join(chatKey);
              adminSocket.emit("new client", {
                client_id,
                public_key,
                join_time: result.insertId ? new Date() : null, // Assuming join_time is NOW()
                landing_url: url,
                os,
                ip,
                country: countryName,
                city: cityName,
                visitor_session_id: result.sessionResult.insertId,
                status: 1,
                brand_id: row.brand_id,
                brand_name: row.brand_name, // Emit the brand name
                browser: browser.name,
              });
  
              console.log(
                `Admin ${row.user_id} notified of existing chat with client ${client_id} from ${countryName} (${cityName}) on brand ${row.brand_name}`
              );
            }
          });
        });
      });
    });
  });
  
          }
        });
  
        // Function to create a new visitor session using a callback
        function createNewVisitorSession(client_id, public_key, url, callback) {
          // Query to create a new visitor session
          const newSessionQuery = `
            INSERT INTO visitor_session (client_id, public_key, landing_url, status, join_time) 
            VALUES (?, ?, ?, ?, NOW())
          `;
        
          // Execute the query to create the new session
          connection.query(newSessionQuery, [client_id, public_key, url, 1], (err, result) => {
            if (err) {
              console.error("Error creating new visitor session:", err);
              return callback(err, null); // Pass the error to the callback
            }
       
            // Query to update the last added row in the visitors table
            const updateVisitorQuery = `
              UPDATE visitors
              SET v_session_id = ?
              WHERE client_id = ? 
              ORDER BY created_at DESC 
              LIMIT 1
            `;
        
            // Execute the query to update the visitor table with the new session ID
            connection.query(updateVisitorQuery, [result.insertId, client_id], (updateErr, updateResult) => {
              if (updateErr) {
                console.error("Error updating the visitors table:", updateErr);
                return callback(updateErr, null); // Pass the update error to the callback
              }
        
              // Pass the result of both queries back to the callback
              callback(null, { sessionResult: result, visitorUpdateResult: updateResult });
            });
          });
        }
  
  
          // When a user starts typing
          socket.on("startTyping", ({ client_id }) => {
              const chatKey = `${public_key}_${client_id}`;
              socket.to(chatKey).emit("displayTyping", { client_id,chatKey });
              
              // Start or refresh typing timeout
              refreshTypingTimeout(client_id, chatKey);
          });
      
          // When a user is still typing
          socket.on("stillTyping", ({ client_id }) => {
              const chatKey = `${public_key}_${client_id}`;
              refreshTypingTimeout(client_id, chatKey);
          });
      
          // When a user stops typing
          socket.on("endTyping", ({ client_id }) => {
              const chatKey = `${public_key}_${client_id}`;
              socket.to(chatKey).emit("hideTyping", { client_id,chatKey });
              typingUsers.delete(client_id);
          });
      
         
          // Helper function to refresh typing timeout
          function refreshTypingTimeout(client_id, chatKey) {
              // Clear existing timeout for this client
              if (typingUsers.has(client_id)) {
                  clearTimeout(typingUsers.get(client_id));
              }
              
              // Set a new timeout to end typing if no activity
              const timeout = setTimeout(() => {
                  socket.to(chatKey).emit("hideTyping", { client_id,chatKey });
                  typingUsers.delete(client_id);
              }, 1500); // 1.5-second timeout after last typing event
              
              typingUsers.set(client_id, timeout);
          }
        
        socket.on("submit rating", (data) => {
          const { client_id, public_key, rating } = data;  // Assuming rating will be either 1 or 2
        console.log("submit rating", data);
        
          // Step 1: Build chatKey based on client_id and public_key
          const chatKey = `${public_key}_${client_id}`;
        
          // Step 2: Fetch session_id from chat_sessions using chatKey
          const getSessionQuery = `SELECT session_id FROM chat_sessions WHERE chat_key = ? AND is_active = 1 LIMIT 1`;
        
          connection.query(getSessionQuery, [chatKey], (err, sessionResults) => {
              if (err) {
                  console.error("Error fetching session:", err);
                  socket.emit("rating submission failed", { success: false, message: "Error fetching active session." });
                  return;
              }
        
              if (sessionResults.length > 0) {
                  const sessionId = sessionResults[0].session_id;
        
                  // Step 3: Check if the rating is valid (1 or 2)
                  const isPositiveRating = rating === 1;
        
                  // Step 4: Insert rating into chat_rate table
                  const insertRatingQuery = `INSERT INTO chat_rate (chat_id, rating) VALUES (?, ?)`;
        
                  connection.query(insertRatingQuery, [sessionId, isPositiveRating ? 1 : 0], (err, ratingResults) => {
                      if (err) {
                          console.error("Error inserting rating:", err);
                          socket.emit("rating submission failed", { success: false, message: "Error inserting rating." });
                          return;
                      }
                      notifyAssignedAdmins(
                        public_key,
                        connection,
                        adminSockets,
                        "rating submit by client",
                        {
                          client_id: client_id,
                          public_key: public_key,
                          rating: rating,
                        }
                      )
                      // Step 5: Emit success message back to the client
                      socket.emit("rating submission success", { success: true, message: "Rating submitted successfully." });
                  });
              } else {
                  // No active session found
                  socket.emit("rating submission failed", { success: false, message: "No active session found." });
              }
          });
        });
        socket.on("update profile of client", (data) => {
          console.log("Updating profile of client:", data);
          
          const { client_id, name, email, phone } = data;
      
          // Prepare an object to hold the update fields
          const updateFields = {};
      
          // Check which fields are provided and add them to the updateFields object
          if (name) {
              updateFields.name = name; // Update name if provided
          }
          if (email) {
              updateFields.email = email; // Update email if provided
          }
          if (phone) {
              updateFields.phone = phone; // Update phone if provided
          }
      
          // Perform the update operation (e.g., database update)
          if (Object.keys(updateFields).length > 0) {
              // Assuming you have a function to handle the database update
              updateClientProfile(client_id, updateFields)
                  .then(() => {
                      console.log("Profile updated successfully:", updateFields);
                      // Optionally, emit a success message back to the client
                      socket.emit("profile update success", { message: "Profile updated successfully!" });
  
                      notifyAssignedAdmins(
                          public_key,
                          connection,
                          adminSockets,
                          'client data updated',
                          updateFields,
                        );
                  })
                  .catch((error) => {
                      console.error("Error updating profile:", error);
                      // Optionally, emit an error message back to the client
                      socket.emit("profile update error", { message: "Failed to update profile." });
                  });
          } else {
              console.log("No profile fields provided for update.");
          }
      });
      
      // Function to update client profile in the database (pseudo-code)
      function updateClientProfile(client_id, updateFields) {
          return new Promise((resolve, reject) => {
              // Example pseudo-code for database update
              const sql = "UPDATE client SET ? WHERE client_id = ?";
              connection.query(sql, [updateFields, client_id], (error, results) => {
                  if (error) {
                      return reject(error); // Reject promise on error
                  }
                  resolve(results); // Resolve promise on success
              });
          });
      }
      
        // Handle visitor status change to 3
        socket.on("visitor status change", (data) => {
           
          const { client_id, public_key, status } = data;
          if (visitorState[client_id]) {
            visitorState[client_id].statusTimeout = status
            visitorState[client_id].lastStatus = status
          }
          
          notifyUser(public_key, status, "visitor chat status changed");
          // Update visitor session status to disconnected (status = 4)
          const updateStatusQuery =
            "UPDATE visitor_session SET status = ? WHERE client_id = ? AND status != 4";
  
          connection.query(updateStatusQuery, [status, client_id], (err) => {
            if (err) {
              console.error("Error updating visitor session status to 3:", err);
            } else {
              console.log(
                `Visitor session status set to 3 for client ${data.client_id}`
              );
            }
          });
        });
        socket.on("client seen message", (data) => {
          const { client_id, public_key, message_id } = data;
          console.log("Client seen message ID:", message_id);
          
          const chatKey = `${public_key}_${client_id}`;
          console.log("Marking message as seen for chat:", chatKey);
          
          const isSeen = 1;
        
          // Query to update the specific message as seen
          const updateMessageSeenQuery = `
            UPDATE chat_messages
            SET is_seen = ?
            WHERE message_id = ?
           
          `;
        
          // Query to update all unseen messages in the session as seen (if needed)
          const updateAllUnseenQuery = `
            UPDATE chat_messages
            SET is_seen = ?
            WHERE session_id = (
              SELECT session_id
              FROM chat_sessions
              WHERE public_key = ?
              AND client_id = ?
              AND is_active = ?
            )
            AND sender_id != ?
            AND is_seen = 0
          `;
        
          // Update the specific message as seen
          connection.query(
            updateMessageSeenQuery,
            [isSeen, message_id ],
            (err, result) => {
              if (err) {
                console.error("Error updating the specific message as seen:", err);
                return;
              }
        
              if (result.affectedRows > 0) {
                console.log(`Message ID ${message_id} marked as seen for chat ${chatKey}.`);
        
                // Notify the assigned admins that the message has been seen
                const emitEvent = "message_seen by client";
                const emitData = {
                  client_id,
                  public_key,
                  is_seen: isSeen,
                  message_id,
                };
        
                notifyAssignedAdmins(
                  public_key,
                  connection,
                  adminSockets,
                  emitEvent,
                  emitData
                );
              } else {
                console.log(`Message ID ${message_id} is already marked as seen or not found.`);
              }
            }
          );
        
          
        });
        
        // Handle visitor messages
        socket.on("chat message", (data) => {
          const { client_id, public_key, message, msgtype } = data;
          const msg = message;
  
          // Function to handle message after session is created or found
          const handleMessage = (sessionId) => {
            console.log("Handling message for session:", sessionId);
  
            // Check if the visitor is already a participant in this session
            const checkParticipantQuery = `
              SELECT * FROM chat_participants WHERE session_id = ? AND user_id = ? AND role = 'client'
            `;
  
            connection.query(
              checkParticipantQuery,
              [sessionId, client_id],
              (err, participantResults) => {
                if (err) {
                  console.error("Error checking participant:", err);
                  return;
                }
  
                if (participantResults.length === 0) {
                  // Visitor is not a participant, so add them
                  const insertParticipantQuery = `
                  INSERT INTO chat_participants (session_id, user_id, role, join_time)
                  VALUES (?, ?, 'client', NOW())
                `;
  
                  connection.query(
                    insertParticipantQuery,
                    [sessionId, client_id],
                    (err) => {
                      if (err) {
                        console.error("Error inserting participant:", err);
                        return;
                      }
                      console.log(
                        `Visitor added as participant in session ${sessionId}`
                      );
                    }
                  );
                }
  
                // Insert the message into the chat_messages table
                const insertMessageQuery = `
                INSERT INTO chat_messages (session_id, sender_id, message, type, sent_at)
                VALUES (?, ?, ?, ?, NOW())
              `;
  
                connection.query(
                  insertMessageQuery,
                  [sessionId, client_id, msg,msgtype],
                  (err, result) => {
                    if (err) {
                      console.error("Error inserting message:", err);
                      return;
                    }
                    socket.join(chatKey)
                    const messageId = result.insertId; // Get the inserted message ID
                    const messageTime = new Date().toISOString(); // Get current time in ISO format
                    console.log(chatKey);
                    console.log("chatKey");
                    
                    // Emit the mess  age with message ID to the chat room
                    io.to(chatKey).emit("chat message", {
                      from: client_id,
                      msg, // the actual message
                      type: "client", // message type
                      room: chatKey, // room identifier
                      msgtype: msgtype, // message subtype
                      sent_at: messageTime, // time of message
                      messageId: messageId, // message ID
                    });
  
                    console.log(
                      `Visitor sent message to chat ${chatKey}: ${msg}`
                    );
                    const countMessagesQuery = `
                    SELECT COUNT(*) AS totalMessages FROM chat_messages WHERE session_id = ? AND type <> 'comment'
                  `;
                  connection.query(
                      countMessagesQuery,
                      [sessionId],
                      (err, countResult) => {
                        if (err) {
                          console.error("Error counting total messages:", err);
                          return;
                        }
        
                        const totalMessages = countResult[0].totalMessages;
        
  
                    // Query to get the number of unseen messages for the session
                    const combinedQuery = `
  SELECT 
      (SELECT COUNT(*)
       FROM chat_messages cm
       WHERE cm.session_id = ?
         AND cm.is_seen = 0
         AND cm.sender_id = ?
      ) AS unseenCount,
        
      (SELECT GROUP_CONCAT(user_id)
       FROM chat_participants
       WHERE session_id = ?) AS participants;
  
  `;
  
                    connection.query(
                      combinedQuery,
                      [sessionId,client_id, sessionId],
                      (err, result) => {
                        if (err) {
                          console.error(
                            "Error fetching unseen message count:",
                            err
                          );
                          return;
                        }
  
                        const unseenCount = result[0].unseenCount;
                        // Get the number of unseen messages
                        console.log(result[0].participants);
  
                        // Assuming result[0].participants has the format "51,43d1989a-ce2b-4b49-aede-1e69ee87c80e-vurkflow.com-1726160391250"
                        // Split participants string, trim whitespace, and filter out non-numeric entries
                        const participants = result[0].participants
                          ? result[0].participants
                              .split(",")
                              .map((item) => item.trim())
                              .filter(Boolean)
                          : [];
  
                        // Filter and keep only numeric participants (i.e., user IDs like '51')
                        const validParticipants = participants
                          .filter((participant) => /^\d+$/.test(participant)) // Use regex to ensure it's only numeric
                          .map(Number); // Convert strings to integers
  
                        console.log(
                          "Number of valid numeric participants:",
                          validParticipants
                        ); // [51]
                        console.log(
                          "All participants (including client IDs):",
                          participants
                        );
  
                        if (
                          !activeChats[chatKey] ||
                          activeChats[chatKey].participants.size === 0
                        ) {
                          notifyChatParticipants(
                            public_key,
                            connection,
                            adminSockets,
                            "New message blink", // This can be the event name
                            {
                              messageId: messageId,
                              is_seen: false, // message initially marked as not seen
                              client_id: client_id,
                              unseenCount: unseenCount, // Send the unseen messages count
                              participants: validParticipants,
                              totalMessages: totalMessages,
                            }
                          );
                        }
                        // Notify assigned admins about the new message and the number of unseen messages (triggering blink)
                      }
                    );
                  })
  
                  }
                );
              }
            );
          };
  
          // Check if there's an active session for the client
          const checkSessionQuery = `SELECT * FROM chat_sessions WHERE client_id = ? AND is_active = 1`;
  
          connection.query(checkSessionQuery, [client_id], (err, results) => {
            if (err) {
              console.error("Error checking active session:", err);
              return;
            }
  
            let sessionId;
  
            if (results.length > 0) {
              // Active session exists
              sessionId = results[0].session_id;
              console.log("Active session exists for client:", client_id);
              handleMessage(sessionId);
            } else {
              // No active session, create a new one
              const findVisitorSessionQuery = `
          SELECT id 
          FROM visitor_session 
          WHERE client_id = ? 
          AND status != 4
          ORDER BY id DESC
          LIMIT 1
        `;
  
              connection.query(
                findVisitorSessionQuery,
                [client_id],
                (err, result) => {
                  if (err) {
                    console.error("Error fetching visitor session:", err);
                    return;
                  }
  
                  let visitorId;
  
                  if (result.length > 0) {
                    // Found an active session, use the existing visitor_id
                    visitorId = result[0].id;
                    console.log("Using existing visitor session:", visitorId);
                  } else {
                    // No active session exists, use socket.id as visitor_id
                    visitorId = socket.id;
                    console.log(
                      "No active session found, using socket.id as visitor_id:",
                      visitorId
                    );
                    return;
                  }
  
                  // Insert new chat session with either the found visitor_id or socket.id
                  const insertSessionQuery = `
            INSERT INTO chat_sessions (
              chat_key, public_key, served_by, client_id, visitor_id, chat_initiated_time, is_active
            ) VALUES (?, ?, '', ?, ?, NOW(), 1)
          `;
  
                  connection.query(
                    insertSessionQuery,
                    [chatKey, public_key, client_id, visitorId],
                    (err, result) => {
                      if (err) {
                        console.error("Error inserting2 new chat session:", err);
                        return;
                      }
  
                      sessionId = result.insertId;
                         // Now update the visitor_session with the new chat_session_id
                    const updateVisitorSessionQuery = `
                    UPDATE visitor_session
                    SET chat_session_id = ?
                    WHERE id = ?
                       `;
                  connection.query(
                      updateVisitorSessionQuery,
                      [sessionId, visitorId],
                      (updateErr) => {
                        if (updateErr) {
                          console.error("Error updating visitor session with chat_session_id:", updateErr);
                          return;
                        }
                
                       
                      }
                    );
                      console.log(
                        "New chat session created by visitor:",
                        sessionId
                      );
                      handleMessage(sessionId);
                    }
                  );
                }
              );
            }
          });
        });
        //2839 3116
        // Handle visitor URL updates
        socket.on("visitor url update", (data) => {
          console.log("Received visitor URL update:", data);
  
          // Destructure the data object
          const { public_key, url, clientId } = data;
  
          // Prepare the URL update event data
          const urlUpdateData = {
            url,
  
            public_key,
            clientId,
          };
  
          // Notify assigned admins
          notifyAssignedAdmins(
            public_key,
            connection,
            adminSockets,
            "visitor url update",
            urlUpdateData
          );
        });
        // handle visitor metadata
  
        // / Handle socket disconnection
        socket.on("disconnect", () => {
          console.log(`Client ${client_id} disconnected`);
        
          // Check if client exists in visitorState
          if (!visitorState[client_id]) {
            console.log(
              `No visitor state found for client ${client_id} on disconnect.`
            );
            return;
          }
        
          // Check if statusTimeout already exists, if not, set it
          if (!visitorState[client_id].statusTimeout) {
            visitorState[client_id].statusTimeout = setTimeout(() => {
              const publicKey = visitorState[client_id]?.public_key || public_key;
              handleStatusChange(client_id, publicKey, 5); // Set status to 5
              console.log("Status changed to 5 after 30 seconds of inactivity.");
              visitorState[client_id].statusTimeout = null; // Clear the reference
            },STATUS5TIMEOUT); // 30 seconds timeout
          } else {
            console.log(`Status timeout already running for client ${client_id}.`);
          }
        
          // Check if disconnectTimeout already exists, if not, set it
          if (!visitorState[client_id].disconnectTimeout) {
            visitorState[client_id].disconnectTimeout = setTimeout(() => {
              const publicKey = visitorState[client_id]?.public_key || public_key;
              handleDisconnectTimeout(client_id, publicKey);
              console.log("Handled final disconnection for client", client_id);
              // visitorState[client_id].disconnectTimeout = null; // Clear the reference
            }, DISCONNECTIMEOUT); // 2 minutes before handling final disconnection
          } else {
            console.log(`Disconnect timeout already running for client ${client_id}.`);
          }
        });
        
   

    // Add additional event handlers as required
};
module.exports = HandleClient;