const generateScript = require('../utils/generateScript');
const collectUserInfo = require('../utils/collectUserInfo');

exports.generateScript = (req, res) => {
    const { widgetId, brandId } = req.params;

    // Collect user info (IP address, browser details, etc.)
    const userInfo = collectUserInfo(req);

    // Generate the chat widget script
    const scriptContent = generateScript(widgetId, brandId, userInfo);

    res.setHeader('Content-Type', 'application/javascript');
    res.send(scriptContent);
};
