const { v4: uuidv4 } = require('uuid');

function generateUUIDWithDate() {
    const uuid = uuidv4();
    const dateNow = Date.now();
    return `${uuid}-${dateNow}`;
}
function generateUniqueAlphanumericID() {
    // Get the current timestamp in milliseconds
    const timestamp = Date.now().toString(36); // Convert timestamp to base-36 for compact representation
    
    // Define the possible characters for the random part
    const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    let randomPart = '';
    
    // Determine how many random characters to generate
    const randomLength = 16 - timestamp.length; // Subtract the length of the timestamp part
    
    for (let i = 0; i < randomLength; i++) {
        const randomIndex = Math.floor(Math.random() * characters.length);
        randomPart += characters[randomIndex];
    }

    // Combine the timestamp and random part
    return timestamp + randomPart;
}

module.exports ={
    generateUniqueAlphanumericID,
    generateUUIDWithDate

} 

 
