const express = require('express');
const router = express.Router();
const auth = require('../controllers/auth');
const { roleMiddleware, verifyToken } = require('../middleware/role');

router.post('/login', auth.login);
router.post('/refresh-token', auth.refreshToken);
router.post('/register', auth.register);
router.post('/logout', auth.logout);
router.post('/user-verify-role', auth.fetchUserRole);
// Protected route
router.get('/protected', verifyToken, roleMiddleware([1, 2]), (req, res) => {
  res.json({ message: 'Welcome to the protected route' });
});

// Admin-only route
router.get('/admin', verifyToken, roleMiddleware([1]), (req, res) => {
  res.json({ message: 'Welcome Admin' });
});

module.exports = router;
