const setCookies = (res, cookies, options = {}) => {
  const isProduction = process.env.NODE_ENV === 'production';

  const defaultOptions = {
   
        httpOnly: true,      // Prevents JavaScript access to cookies
        secure: true,        // Cookies sent only over HTTPS
        sameSite: 'None',    // Required for cross-origin cookies
       
        maxAge: 86400 * 1000, // 1 day
    
    };

  const cookieOptions = { ...defaultOptions, ...options };

  // Loop through the cookies object and set each cookie
  Object.entries(cookies).forEach(([name, value]) => {
    res.cookie(name, value, cookieOptions);
  });
};

module.exports = setCookies;
