const rateLimit = require("express-rate-limit");

// Define rate limit based on JWT user ID or IP if no token
const apiLimiter = rateLimit({
  windowMs: 1 * 60 * 1000, // 15 minutes
  max: 60, // Limit each user to 100 requests per window
  message: "Too many requests from this user, please try again later.",
  keyGenerator: (req) => req.user?.id || req.ip, // Use user ID if available, else use IP
});

module.exports = apiLimiter;

