const mysql = require("mysql2/promise");
const fs = require("fs");

async function migrateData() {
  const connection = await mysql.createConnection({
    host: "localhost",
    user: "chatknot_chatknot",
    password: "uM!t@,wnVA${",
    database: "chatknot_chatknot",
  });

  try {
    console.log("Starting migration...");

    // Get user-company mapping
    const [users] = await connection.execute("SELECT id, company_id FROM users");
    const userCompanyMap = Object.fromEntries(users.map(user => [user.id, user.company_id]));

    // Read SQL file
    console.log("Reading data from SQL file...");
    const sqlFile = fs.readFileSync("user_shortcuts.sql", "utf8");

    // Extract INSERT values using regex
    const regex = /INSERT INTO `user_shortcuts` .*?VALUES\s*(.*?);/gis;
    let matches;
    let shortcutData = [];

    while ((matches = regex.exec(sqlFile)) !== null) {
      let valuesString = matches[1].trim();
      valuesString = valuesString.replace(/\),\(/g, ")|("); // Temporary split marker
      let rowStrings = valuesString.split("|").map(row => row.replace(/^\(|\)$/g, ""));

      for (let rowStr of rowStrings) {
        let row = rowStr.split(",").map(val => val.trim().replace(/^'|'$/g, "")); // Trim and remove single quotes

        let user_id = row[1] || "";
        let rawData = row[6] || "";

        if (!rawData) continue;

        let cleanedData = rawData.replace(/\\'/g, "'").replace(/\\"/g, '"');

        let shortcutsArray = [];
        try {
          // First parse: Convert string to JSON string
          let parsedString = JSON.parse(cleanedData);

          // Second parse: Convert JSON string to actual array
          if (typeof parsedString === "string") {
            shortcutsArray = JSON.parse(parsedString);
          } else {
            shortcutsArray = parsedString;
          }
        } catch (error) {
          console.error(`Error parsing shortcuts for user_id ${user_id}:`, error.message);
          continue;
        }

        // Insert each shortcut separately
        for (let shortcut of shortcutsArray) {
          if (Array.isArray(shortcut)) shortcut = shortcut[0];
          if (typeof shortcut === "string") shortcut = shortcut.replace(/[^\x00-\x7F]/g, ""); // Remove non-ASCII chars

          shortcutData.push([
            user_id,
            userCompanyMap[user_id] || null,
            0, // shortcut_type
            user_id, // created_by
            null, // updated_by
            null, // deleted_by
            shortcut, // shortcuts
            1, // status
          ]);
        }
      }
    }

    if (shortcutData.length > 0) {
      console.log(`Inserting ${shortcutData.length} new records...`);

      // Split data into chunks to avoid max packet size error
      let chunkSize = 1000;
      for (let i = 0; i < shortcutData.length; i += chunkSize) {
        let chunk = shortcutData.slice(i, i + chunkSize);
        await connection.query(
          `INSERT INTO user_shortcuts 
           (user_id, company_id, shortcut_type, created_by, updated_by, deleted_by, shortcuts, status) 
           VALUES ?`,
          [chunk]
        );
      }

      console.log("Data migration completed successfully.");
    } else {
      console.log("No data to insert.");
    }

    await connection.end();
  } catch (error) {
    console.error("Migration failed:", error);
    await connection.end();
  }
}

module.exports = { migrateData };
