// const db = require('../config/database');

// const UserShortcuts = {
  
//         // Fetch all shortcuts for a user and combine them into one array
//         getShortcutsByCompanyId: async (companyId) => {
//             const [rows] = await db.query(
//               `SELECT 
//                  us.id, 
//                  us.shortcuts, 
//                  createdUser.name AS created_by, 
//                  CASE 
//                    WHEN us.updated_by IS NOT NULL THEN updatedUser.name 
//                    ELSE NULL 
//                  END AS updated_by
//                FROM 
//                  user_shortcuts us
//                LEFT JOIN users createdUser ON us.created_by = createdUser.id
//                LEFT JOIN users updatedUser ON us.updated_by = updatedUser.id
//                WHERE 
//                  us.company_id = ? 
//                  AND us.status = 1`,
//               [companyId]
//             );
          
//             if (rows.length === 0) {
//               return {
//                 shortcuts: [],
//                 shortcutdetails: [],
//               };
//             }
          
//             // Extract all shortcuts into a single array
//             const allShortcuts = rows.map(row => row.shortcuts).flat();
//             console.log(allShortcuts)
          
//             return {
//               shortcuts: allShortcuts, // All individual shortcuts in one array
//               shortcutdetails: rows.map(row => ({
//                 id: row.id,
//                 shortcut: row.shortcuts, // Shortcut as a string
//                 created_by: row.created_by,
//                 updated_by: row.updated_by || null, // Handle null cases for `updated_by`
//               })),
//             };
//           },
          
          
      
  
  
  
  
  

//   // Add a new shortcut for a user
// // Add new shortcuts for a company
//   addShortcuts: async (userId, companyId, shortcuts) => {
//     // Insert shortcuts into the database
//     const insertValues = shortcuts.map(shortcut => [userId, companyId, shortcut, userId]);
//     const [result] = await db.query(
//       'INSERT INTO user_shortcuts (user_id, company_id, shortcuts, created_by) VALUES ?',
//       [insertValues]
//     );

//     // Fetch the most recent added shortcut details
//     const [lastAddedShortcut] = await db.query(
//       `SELECT 
//          us.id, 
//            us.shortcuts, 
//          createdUser.name AS created_by, 
//          CASE 
//            WHEN us.updated_by IS NOT NULL THEN updatedUser.name 
//            ELSE NULL 
//          END AS updated_by
//        FROM 
//          user_shortcuts us
//        LEFT JOIN users createdUser ON us.created_by = createdUser.id
//        LEFT JOIN users updatedUser ON us.updated_by = updatedUser.id
//        WHERE 
//          us.company_id = ? 
//          AND us.status = 1
        
//        ORDER BY us.created_at DESC
//        LIMIT 1`,
//       [companyId]
//     );

//     return lastAddedShortcut.length ? lastAddedShortcut[0] : null;
//   },
  
//   // Delete a specific shortcut from a user's list
//    // Delete a specific shortcut
//    deleteShortcut: async (userId, companyId, shortcutId) => {
//     const [result] = await db.query(
//       'UPDATE user_shortcuts SET status = 0, deleted_by = ?, updated_at = NOW() WHERE company_id = ? AND id = ? AND status = 1',
//       [userId, companyId, shortcutId]
//     );
//     return result.affectedRows > 0; // Return success status
//   },

  
  
// };

// module.exports = UserShortcuts;
// const db = require('../config/database');

// const UserShortcuts = {
//   getShortcutsByCompanyId: async (companyId) => {
//     const [rows] = await db.query(
//       `SELECT 
//         us.shortcuts, 
//         cb.name AS created_by_name,
//         ub.name AS updated_by_name
//       FROM user_shortcuts us
//       LEFT JOIN users cb ON us.created_by = cb.id
//       LEFT JOIN users ub ON us.updated_by = ub.id
//       WHERE us.company_id = ? AND us.status = 1`, [companyId]
//     );

//     if (rows.length > 0) {
//       return {
//         shortcuts: JSON.parse(rows[0].shortcuts),
//         createdByName: rows[0].created_by_name || null,
//         updatedByName: rows[0].updated_by_name || null
//       };
//     } else {
//       return { shortcuts: [], createdByName: null, updatedByName: null };
//     }
//   },

//   addShortcuts: async (userId, companyId, shortcuts, createdBy) => {
//     const [exists] = await db.query(
//       'SELECT id, shortcuts FROM user_shortcuts WHERE user_id = ? AND company_id = ? AND status = 1', [userId, companyId]
//     );

//     if (exists.length > 0) {
//       const currentShortcuts = JSON.parse(exists[0].shortcuts);
//       currentShortcuts.push(...shortcuts);

//       await db.query(
//         'UPDATE user_shortcuts SET shortcuts = ?, updated_by = ? WHERE user_id = ? AND company_id = ?',
//         [JSON.stringify(currentShortcuts), createdBy, userId, companyId]
//       );
//       return exists[0].id;
//     } else {
//       const [result] = await db.query(
//         'INSERT INTO user_shortcuts (user_id, company_id, shortcuts, created_by, status) VALUES (?, ?, ?, ?, 1)',
//         [userId, companyId, JSON.stringify(shortcuts), createdBy]
//       );
//       return result.insertId;
//     }
//   },

//   updateShortcut: async (shortcutId, newShortcut, updatedBy) => {
//     const [result] = await db.query(
//       'UPDATE user_shortcuts SET shortcuts = JSON_REPLACE(shortcuts, \'$[?].text\', ?), updated_by = ? WHERE id = ? AND status = 1',
//       [newShortcut, updatedBy, shortcutId]
//     );

//     if (result.affectedRows > 0) {
//       return true; // Successfully updated
//     }
//     return false; // No matching shortcut found or update failed
//   },

//   deleteShortcut: async (shortcutId, deletedBy) => {
//     const [result] = await db.query(
//       'UPDATE user_shortcuts SET status = 0, deleted_by = ? WHERE id = ? AND status = 1',
//       [deletedBy, shortcutId]
//     );

//     if (result.affectedRows > 0) {
//       return true; // Successfully deleted
//     }
//     return false; // No matching shortcut found or delete failed
//   },
// };

// module.exports = UserShortcuts;
const db = require('../config/database');

const UserShortcuts = {
    // ✅ Get shortcuts by company ID and exclude hidden ones
    getShortcutsByCompanyId: async (companyId, userId) => {
        const [rows] = await db.query(
          `SELECT 
              us.id, 
              us.shortcuts, 
              us.shortcut_type, 
              us.created_by as user_id,
              us.status,
              IF(uhs.shortcut_id IS NULL, 0, 1) AS is_hidden,  -- Check if hidden
              createdUser.name AS created_by, 
              CASE 
                  WHEN us.updated_by IS NOT NULL THEN updatedUser.name 
                  ELSE NULL 
              END AS updated_by
          FROM user_shortcuts us
          LEFT JOIN users createdUser ON us.created_by = createdUser.id
          LEFT JOIN users updatedUser ON us.updated_by = updatedUser.id
          LEFT JOIN user_hidden_shortcuts uhs ON us.id = uhs.shortcut_id AND uhs.user_id = ?
          WHERE us.company_id = ? 
            AND us.status = 1
            AND (us.shortcut_type = 1 OR (us.shortcut_type = 0 AND us.created_by = ?))`, // Filter only private shortcuts created by the current user
          [userId, companyId, userId]
        );
      
        // Filter visible shortcuts (is_hidden === 0) and map them
        const visibleShortcuts = rows.filter(row => row.is_hidden === 0);
        
        // Map the shortcuts to include "public" or "private" in the text
        const allShortcuts = visibleShortcuts.map(row => ({
          shortcut: row.shortcuts + (row.shortcut_type === 1 ? ' ++public' : ' ++private'),
          shortcut_type: row.shortcut_type
        }));
      
        const formattedShortcuts = visibleShortcuts.map(row => ({
          text: row.shortcuts,
          type: row.shortcut_type === 1 ? "public" : "private",
          id : row.id,
        }));
      
        // Returning the structured data
        return {
          shortcuts: formattedShortcuts,  // Array of objects { text, type }
          publicShortcuts: rows.filter(row => row.shortcut_type === 1),
          privateShortcuts: rows.filter(row => row.shortcut_type === 0),
          hiddenShortcuts: rows.filter(row => row.is_hidden === 1)
        };
      },
      

// ✅ Create a new shortcut and return full shortcut details
// ✅ Create a new shortcut and return full shortcut details
createShortcut: async (companyId, userId, shortcutName, shortcutType) => {
    // Insert the new shortcut into the database without is_hidden field
    const [result] = await db.query(
        `INSERT INTO user_shortcuts (company_id, user_id, created_by, shortcuts, shortcut_type, status) 
         VALUES (?, ?, ?, ?, ?, 1)`, 
        [companyId, userId, userId, shortcutName, shortcutType]
    );

    if (!result.insertId) return null;
    // Fetch the newly created shortcut's details including the created_by username and is_hidden calculation
    const [newShortcut] = await db.query(
        `SELECT 
            us.id, 
            us.shortcuts, 
            us.shortcut_type, 
            us.created_by as user_id,
            us.status,
            IF(uhs.shortcut_id IS NULL, 0, 1) AS is_hidden,  -- Check if hidden
            createdUser.name AS created_by, 
            CASE 
                WHEN us.updated_by IS NOT NULL THEN updatedUser.name 
                ELSE NULL 
            END AS updated_by
        FROM user_shortcuts us
        LEFT JOIN users createdUser ON us.created_by = createdUser.id
        LEFT JOIN users updatedUser ON us.updated_by = updatedUser.id
        LEFT JOIN user_hidden_shortcuts uhs ON us.id = uhs.shortcut_id AND uhs.user_id = ?
        WHERE us.id = ?`,
        [userId, result.insertId]
    );

    // Add is_hidden manually in the code after the query
    if (newShortcut.length) {
        const shortcut = newShortcut[0];
        shortcut.is_hidden = 0;  // Set is_hidden manually to 0 as required
        return shortcut;
    }

    return null;  // If no shortcut found, return null
},



    // ✅ Update shortcut (Change name, type)
    updateShortcut: async (shortcutId, updatedBy, shortcutName, shortcutType) => {
        const [result] = await db.query(
            `UPDATE user_shortcuts 
             SET shortcuts = ?, shortcut_type = ?, updated_by = ?
             WHERE id = ?`,
            [shortcutName, shortcutType, updatedBy, shortcutId]
        );
        return result.affectedRows > 0;
    },

    // ✅ Delete shortcut (Mark as inactive)
    deleteShortcut: async (shortcutId) => {
        const [result] = await db.query(
            `UPDATE user_shortcuts SET status = 0 WHERE id = ?`, 
            [shortcutId]
        );
        const [shortcutDelete] = await db.query(
            `DELETE FROM user_hidden_shortcuts WHERE  shortcut_id = ?`,
            [ shortcutId]
        );
        return result.affectedRows > 0;
    },

    // ✅ Hide shortcut (Add to `user_hidden_shortcuts`)
    hideShortcut: async (userId, shortcutId) => {
        const [result] = await db.query(
            `INSERT INTO user_hidden_shortcuts (user_id, shortcut_id) 
             VALUES (?, ?) 
             ON DUPLICATE KEY UPDATE shortcut_id = shortcut_id`,
            [userId, shortcutId]
        );
        return result.affectedRows > 0;
    },

    // ✅ Unhide shortcut (Remove from `user_hidden_shortcuts`)
    unhideShortcut: async (userId, shortcutId) => {
        const [result] = await db.query(
            `DELETE FROM user_hidden_shortcuts WHERE user_id = ? AND shortcut_id = ?`,
            [userId, shortcutId]
        );
        return result.affectedRows > 0;
    }
};

module.exports = UserShortcuts;
