const mysql = require("mysql2/promise");
require("dotenv").config();
const pool = mysql.createPool({
    host: process.env.DB_HOST,
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    port: process.env.DB_PORT,
    database: process.env.DB_DATABASE,
});


 

async function resetActiveSessions() {
  try {
    const connection = await pool.getConnection();
    
    // Reset visitor sessions
    await connection.query("UPDATE visitor_session SET status = 4 WHERE status != 4");
    
    // Reset active chat sessions
    await connection.query("UPDATE chat_sessions SET is_active = 0 WHERE is_active = 1");

    console.log("All active sessions reset on server restart.");
    
    connection.release();
    process.exit(); // Exit after execution
  } catch (error) {
    console.error("Error resetting active sessions:", error);
    process.exit(1); // Exit with error code
  }
}

// Run the reset function
resetActiveSessions();
