const express = require('express');
const router = express.Router();
const autoReplyController = require('../controllers/autoReplyController');
const { verifyToken } = require('../middleware/role');

// Create an autoReply
router.post('/autoReply', verifyToken, autoReplyController.CreateAutoReplyForBrand);

// Get  autoReply for specific brand
router.get('/autoReply/:brand_id',verifyToken,  autoReplyController.getAutoReplyForSpecificBrand);

//update auto reply for specific brand
router.put('/autoReply', verifyToken, autoReplyController.updateAutoReplyForSpecificBrand);
 
 
module.exports = router;
