const express = require('express');
const router = express.Router();
const chatController = require('../controllers/chatController');
const { verifyToken } = require('../middleware/role');

router.post('/start', chatController.startChat);
router.get('/chat-visitors/:brand_id',verifyToken, chatController.chatsNoti);
router.get('/active', chatController.getActiveChats);

// Fetch messages by chatKey
router.post('/messages',  chatController.getMessagesByChatKey);
router.post('/messages-by-session-id',  chatController.getMessagesByChatSessionId);
router.post('/upload',  chatController.uploadFile);
module.exports = router;
