const multer = require('multer');
require('dotenv').config(); 
const { createBrand,editBrand, findBrandById, findAllBrandsByCompany,getAllBrandsNameByCompany, updateBrand, enableBrand, disableBrand, getAllUsersforAssignBrand,getAllUsersforAssignBrandCompulosryModel, updateUsersforAssignBrand, getAllBrandsAssignsforCompanyUsers, updateBrandsforAssignUsers, findBrandsByCompanyAndUser, getUserInformation, insertBrandAssignee, checkCanCreateBrand, assignBrandToUser,getAllBrandsWithCompany,getAllUsersforAssignFilter ,fetchAllBrandsWithCompanies} = require('../models/brandModel');
const path = require('path');
const fs = require('fs');
const { userInfo } = require('os');
const https = require('https');
const { encryptData } = require('../middleware/EncryptDecryptData');
// Configure multer for file uploads
 // Configure multer for file uploads
 
// Configure multer for file uploads
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'public/uploads/logos'); // Ensure this directory exists
  },
  filename: function (req, file, cb) {
    cb(null, file.originalname + Date.now() + path.extname(file.originalname)); // Use timestamp to create a unique file name
  }
});

const upload = multer({ storage: storage }).single('logo');

const isValidImageUrl = (url) => {
  return new Promise((resolve, reject) => {
    const parsedUrl = new URL(url);
    const options = {
      method: 'HEAD',
      hostname: parsedUrl.hostname,
      path: parsedUrl.pathname,
    };

    https.request(options, (res) => {
      const contentType = res.headers['content-type'];
      if (res.statusCode === 200 && contentType && contentType.startsWith('image/')) {
        resolve(true);
      } else {
        resolve(false);
      }
    }).on('error', (err) => {
      reject(err);
    }).end();
  });
};

const downloadImage = (url, dest) => {
  return new Promise((resolve, reject) => {
    const file = fs.createWriteStream(dest);
    https.get(url, (response) => {
      response.pipe(file);
      file.on('finish', () => {
        file.close(resolve);
      });
    }).on('error', (err) => {
      fs.unlink(dest, () => reject(err)); // Clean up on error
    });
  });
};

exports.createBrand = (req, res) => {
  upload(req, res, async (err) => {
    if (err) {
      return res.status(500).json({ error: 'Error uploading logo', details: err.message });
    }

    try {
      const { name, url, domainName, phone, email, timeZone, status, company_id, created_by, logoUrl } = req.body;

      let logoPath = null;

      if (logoUrl) {
        try {
          const isValid = await isValidImageUrl(logoUrl);
          if (!isValid) {
            return res.status(400).json({ error: 'Invalid image URL' });
          }

          const fileName = `logo_${Date.now()}${path.extname(logoUrl)}`;
          const filePath = path.join('public/uploads/logos', fileName);

          await downloadImage(logoUrl, filePath);

          logoPath = filePath.replace(/^public[\\/]/, ''); // Remove 'public\' from file path
        } catch (downloadError) {
          return res.status(500).json({ error: 'Error downloading logo from URL', details: downloadError.message });
        }
      } else if (req.file) {
        logoPath = req.file.path.replace(/^public[\\/]/, ''); // Remove 'public\' from file path
      } else {
        return res.status(400).json({ error: 'No logo provided. Either upload a file or provide a logo URL.' });
      }

      const { result, publicKey } = await createBrand(name, url, domainName, phone, email, logoPath, timeZone, status, company_id, created_by);
      const { role, userId } = req.user;

      if (role === 2) {
        const canCreateBrand = await checkCanCreateBrand(userId);
        if (canCreateBrand) {
          const brandId = result.insertId;
          await assignBrandToUser(userId, brandId, created_by, publicKey);
        }
      }

      res.status(201).json({ message: 'Brand created successfully', id: result.insertId });
    } catch (error) {
      res.status(500).json({ error: 'Error creating brand', details: error.message });
    }
  });
};
exports.EditBrand = (req, res) => {
    upload(req, res, async (err) => {
      if (err) {
        return res.status(500).json({ error: 'Error uploading logo', details: err.message });
      }
  
      try {
        const { brandId, name, url, domainName, phone, email, timeZone, status, updated_by, logoUrl,logo } = req.body;
        let logoPath = null;
        console.log("brand id ", brandId);
        console.log(brandId, name, url, domainName, phone, email, timeZone, status, updated_by, logoUrl);
        
        
        if (logoUrl) {
          try {
            const isValid = await isValidImageUrl(logoUrl);
            if (!isValid) return res.status(400).json({ error: 'Invalid image URL' });
  
            const fileName = `logo_${Date.now()}${path.extname(logoUrl)}`;
            const filePath = path.join('public/uploads/logos', fileName);
  
            await downloadImage(logoUrl, filePath);
  
            logoPath = filePath.replace(/^public[\\/]/, '');
          } catch (downloadError) {
            return res.status(500).json({ error: 'Error downloading logo', details: downloadError.message });
          }
        } else if (req.file) {
          logoPath = req.file.path.replace(/^public[\\/]/, '');
        }
        if (req.file) {
            console.log('Uploaded file:', req.file);
          } else {
            console.log('No file uploaded');
          }
        console.log("logo path", logoPath);
        
        const updateResult = await editBrand(brandId, name, url, domainName, phone, email, logoPath, timeZone, status, updated_by);
  
        if (updateResult.affectedRows === 0) {
          return res.status(404).json({ error: 'Brand not found or no changes made' });
        }
  
        res.status(200).json({ message: 'Brand updated successfully' });
      } catch (error) {
        res.status(500).json({ error: 'Error updating brand', details: error.message });
      }
    });
  };
  


exports.updateBrand = (req, res) => {
  upload(req, res, async (err) => {
    if (err) {
      return res.status(500).json({ error: 'Error uploading logo' });
    }

    try {
      const { name, url, domainName, phone, email, timeZone, status } = req.body;
      const logoPath = req.file ? req.file.path : req.body.logoPath; // Keep existing path if no new file uploaded

      const result = await updateBrand(req.params.id, name, url, domainName, phone, email, logoPath, timeZone, status);
      if (result.affectedRows === 0) return res.status(404).json({ message: 'Brand not found' });
      res.json({ message: 'Brand updated successfully' });
    } catch (error) {
      res.status(500).json({ error: 'Error updating brand' });
    }
  });
};
 
exports.getBrandById = async (req, res) => {
  try {
    const brand = await findBrandById(req.params.id);
    if (!brand) return res.status(404).json({ message: 'Brand not found' });
    res.json(encryptData(brand));
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving brand' });
  }
};


exports.getAllBrandsByCompany = async (req, res) => {
  try {
    const userlogs = req.user;
    const companyId = req.params.compId;
    
    
    // Super Admin: Fetch all brands by company ID
    if (userlogs.role == 1) {
      const brands = await findAllBrandsByCompany(companyId);
      const updatedBrands = brands.map(brand => ({
        ...brand,
        logo: `${process.env.BACKEND_URL}/${brand.logo.replace(/\\/g, '/')}` // Adjust based on your setup
      }));
      return res.json(encryptData(updatedBrands));
    }

    // Admin: Fetch brands by company ID and user ID
    else if (userlogs.role == 2 || userlogs.role ==3 || userlogs.role == 4) {
      const brands = await findBrandsByCompanyAndUser(userlogs.userId);
      const updatedBrands = brands.map(brand => ({
        ...brand,
        logo:`${process.env.BACKEND_URL}/${brand.logo.replace(/\\/g, '/')}` // Adjust based on your setup
      }));
      
      const encryptedUpdatedBrands = encryptData(updatedBrands)
      return res.json(encryptData(updatedBrands));
    }

    // Handle other roles or default case if necessary
    else {
      return res.status(403).json({ error: 'Access denied' });
    }

  } catch (error) {
    res.status(500).json({ error: 'Error retrieving brands' });
  }
};
exports.getAllBrandsWithCompany = async (req, res) => {
    try {
      const { role } = req.user;
  
      // Ensure only Super Admins (role = 1) can access this route
      if (role !== 1) {
        return res.status(403).json({ error: 'Access denied' });
      }
  
      // Fetch all brands with their associated company names
      const brands = await fetchAllBrandsWithCompanies();
  
      // Map and format the data for response
      const formattedBrands = brands.map((brand) => ({
        logo: `${process.env.BACKEND_URL}/${brand.logo.replace(/\\/g, '/')}`, // Ensure proper logo URL
        brandName: brand.brand_name,
        url: brand.url,
        company: brand.company_name,
        phone: brand.phone,
        company_id: brand.company_id,
        brand_id: brand.brand_id,
        email: brand.email,
        status: brand.status === 1 ? 'Active' : 'Inactive', // Convert status to human-readable format
      }));
  
      res.json(encryptData(formattedBrands));
    } catch (error) {
      console.error('Error retrieving brands:', error);
      res.status(500).json({ error: 'Error retrieving brands' });
    }
  };
exports.getAllBrandsNameByCompany = async (req, res) => {
  try {
    console.log(req.params.compId)
    const brands = await  getAllBrandsNameByCompany(req.params.compId);
  
    res.json(encryptData(brands));
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving brands' });
  }
};
exports.getAllUsersforAssignBrand = async (req, res) => {
    try {
      const { brandid, company_id, filter } = req.query;
      console.log(filter, "filter is", filter);
  
      let users;
  
      if (filter) {
        // Retrieve filtered users if filter exists
        users = await getAllUsersforAssignFilter(brandid, company_id);
      } else {
        // Retrieve all users if no filter is applied
        users = await getAllUsersforAssignBrand(brandid, company_id);
      }
  
      res.status(200).json(users);
    } catch (error) {
      console.error("Error retrieving users:", error); // Log the full error for debugging
      res.status(500).json({ error: "Error retrieving users" });
    }
  };
  

exports.getAllUsersforAssignBrandCompulosry = async (req, res) => {
  try {
    
    
    const {brandid,company_id,compulsory} = req.query;
    let brands; 
   if(req.query.compulsory){
    brands = await  getAllUsersforAssignBrandCompulosryModel(brandid,company_id,true );
   }
   else{
    brands = await  getAllUsersforAssignBrandCompulosryModel(brandid,company_id,false );
   }
    
  
  
    res.json(encryptData(brands));
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving brands' });
  }
};
exports.getAllBrandsAssignsforCompanyUsers = async (req, res) => {
  try {
    
    const userlogs = req.user;
    const {userId,company_id} = req.query;
    console.log(userId,company_id);
    if (userlogs.role == 1) {
        try {
            // Fetch all brands with company info
            const brandsWithCompany = await getAllBrandsWithCompany(userId);
            
            // Return the result
            return res.status(200).json(brandsWithCompany);
        } catch (error) {
            console.error("Error fetching brands with company:", error);
            return res.status(500).json({ message: "An error occurred while fetching brands with company." });
        }
    }
    else{
        const brands = await  getAllBrandsAssignsforCompanyUsers(userId,company_id );
        res.json(encryptData(brands));
    }
  
   
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving brands' });
  }
};
exports.updateUsersforAssignBrand = async (req, res) => {
 try{
 
    const { brandId, company_id, users, createdBy } = req.body;
    // console.log(users);
   const updateresponse =  await  updateUsersforAssignBrand(brandId, company_id, users, createdBy );
   

   res.status(200).send('Assignments updated successfully.');
  } catch (error) {
    console.error('Error updating assignments:', error);
    res.status(500).send('An error occurred while updating assignments.');
  }
}
exports.updateBrandsforAssignUsers = async (req, res) => {
 try{
 
  console.log("api hit");
  
    const { userId, company_id, brands, createdBy } = req.body;
  
      
   const updateresponse =  await  updateBrandsforAssignUsers(userId, brands, createdBy );
   

   res.status(200).send('Assignments updated successfully.');
  } catch (error) {
    console.error('Error updating assignments:', error);
    res.status(500).send('An error occurred while updating assignments.');
  }
}
  
  

 

exports.enableBrand = async (req, res) => {
  try {
    const result = await enableBrand(req.params.id);
    if (result.affectedRows === 0) return res.status(404).json({ message: 'Brand not found' });
    res.json({ message: 'Brand enabled successfully' });
  } catch (error) {
    res.status(500).json({ error: 'Error enabling brand' });
  }
};

exports.disableBrand = async (req, res) => {
  try {
    const result = await disableBrand(req.params.id);
    if (result.affectedRows === 0) return res.status(404).json({ message: 'Brand not found' });
    res.json({ message: 'Brand disabled successfully' });
  } catch (error) {
    res.status(500).json({ error: 'Error disabling brand' });
  }
};
