const jwt = require('jsonwebtoken'); // Import JWT library to generate token
const db = require('../config/database'); // Assume you have a database connection set up in a config file
const crypto = require('crypto');
const JWT_SECRET = process.env.JWT_SECRET;
const JWT_REFRESH_SECRET =process.env.JWT_REFRESH_SECRET
const chatPortalController = {
    async getchathash(req, res) {
        const { t, u, e, i, r,d } = req.body;
        const forwarded = req.headers["x-forwarded-for"];
        let ip = forwarded ? forwarded.split(/, /)[0] : req.connection.remoteAddress;

        // Remove IPv6 prefix if it exists (i.e., ::ffff:)
        if (ip.startsWith('::ffff:')) {
            ip = ip.replace('::ffff:', '');
        }

        // Convert IP to MD5 hash
        const ipHash = crypto.createHash('md5').update(ip).digest('hex');

       // Convert IP to MD5 hash
    //    const ipHash = crypto.createHash('md5').update(ip).digest('hex');
     
       
        const time = t;
        const hrmkey = u;
        const encryptData = e;
        const user_ip = i;
        const random_number = r;
        const device_id = d;
        
        // Calculate the time difference (in milliseconds)
        const timeInMilliseconds = time * 1000;  // Convert to milliseconds

        // Calculate the time difference in milliseconds
        const time_diff = Date.now() - timeInMilliseconds;
     
        // Abort if the time difference is more than 30 seconds (30,000 milliseconds)
        if (time_diff > 30000) {  // 30 seconds in milliseconds
            return res.status(400).json({ message: "Request timeout. Please try again." });
        }
        const userAgent = req.headers["user-agent"];
        let deviceType = "Unknown";
        if (/Mobi|Android|iPhone|iPad|iPod|Windows Phone/i.test(userAgent)) {
            deviceType = "Mobile";
        } else {
            deviceType = "Desktop";
        }
        console.log(deviceType);
        
        const browserMatch = userAgent.match(/(Chrome|Firefox|Safari|Opera|MSIE|Trident)/);
        const osMatch = userAgent.match(/(Windows|Macintosh|Linux|Android|iPhone)/);

        const browser = browserMatch ? browserMatch[0] : "Unknown Browser";
        const os = osMatch ? osMatch[0] : "Unknown OS";

         if(deviceType =='Mobile'){
            return res.status(400).json({ message: "Invalid data. Verification failed M." });
         }
        
        if(user_ip != ipHash){
            return res.status(400).json({ message: "Invalid data. Verification failed. I" });
        }
      
        

        try {
            // Fetch user details using the hrmkey
            const query = `SELECT id as user_id,company_id,status, name, pseudonym, email, hrm_id, chat_hash, role_id AS role, canCreateUsers, canCreateBrand 
                           FROM users WHERE chat_hash = ?`;
            const [user] = await db.query(query, [hrmkey]);

            // If no user is found, return an error message
            if (!user) {
                return res.status(404).json({ message: "User not found." });
            }
           if(user[0].status  == 0){
            return res.status(404).json({ message: "User not found." });
           }
            
            // Decrypt data
            const hrm_id = user[0].hrm_id;
            const decryptData = (encryptData - hrm_id) / 4;
            console.log(decryptData," decryptData");
            
            
            // Validate decrypted data with the provided time
            if (decryptData == time) {
                // If validation is successful, generate a token
                const payload = {
                    user_id: user[0].user_id,
                    name: user[0].name,
                    pseudonym: user[0].pseudonym,
                    email: user[0].email,
                    role: user[0].role,
                    canCreateUsers: user[0].canCreateUsers,
                    canCreateBrand: user[0].canCreateBrand,
                    company_id: user[0].company_id,
                    roleVerified:true,
                    success:true

                };

                // Generate JWT token (secret key should be defined in your environment variables)
                // const token = jwt.sign({ userId:user[0].user_id}, process.env.JWT_SECRET, { expiresIn: '1D' });
                const accessToken = jwt.sign({ userId: user[0].user_id}, JWT_SECRET, { expiresIn: '1h' }); // Short-lived
                const refreshToken = jwt.sign({ userId: user[0].user_id }, JWT_REFRESH_SECRET, { expiresIn: '7D' }); // Long-lived
          
                // Update old sessions to mark them as inactive (status 0)
                await db.query(`
                    UPDATE user_sessions 
                    SET status = 0 
                    WHERE user_id = ? AND status = 1
                `, [user[0].user_id]);
          
                // Insert new session with status 1 (active)
                await db.query(`
                    INSERT INTO user_sessions (user_id, device_id,user_ip, refresh_token, status, created_at)
                    VALUES (?, ?, ?, ?, 1, NOW())
                `, [user[0].user_id, device_id,ip, refreshToken]);
          
                // Send the user data with the token
                return res.status(200).json({
                    message: "Login successful",
                    token:accessToken,
                    refreshToken,
                    user: payload
                });
            } else {
                // If validation fails, return an error
                return res.status(400).json({ message: "Invalid data. Verification failed... D" });
            }
        } catch (error) {
            // Catch any errors during the database operation or processing
            console.error("Error in getchathash:", error);
            return res.status(500).json({ message: "An internal server error occurred." });
        }
    }
};

module.exports = chatPortalController;
