// middlewares/errorHandler.js
const errorHandler = (err, req, res, next) => {
    // Set default error status and message
    const statusCode = err.statusCode || 500;
    const message = err.message || 'Internal Server Error';
  
    // Log the error (you can use a logging library like Winston for more advanced logging)
    // console.error(err);
  
    // Send the error response
    res.status(statusCode).json({
      status: 'error',
      statusCode,
      message
    });
  };
  
  module.exports = errorHandler;
  