const db = require('../config/database');
const { generateUUIDWithDate } = require('../services/script-service/utils/uuidGenerator');
 

// Create a new brand
const createBrand = async (name, url, domainName, phone, email, logoPath, timeZone, status, compId, created_by) => {
  // Generate public key
  console.log("Generating publicKey");
  const publicKey = await generateUUIDWithDate();  // Assuming this function generates a unique public key
  console.log("Generated publicKey:", publicKey);

  // Insert new brand into the database
  const [result] = await db.query(
    'INSERT INTO brands (name, url, public_key, domain_name, phone, email, logo, time_zone, created_by, created_at, status, company_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?)',
    [name, url, publicKey, domainName, phone, email, logoPath, timeZone, created_by, status, compId]
  );

  // Return the result along with the generated publicKey
  return { result, publicKey };
};

const editBrand = async (brandId, name, url, domainName, phone, email, logoPath, timeZone, status, updated_by) => {
    const fields = [];
    const values = [];
  
    if (name) fields.push('name = ?'), values.push(name);
    if (url) fields.push('url = ?'), values.push(url);
    if (domainName) fields.push('domain_name = ?'), values.push(domainName);
    if (phone) fields.push('phone = ?'), values.push(phone);
    if (email) fields.push('email = ?'), values.push(email);
    if (logoPath) fields.push('logo = ?'), values.push(logoPath);
    if (timeZone) fields.push('time_zone = ?'), values.push(timeZone);
    if (status !== undefined) fields.push('status = ?'), values.push(status);
  
    fields.push('updated_by = ?'), values.push(updated_by);
    fields.push('updated_at = NOW()');
  
    values.push(brandId);
  
    const query = `UPDATE brands SET ${fields.join(', ')} WHERE id = ?;`;
    const [result] = await db.query(query, values);
  
    return result;
  };
  
  
const checkCanCreateBrand = async (userId) => {
  const [rows] = await db.query('SELECT canCreateBrand FROM users WHERE id = ?', [userId]);
  return rows[0] && rows[0].canCreateBrand === 1;
};
// const assignBrandToUser = async (userId, brandId, createdBy,publicKey) => {
//   try {
//     console.log(userId, brandId, publicKey);

//     // Inserting into the brand_assignees table
//     const [result] = await db.query(
//       'INSERT INTO brand_assignees (user_id, brand_id,brand_pk) VALUES (?, ?, ?)', 
//       [userId, brandId,publicKey]
//     );
    
//     console.log("assignee brands");  // This should log if insert is successful

//     // Log brand assignment action
//     await logBrandAssigneeAction(brandId, userId, createdBy, 1, `User with ID ${userId} assigned to brand`);
//   } catch (error) {
//     console.error("Error while assigning brand to user:", error);
//   }
// };

const logBrandAssigneeAction = async (brandId, assigneeId, createdBy, status, comment) => {
  await db.query(
    'INSERT INTO brand_assignees_logs (brand_id, assignee_id, created_by, created_at, status, comment) VALUES (?, ?, ?, NOW(), ?, ?)',
    [brandId, assigneeId, createdBy, status, comment]
  );
};






const fetchAllBrandsWithCompanies = async () => {
    const query = `
      SELECT 
        b.logo,
        b.name AS brand_name,
        b.id AS brand_id,
        b.url,
        b.phone,
        b.email,
        b.status,
        c.name AS company_name,
        c.id AS company_id
      FROM 
        brands b
      INNER JOIN 
        companies c 
      ON 
        b.company_id = c.id
      ORDER BY 
        b.name ASC
    `;
  
    const [results] = await db.query(query);
    return results;
  };


// Find a brand by ID
const findBrandById = async (id) => {
  const [rows] = await db.query('SELECT * FROM brands WHERE id = ?', [id]);
  return rows[0];
};

 
// Find all brands for a specific company
const findAllBrandsByCompany = async (compId) => {
  const [rows] = await db.query('SELECT * FROM brands WHERE company_id = ?', [compId]);
  return rows;
};const getAllBrandsNameByCompany = async (compId) => {
  const [rows] = await db.query('SELECT id, name  FROM brands WHERE company_id = ?', [compId]);
  return rows;
};
const getAllUsersforAssignBrand = async (brandId,companyId,compulsory) => {
  console.log(brandId,companyId);
  
  const [users] = await db.query(`
    SELECT 
      u.id as user_id, 
      u.pseudonym as user_name, 
      u.name,
        u.company_id,
      c.name as company_name,
      CASE WHEN ba.user_id IS NOT NULL AND ba.status = 1 THEN 1 ELSE 0 END as assigned 
    FROM 
      users u 
    LEFT JOIN 
      brand_assignees ba 
    ON 
      u.id = ba.user_id AND ba.brand_id = ? 
       LEFT JOIN
    companies c ON c.id = u.company_id
    WHERE 
      u.company_id = ?
  `, [brandId, companyId]);

 
  return users;
};
const getAllUsersforAssignFilter = async (brandId, companyId) => {
    let users;
    console.log(companyId)
    console.log("companyId")
    console.log("brandId")
    console.log("brandId", brandId)
    if (companyId == 0) {
      [users] = await db.query(
        `
        SELECT 
          u.id as user_id, 
          u.pseudonym as user_name, 
          u.name,
           u.company_id,
      c.name as company_name,
          CASE WHEN ba.user_id IS NOT NULL AND ba.status = 1 THEN 1 ELSE 0 END as assigned 
        FROM 
          users u 
        LEFT JOIN 
          brand_assignees ba 
        ON 
          u.id = ba.user_id AND ba.brand_id = ? 
             LEFT JOIN
    companies c ON c.id = u.company_id
    where u.status = 1
     
        `,
        [brandId]
      );
    } else {
      [users] = await db.query(
        `
        SELECT 
          u.id as user_id, 
          u.pseudonym as user_name, 
          u.name,
           u.company_id,
      c.name as company_name,
          CASE WHEN ba.user_id IS NOT NULL AND ba.status = 1 THEN 1 ELSE 0 END as assigned 
        FROM 
          users u 
        LEFT JOIN 
          brand_assignees ba 
        ON 
          u.id = ba.user_id AND ba.brand_id = ? 
             LEFT JOIN
    companies c ON c.id = u.company_id
        WHERE 
          u.company_id = ? and u.status = 1
        `,
        [brandId, companyId]
      );
    }
  
    return users; // Return the users array
  };
const getAllUsersforAssignBrandCompulosryModel = async (brandId,companyId,compulsory) => {
   let users;
  if(compulsory){
    [users] = await db.query(`
    SELECT 
      u.id as user_id, 
      u.pseudonym as user_name, 
      u.name,
      
      CASE WHEN ba.user_id IS NOT NULL  AND ba.status = 1 THEN 1 ELSE 0 END as assigned 
    FROM 
      users u 
    LEFT JOIN 
      brand_assignees ba 
    ON 
      u.id = ba.user_id AND ba.brand_id = ? 
    WHERE 
      
      u.compulsory = 1
  `, [brandId, companyId]);
  }
  else{
    [users] = await db.query(`
        SELECT 
          u.id as user_id, 
          u.pseudonym as user_name, 
          u.name,
          
          CASE WHEN ba.user_id IS NOT NULL  AND ba.status = 1 THEN 1 ELSE 0 END as assigned 
        FROM 
          users u 
        LEFT JOIN 
          brand_assignees ba 
        ON 
          u.id = ba.user_id AND ba.brand_id = ? 
        WHERE 
          u.company_id = ?
        
      `, [brandId, companyId]);
  }
 
  return users;
};
const getAllBrandsWithCompany = async (userId) => {
    // Fetch all brands with their associated company information and assignment status for the user
    const [brandsWithCompany] = await db.query(`
        SELECT 
            b.id AS brand_id, 
            b.name AS brand_name, 
            c.id AS company_id, 
            c.name AS company_name,
            CASE 
                WHEN ba.user_id IS NOT NULL AND ba.status = 1 THEN 1
                ELSE 0
            END AS assigned
        FROM 
            brands b
        JOIN 
            companies c 
        ON 
            b.company_id = c.id
        LEFT JOIN 
            brand_assignees ba 
        ON 
            b.id = ba.brand_id AND ba.user_id = ?
        ORDER BY 
            c.id, b.id
    `, [userId]);

    return brandsWithCompany;
};

const getAllBrandsAssignsforCompanyUsers = async (userId, companyId) => {
 

  const [brands] = await db.query(`
    SELECT 
      b.id as brand_id, 
      b.name as brand_name, 
      CASE WHEN ba.user_id IS NOT NULL AND ba.status = 1 THEN 1 ELSE 0 END as assigned 
    FROM 
      brands b
    LEFT JOIN 
      brand_assignees ba 
    ON 
      b.id = ba.brand_id AND ba.user_id = ?
    WHERE 
      b.company_id = ?
    ORDER BY 
      b.id
  `, [userId, companyId]);

  return brands;
};
const findBrandsByCompanyAndUser = async ( userId) => {
  
  
  const query = `
    SELECT b.*
    FROM brand_assignees ba
    JOIN brands b ON ba.brand_id = b.id
    WHERE ba.user_id = ? and ba.status = 1
  `;
  
  const [rows] = await db.query(query, [userId]);
 
  return rows;
};

// const updateUsersforAssignBrand = async (brandId, company_id, users, createdBy) => {
//     // Step 1: Fetch existing assignments from the database
//     const [existingAssignments] = await db.query(
//         'SELECT user_id FROM brand_assignees WHERE brand_id = ?',
//         [brandId]
//     );

//     // Ensure all IDs are integers for consistent comparison
//     const existingUserIds = existingAssignments.map((row) => parseInt(row.user_id));

//     // Step 2: Determine which users need to be assigned or unassigned
//     const assignedUserIds = users
//         .filter((user) => user.assigned === 1 && !existingUserIds.includes(parseInt(user.user_id)))
//         .map((user) => parseInt(user.user_id));

//     const unassignedUserIds = users
//         .filter((user) => user.assigned === 0 && existingUserIds.includes(parseInt(user.user_id)))
//         .map((user) => parseInt(user.user_id));

//     // Debugging information
//     console.log("Assigned User IDs:", assignedUserIds);
//     console.log("Unassigned User IDs:", unassignedUserIds);
//     console.log("Existing User IDs:", existingUserIds);

//     // Step 3: Delete all unassigned users in a single query
//     if (unassignedUserIds.length > 0) {
//         await db.query(
//             `DELETE FROM brand_assignees WHERE brand_id = ? AND user_id IN (?)`,
//             [brandId, unassignedUserIds]
//         );

//         // Log the unassignments
//         const unassignLogValues = unassignedUserIds.map((userId) => [
//             brandId,
//             userId,
//             createdBy,
//             new Date(),
//             0, // 0 for unassigned
//             `User with ID ${userId} unassigned from brand`
//         ]);

//         await db.query(
//             `INSERT INTO brand_assignees_logs (brand_id, assignee_id, created_by, created_at, status, comment) VALUES ?`,
//             [unassignLogValues]
//         );
//     }

//     // Step 4: Insert only the new assignments in a single query
//     if (assignedUserIds.length > 0) {
//         const values = assignedUserIds.map((userId) => [brandId, userId]);
        
//         await db.query(
//             `INSERT INTO brand_assignees (brand_id, user_id) VALUES ? ON DUPLICATE KEY UPDATE user_id = user_id`,
//             [values]
//         );

//         // Log the assignments
//         const assignLogValues = assignedUserIds.map((userId) => [
//             brandId,
//             userId,
//             createdBy,
//             new Date(),
//             1, // 1 for assigned
//             `User with ID ${userId} assigned to brand`
//         ]);

//         await db.query(
//             `INSERT INTO brand_assignees_logs (brand_id, assignee_id, created_by, created_at, status, comment) VALUES ?`,
//             [assignLogValues]
//         );
//     }
// };




const updateBrandsforAssignUsers = async (userId, brands, createdBy) => {
    // Step 1: Fetch existing assignments with status = 1 (assigned) from the database
    console.log(userId, brands, createdBy);
    const [existingAssignments] = await db.query(
        'SELECT brand_id FROM brand_assignees WHERE user_id = ? AND status = 1',
        [userId]
    );

    const existingBrandIds = existingAssignments.map((row) => row.brand_id);

    // Step 2: Determine which brands need to be assigned or unassigned
    const assignedBrandIds = brands
        .filter((brand) => brand.assigned === 1 && !existingBrandIds.includes(brand.brand_id))
        .map((brand) => brand.brand_id);

    const unassignedBrandIds = brands
        .filter((brand) => brand.assigned === 0 && existingBrandIds.includes(brand.brand_id))
        .map((brand) => brand.brand_id);

    // Step 3: Update unassigned brands to have a status of 0
    if (unassignedBrandIds.length > 0) {
        await db.query(
            `UPDATE brand_assignees 
             SET status = 0, updated_at = ? 
             WHERE user_id = ? AND brand_id IN (?)`,
            [new Date(), userId, unassignedBrandIds]
        );

        // Log the unassignments
        const unassignLogValues = unassignedBrandIds.map((brandId) => [
            brandId,
            userId,
            createdBy,
            new Date(),
            0, // 0 for unassigned
            `Brand with ID ${brandId} unassigned from user`
        ]);

        await db.query(
            `INSERT INTO brand_assignees_logs (brand_id, assignee_id, created_by, created_at, status, comment) VALUES ?`,
            [unassignLogValues]
        );
    }

    // Step 4: Insert new assignments with a status of 1 or update the status of existing assignments
    if (assignedBrandIds.length > 0) {
        // Insert new assignments or update status to 1 for existing brands
        await Promise.all(
            assignedBrandIds.map(async (brandId) => {
                const [existingAssignment] = await db.query(
                    'SELECT id FROM brand_assignees WHERE user_id = ? AND brand_id = ?',
                    [userId, brandId]
                );

                if (existingAssignment.length > 0) {
                    // Update status to 1 if the brand is already in the table
                    await db.query(
                        `UPDATE brand_assignees 
                         SET status = 1, updated_at = ? 
                         WHERE user_id = ? AND brand_id = ?`,
                        [new Date(), userId, brandId]
                    );
                } else {
                    // Insert as a new assignment
                    await db.query(
                        `INSERT INTO brand_assignees (user_id, brand_id, created_at, status) 
                         VALUES (?, ?, ?, 1)`,
                        [userId, brandId, new Date()]
                    );
                }
            })
        );

        // Log the assignments
        const assignLogValues = assignedBrandIds.map((brandId) => [
            brandId,
            userId,
            createdBy,
            new Date(),
            1, // 1 for assigned
            `Brand with ID ${brandId} assigned to user`
        ]);

        await db.query(
            `INSERT INTO brand_assignees_logs (brand_id, assignee_id, created_by, created_at, status, comment) VALUES ?`,
            [assignLogValues]
        );
    }
};



  

// Update a brand by ID
const updateBrand = async (id, name, url, domainName, phone, email, logoPath, timeZone, status) => {
  const [result] = await db.query(
    'UPDATE brands SET name = ?, url = ?, domainName = ?, phone = ?, email = ?, logoPath = ?, timeZone = ?, status = ? WHERE id = ?',
    [name, url, domainName, phone, email, logoPath, timeZone, status, id]
  );
  return result;
};
const updateUsersforAssignBrand = async (brandId, company_id, users, createdBy) => {
    // Step 1: Fetch existing assignments for the brand
    const [existingAssignments] = await db.query(
        'SELECT user_id, status FROM brand_assignees WHERE brand_id = ?',
        [brandId]
    );

    // Convert to a map for efficient lookups
    const existingUserMap = existingAssignments.reduce((map, row) => {
        map[row.user_id] = row.status;
        return map;
    }, {});

    const assignPromises = [];
    const unassignPromises = [];

    // Step 2: Process each user to determine if they need to be assigned or unassigned
    for (const user of users) {
        const userId = parseInt(user.user_id);
        const isAssigned = user.assigned === 1;

        if (isAssigned) {
            if (existingUserMap[userId] === undefined) {
                // New assignment
                assignPromises.push(
                    db.query(
                        'INSERT INTO brand_assignees (brand_id, user_id, status, created_at) VALUES (?, ?, 1, ?)',
                        [brandId, userId, new Date()]
                    )
                );
            } else if (existingUserMap[userId] === 0) {
                // Reactivate existing assignment
                assignPromises.push(
                    db.query(
                        'UPDATE brand_assignees SET status = 1, updated_at = ? WHERE brand_id = ? AND user_id = ?',
                        [new Date(), brandId, userId]
                    )
                );
            }
        } else {
            if (existingUserMap[userId] === 1) {
                // Unassign existing user
                unassignPromises.push(
                    db.query(
                        'UPDATE brand_assignees SET status = 0, updated_at = ? WHERE brand_id = ? AND user_id = ?',
                        [new Date(), brandId, userId]
                    )
                );
            }
        }
    }

    // Step 3: Execute all database queries
    await Promise.all([...assignPromises, ...unassignPromises]);

    // Step 4: Log all changes
    const logValues = users.map(user => [
        brandId,
        user.user_id,
        createdBy,
        new Date(),
        user.assigned === 1 ? 1 : 0,
        user.assigned === 1
            ? `User with ID ${user.user_id} assigned to brand`
            : `User with ID ${user.user_id} unassigned from brand`
    ]);

    if (logValues.length > 0) {
        await db.query(
            `INSERT INTO brand_assignees_logs (brand_id, assignee_id, created_by, created_at, status, comment) VALUES ?`,
            [logValues]
        );
    }
};

const assignBrandToUser = async (userId, brandId, createdBy, publicKey) => {
    try {
        const [existingAssignment] = await db.query(
            'SELECT status FROM brand_assignees WHERE user_id = ? AND brand_id = ?',
            [userId, brandId]
        );

        if (!existingAssignment) {
            // New assignment
            await db.query(
                'INSERT INTO brand_assignees (user_id, brand_id, brand_pk, status, created_at) VALUES (?, ?, ?, 1, ?)',
                [userId, brandId, publicKey, new Date()]
            );
        } else if (existingAssignment.status === 0) {
            // Reactivate existing assignment
            await db.query(
                'UPDATE brand_assignees SET status = 1, updated_at = ? WHERE user_id = ? AND brand_id = ?',
                [new Date(), userId, brandId]
            );
        }

        // Log the assignment
        await logBrandAssigneeAction(brandId, userId, createdBy, 1, `User with ID ${userId} assigned to brand`);
    } catch (error) {
        console.error("Error while assigning brand to user:", error);
    }
};

// Enable a brand by ID
const enableBrand = async (id) => {
  const [result] = await db.query('UPDATE brands SET status = 1 WHERE id = ?', [id]);
  return result;
};

// Disable a brand by ID
const disableBrand = async (id) => {
  const [result] = await db.query('UPDATE brands SET status = 0 WHERE id = ?', [id]);
  return result;
};

module.exports = { createBrand,editBrand,updateBrandsforAssignUsers,getAllBrandsWithCompany,fetchAllBrandsWithCompanies,getAllUsersforAssignFilter,findBrandsByCompanyAndUser, findBrandById,getAllBrandsAssignsforCompanyUsers,getAllUsersforAssignBrandCompulosryModel, getAllUsersforAssignBrand,updateUsersforAssignBrand, findAllBrandsByCompany,getAllBrandsNameByCompany, updateBrand, enableBrand, disableBrand,checkCanCreateBrand,assignBrandToUser };
