// routes/clientRoutes.js
const express = require('express');
const router = express.Router();
const ClientController = require('../controllers/ClientController');

// Route to fetch client data by chatKey
router.post('/data', ClientController.fetchClientData);
router.post('/urls', ClientController.getVisitorUrls);
router.post('/history/urls', ClientController.getUrlsByVisitorSession);
router.post('/client-status', ClientController.getClientStatus);
router.post('/client-metadata',ClientController.fetchClientMetadata);
router.post('/change-client-status', ClientController.changeClientStatus);
router.post('/ip-health',ClientController.updateIPStatus)
router.put('/visitor-tag-notes-update', ClientController.updateSessionNotesAndTags);
// history routes 
router.post('/visitor-history', ClientController.VisitorHistory);
router.post('/visitor-history-search', ClientController.SearchVisitorHistoryController);
router.post('/visitor-history-filterbydate', ClientController.FilterVisitorHistoryByDateController);
router.post('/visitor-history-filterByBrands', ClientController.filterByBrands);

module.exports = router;
