// controllers/userController.js
const { createUser, findUserByEmail,getProfile,updateProfileModel,checkEmailExists,updateProfilePassword, findUserById, findAllUsers, updateUser, updateStatus, findUsersByBrandId, findUserByCompanyId, findUserByCompId,getUsersRelatedToCompanyModel } = require('../models/userModel');
const bcrypt = require('bcryptjs');
const db = require('../config/database');
const { encryptData } = require('../middleware/EncryptDecryptData');
const multer = require('multer');
const path = require('path');
 

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'public/uploads/user_Profiles'); // Ensure this directory exists
  },
  filename: function (req, file, cb) {
     cb(null, file.originalname + Date.now() + path.extname(file.originalname)); // Use timestamp to create a unique file name
   }
});

const upload = multer({ storage: storage }).single('profile_image');

const isValidImageUrl = (url) => {
  return new Promise((resolve, reject) => {
    const parsedUrl = new URL(url);
    const options = {
      method: 'HEAD',
      hostname: parsedUrl.hostname,
      path: parsedUrl.pathname,
    };

    https.request(options, (res) => {
      const contentType = res.headers['content-type'];
      if (res.statusCode === 200 && contentType && contentType.startsWith('image/')) {
        resolve(true);
      } else {
        resolve(false);
      }
    }).on('error', (err) => {
      reject(err);
    }).end();
  });
};

const downloadImage = (url, dest) => {
  return new Promise((resolve, reject) => {
    const file = fs.createWriteStream(dest);
    https.get(url, (response) => {
      response.pipe(file);
      file.on('finish', () => {
        file.close(resolve);
      });
    }).on('error', (err) => {
      fs.unlink(dest, () => reject(err)); // Clean up on error
    });
  });
};
exports.createUser = async (req, res) => {
    try {
       
      const { name, pseudonym, email, password, designation,hrm_id, role, company_id, brand_id, status, created_by, canCreateUsers, canCreateBrand } = req.body;
      
      
      // Check if the email already exists
      const emailExists = await checkEmailExists(email);
      if (emailExists) {
        return res.status(400).json({ error: 'Email already exists' });
      }
  
      const result = await createUser(name, pseudonym, email, password,hrm_id, designation, role, company_id, brand_id, status, created_by, canCreateUsers, canCreateBrand);
      
      if (result.success) {
        res.status(201).json({ message: 'User created successfully', id: result.userId });
      } else {
        res.status(500).json({ error: 'Error creating user' });
      }
    } catch (error) {
      res.status(500).json({ error: 'Error creating user' });
    }
  };
  
exports.findUserById = async (req, res) => {
  try {
    
    const user = await findUserById(req.params.id);
    if (!user) return res.status(404).json({ message: 'User not found' });
    res.json(encryptData(user));
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving user' });
  }
};exports.updateuserStatus = async (req, res) => {
  try {
    const {user_id} = req.body;
    const user = await updateStatus(user_id);
    if (!user) return res.status(404).json({ message: 'User not found' });
    res.json(encryptData(user));
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving user' });
  }
};
  exports.getProfile = async (req, res) => {
  try {
    // const {user_id} = req.params.user_id;
    const user = await getProfile(req.params.user_id);
    if (!user) return res.status(404).json({ message: 'User not found' });
    res.json(encryptData(user));
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving user' });
  }
}; 

exports.getUsersRelatedToCompany = async (req, res) => {
  try {
    // const {user_id} = req.params.user_id;
    console.log("req.params.user_id");
    console.log(req.params.user_id);
    
    const user = await getUsersRelatedToCompanyModel(req.params.user_id);
    if (!user) return res.status(404).json({ message: 'User not found' });
    res.json(encryptData(user));
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving user' });
  }
};

exports.findUserByCompId = async (req, res) => {
  try {

    const user = await findUserByCompId(req.params.compId);
    if (!user) return res.status(404).json({ message: 'User not found' });
    res.json(encryptData(user));
  } catch (error) {
    res.status(500).json({ error: 'Error retrieving user' });
  }
};

exports.getAllUsers = async (req, res) => {
  try {
    const { role, userId, company_id } = req.user;

    let users;
    if (role == 1) {
      users = await findAllUsers();
    } else if (role == 2 || role == 3 || role == 4) {
      console.log("fetching users");
      
      users = await findUserByCompId(company_id);
      console.log("fetching users 2");
      console.log(users);
      
    } else {
      return res.status(404).json({ message: "Unauthenticated" });
    }

    res.json(encryptData(users));
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
};
// exports.getAllCompulsoryUsers = async (req, res) => {
//   try {
//     const { role, userId, company_id } = req.user;

//     let users;
//     if (role == 1) {
//       users = await findAllUsers();
//     } else if (role == 2 || role == 3 || role == 4) {
//         return res.status(404).json({ message: "Unauthenticated" });
      
//     } else {
//       return res.status(404).json({ message: "Unauthenticated" });
//     }

//     res.json(users);
//   } catch (error) {
//     res.status(500).json({ error: error.message });
//   }
// };

exports.updateUser = async (req, res) => {
  try {
    const { name, pseudonym, email, password, role, company_id, status } = req.body;
    const result = await updateUser(req.params.id, name, pseudonym, email, password, role, company_id, status);
    if (result.affectedRows === 0) return res.status(404).json({ message: 'User not found' });
    res.json({ message: 'User updated successfully' });
  } catch (error) {
    res.status(500).json({ error: 'Error updating user' });
  }
};
// exports.updateProfile = async (req, res) => {
//     try {
//       console.log(req.body); // Debugging
  
//       const { name, pseudonym, email, designation, userId } = req.body;
//       const profile_image = req.file ? req.file.filename : null; // Ensure filename is saved
  
//       console.log(name, pseudonym, email, designation, userId, profile_image);
  
//       const result = await updateProfile(name, pseudonym, email, designation, userId, profile_image);
  
//       if (result.affectedRows === 0) {
//         return res.status(404).json({ message: 'User not found' });
//       }
  
//       res.json({ message: 'User updated successfully', profile_image });
//     } catch (error) {
//       console.error(error);
//       res.status(500).json({ error: 'Error updating user' });
//     }
//   };
exports.updateProfile = async (req, res) => {
  upload(req, res, async (err) => {
      if (err) {
          return res.status(500).json({ error: 'Error uploading logo', details: err.message });
      }

      try {
     

          const { name, pseudonym, email, designation, userId, profile_type, existing_image } = req.body;
          let profile_image = req.file ? req.file.filename : existing_image; // Use uploaded file or keep the existing one

          if (!userId) {
              return res.status(400).json({ error: "User ID is required" });
          }

          // If profile_type is 'selected', only update path (don't change the image)
          if (profile_type === 'selected') {
              profile_image = existing_image;
          }

          // Update profile in the database
          const result = await updateProfileModel(name, pseudonym, email, designation, userId, profile_image);

          if (result.affectedRows === 0) {
              return res.status(404).json({ message: "User not found" });
          }
          let profile_url;
          if(profile_image){
            profile_url = `uploads/user_Profiles/${profile_image}`

          }
          const updatedUser = {name,pseudonym ,designation}
          res.json({ message: "User updated successfully",profile_image:profile_url,updatedUser});
      } catch (error) {
          console.error("Error updating profile:", error);
          res.status(500).json({ error: "Error updating user" });
      }
  });
};



exports.updateProfilePassword = async (req, res) => {
    try {
      const { currentPassword, newPassword,confirmPassword, userId } = req.body;
      
      
        if(confirmPassword !== newPassword){
            return res.status(401).json({ message: 'Passwords do not match' });
        }
      // Fetch user from the database to verify current password
      const [user] = await db.query('SELECT password FROM users WHERE id = ?', [userId]);
  
      if (user.length === 0) {
        return res.status(404).json({ message: 'User not found' });
      }
  
      // Check if the current password matches the stored password
      const isMatch = await bcrypt.compare(currentPassword, user[0].password);
      if (!isMatch) {
        return res.status(401).json({ message: 'Current password is incorrect' });
      }
  
      // Hash the new password
      const hashedPassword = newPassword ? await bcrypt.hash(newPassword, 10) : undefined;
      console.log("hashedPassword");
      console.log(hashedPassword);
      
      // Update the user's password in the database
      const result = await updateProfilePassword(hashedPassword, userId);
      if (result.affectedRows === 0) {
        return res.status(404).json({ message: 'User not found or password not updated' });
      }
  
      res.json({ message: 'Password updated successfully' });
    } catch (error) {
      res.status(500).json({ error: 'Error updating password' });
    }
  };

 

  exports.GetExistingProfileImages = async (req, res) => {
      try {
          const [rows] = await db.execute('SELECT  image_url FROM dummy_profiles');
          res.json({ images: rows });
      } catch (error) {
          console.error('Error fetching profile images:', error);
          res.status(500).json({ error: 'Error fetching profile images' });
      }
  };
  
exports.changeUserStatus = async (req, res) => {
  try {
    const { status } = req.body;
    const result = await updateStatus(req.params.id, status);
    if (result.affectedRows === 0) return res.status(404).json({ message: 'User not found' });
    res.json({ message: 'User status updated successfully' });
  } catch (error) {
    res.status(500).json({ error: 'Error updating user status' });
  }
};

exports.getUsersByBrandId = async (req, res) => {
    try {
      const brandId = req.params.brandId;
      console.log(brandId);
      
      const users = await findUsersByBrandId(brandId);
      
      if (users.length === 0) {
        return res.status(404).json({ message: 'No users found for this brand' });
      }
  
      res.json(encryptData(users));
    } catch (error) {
      console.error('Error fetching users:', error);
      res.status(500).json({ error: 'Error fetching users' });
    }
  };