const db = require('../config/database'); // Make sure to import your database connection here

exports.fetchChatNotifications = async (brand_id) => {
  try {
    console.log("brand id.. :", brand_id);

    // Query to fetch the public_key from the brands table
    const [brands] = await db.query('SELECT public_key FROM brands WHERE id = ?', [brand_id]);

    if (!brands || brands.length === 0) {
      console.log("brand not found");
      throw new Error('Brand not found');
    }

    const public_key = brands[0].public_key; // Use brands[0] to access the first element
    console.log('public_key:', public_key);

    // Query to fetch chat sessions using the public_key
    const [chatSessions] = await db.query('SELECT * FROM chat_sessions WHERE public_key = ?', [public_key]);

    return chatSessions;
  } catch (error) {
    console.error('Error fetching chat notifications:', error);
    throw error; // Rethrow the error to be handled by the controller
  }
};
