(function(global) {
    const companyId = global.$_VChat_CompanyId;
  
    const chatWidget = document.createElement('div');
    chatWidget.id = 'chat-widget';
    document.body.appendChild(chatWidget);
  
    chatWidget.innerHTML = `
      <div id="chat-header">Chat with us</div>
      <div id="chat-messages"></div>
      <input type="text" id="chat-input" placeholder="Type a message..."/>
      <button id="chat-send">Send</button>
    `;
  
    const chatMessages = document.getElementById('chat-messages');
    const chatInput = document.getElementById('chat-input');
    const chatSend = document.getElementById('chat-send');
  
    chatSend.addEventListener('click', () => {
      const message = chatInput.value.trim();
      if (message) {
        appendMessage(message, 'user');
        chatInput.value = '';
      }
    });
  
    chatInput.addEventListener('keydown', (e) => {
      if (e.key === 'Enter') {
        chatSend.click();
      }
    });
  
    function appendMessage(message, sender) {
      const messageElement = document.createElement('div');
      messageElement.className = `chat-message ${sender}`;
      messageElement.textContent = message;
      chatMessages.appendChild(messageElement);
    }
  
    async function trackUserData() {
      try {
        const response = await fetch('https://api.ipify.org?format=json');
        const data = await response.json();
        const ip = data.ip;
  
        const payload = {
          ip,
          visitedPage: window.location.href,
          userAgent: navigator.userAgent,
          companyId,
        };
  
        await fetch('http://localhost:3001/api/track', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
          },
          body: JSON.stringify(payload),
        });
      } catch (error) {
        console.error('Error tracking user data:', error);
      }
    }
  
    trackUserData();
  })(window);
  