// utils/fetchLogo.js
const axios = require('axios');
const cheerio = require('cheerio');

const getWebsiteLogo = async (url) => {
  try {
    // Fetch the HTML of the website
    const { data } = await axios.get(url);
    const $ = cheerio.load(data);

    // Find the favicon link in the <head>
    let logoUrl = $('link[rel="icon"]').attr('href');
    if (!logoUrl) {
      logoUrl = $('link[rel="shortcut icon"]').attr('href');
    }

    // If no favicon is found, look for logo images
    if (!logoUrl) {
      const logoImage = $('img').filter((i, el) => $(el).attr('alt') && $(el).attr('alt').toLowerCase().includes('logo')).first();
      if (logoImage.length) {
        logoUrl = logoImage.attr('src');
      }
    }

    // If the logo URL is relative, make it absolute
    if (logoUrl && !/^https?:\/\//i.test(logoUrl)) {
      const urlObj = new URL(url);
      logoUrl = new URL(logoUrl, `${urlObj.protocol}//${urlObj.hostname}`).href;
    }

    return logoUrl || 'No logo found';
  } catch (error) {
    console.error('Error fetching the website logo:', error.message);
    throw new Error('Error fetching the logo');
  }
};

module.exports = getWebsiteLogo;
