const express = require('express');
const router = express.Router();
const alertController = require('../controllers/alertController');
const { verifyToken } = require('../middleware/role');

// Create an alert
router.post('/alerts', verifyToken, alertController.createAlert);

// Get all active alerts
router.get('/alerts',  alertController.getActiveAlerts);

// Publish (activate) an alert
router.put('/alerts/:id/publish', verifyToken, alertController.publishAlert);

// Deactivate an alert
router.put('/alerts/:id/deactivate', verifyToken, alertController.deactivateAlert);
router.delete('/alerts/:id/delete', verifyToken, alertController.deleteAlert);
router.get('/alerts/by-category', alertController.getAlertsByCategory);

// Delete an alert
// router.delete('/alerts/:id', verifyToken, alertController.deleteAlert);
// 
module.exports = router;
