// routes/companyRoutes.js
const express = require('express');
const router = express.Router();
const companyController = require('../controllers/companyController');

router.post('/companies', companyController.createCompany);
router.get('/companies/:id', companyController.getCompanyById);
router.get('/companies', companyController.getAllCompanies);
router.put('/companies/:id', companyController.updateCompany);
router.put('/companies/:id/enable', companyController.enableCompany);
router.put('/companies/:id/disable', companyController.disableCompany);

module.exports = router;
