const multer = require('multer');
const fs = require('fs');
const path = require('path');
const { v4: uuidv4 } = require('uuid');

// Create storage engine
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    const publicKey = req.body.public_key;  // Assume public_key is being passed in the request

    // Construct the directory path based on the public_key
    const dir = path.join(__dirname, `../uploads/${publicKey}/files`);

    // Create the directory if it doesn't exist
    fs.mkdirSync(dir, { recursive: true });

    // Set the directory for the file to be saved
    cb(null, dir);
  },
  filename: function (req, file, cb) {
    // Use a unique identifier (uuid) for the file name to avoid conflicts
    const uniqueName = `${uuidv4()}-${file.originalname}`;
    cb(null, uniqueName);
  }
});

const upload = multer({ storage: storage });

// Handle the file upload in the controller
const uploadFile = (req, res) => {
  upload.single('file')(req, res, function (err) {
    if (err instanceof multer.MulterError) {
      return res.status(500).json({ error: err.message });
    } else if (err) {
      return res.status(500).json({ error: 'File upload failed.' });
    }

    // Send back the file path or URL after the upload is successful
    const filePath = `/uploads/${req.body.public_key}/files/${req.file.filename}`;
    res.status(200).json({ filePath });
  });
};

module.exports = {
  uploadFile
};
