const express = require('express');
const mysql = require('mysql2');
const router = express.Router();
const useragent = require('useragent');
const cors = require('cors');
const fs = require('fs');
const path = require('path');
const db = require('./dbConfig');
const jwt = require('jsonwebtoken');
const app = express();
app.use(cors('*'))

const hostname = 'test.vchat.ourprojectdemo.com';
const port = 3001;

// Middleware to parse JSON bodies
app.use(express.json());
// Middleware to rewrite URL and serve static files with .js extension
app.use('/static', (req, res, next) => {
    // Check if the requested file exists with a .js extension
    const filePath = path.join(__dirname, 'public', req.url + '.js');
    if (fs.existsSync(filePath)) {
        req.url += '.js';
    }
    next();
});
// Serve static files from the 'public' directory
app.use('/static', express.static(path.join(__dirname, 'public')));

// Serve static files from the "public" directory
app.use('/static', express.static(path.join(__dirname, 'public')));
// Create a connection to the MySQL database
// const db = mysql.createConnection({
//   host: 'localhost',
//   user: 'vchat_vchat',
//   password:'kE*t*D){vG*d',
//   port:3306,
//   database: 'vchat_vchat'
//   });

  
// Route to generate the script tag dynamically
// const generateScript = require('./routes/generateScript');
// app.use('/api/script', generateScript);
// Generate and serve the widget script

//generate widget 
// Use the widget routes
const widgetRoutes = require('./routes/widget')
const statusRoutes = require('./routes/statusRoutes')
const visitorLogs = require('./routes/logRoutes');

app.use('/api', widgetRoutes);
app.use('/api', visitorLogs);

// Secret key for JWT
const JWT_SECRET = 'vnotchatweseresomethinggoodchatbotnotcomingslow';
app.use('/', statusRoutes);
// Endpoint to generate a token
app.post('/api/token', (req, res) => {
  const { clientId, public_key} = req.body;
  console.log("client id", clientId);
  
  if (!clientId) {
      return res.status(400).json({ error: 'Client ID is required' });
  }

  // Generate token (expires in 7 days)
  const token = jwt.sign({ clientId,public_key }, JWT_SECRET, { expiresIn: '7d' });

  res.json({ token });
});
 
 
 // Middleware to handle non-existent routes and return custom error page
 app.use((req, res, next) => {
    res.status(400).sendFile(path.join(__dirname, 'error.html'));
  });
  
  // Error handling middleware
  app.use((err, req, res, next) => {
    console.error(err.stack);
    res.status(500).send('Something went wrong. Please try again later.');
  });
// Start the server
 
// Start the server using HTTP, not HTTPS
const server = require('http').createServer(app);

app.listen(port, () => console.log(`Server running on port ${port}`));
