
const db = require('../config/database'); // Assuming you have a MySQL connection setup

const ClientModel = {

    async updateSessionNotesAndTags(sessionId, notes, tags) {
        const query = `
          UPDATE chat_sessions 
          SET notes = ?, tags = ?
          WHERE session_id = ?
        `;
    
        try {
          const [result] = await db.execute(query, [notes, JSON.stringify(tags), sessionId]);
          return result;
        } catch (error) {
        console.error("Error updating session notes and tags:", error);
        }
      },
    
// Check if client or IP is already blacklisted
async checkBlacklistStatus(type, value) {
    console.log("type :",type);
    console.log("value: ",value);
    
    const query = 'SELECT COUNT(*) AS count FROM blacklists WHERE type = ? AND value = ?';
    const [result] = await db.query(query, [type, value]);
    return result[0].count > 0; // Returns true if blacklisted, false otherwise
},


// Add client or IP to blacklist
async  addToBlacklist(type, value) {
    const query = 'INSERT INTO blacklists (type, value, created_at) VALUES (?, ?, NOW())';
    const [result] = await db.query(query, [type, value]);
    return result;
},

// Remove client or IP from blacklist
async  removeFromBlacklist(type, value) {
    const query = 'DELETE FROM blacklists WHERE type = ? AND value = ?';
    const [result] = await db.query(query, [type, value]);
    return result;
},

// Create log entry for blocking/unblocking
async  createLog(blockValue, pseudonym, message) {
    const query = 'INSERT INTO client_status_logs (client_id, ip, pseudonym, message) VALUES (?, ?, ?, ?)';
    const [result] = await db.query(query, [blockValue, blockValue, pseudonym, message]);
    return result;
},


// Method to update client status (block/unblock)
async updateClientStatus(clientId, status) {
    const query = `
      UPDATE clients
      SET status = ?
      WHERE client_id = ?
    `;
    const [result] = await db.query(query, [status, clientId]);
    return result;
  },

  // Method to log the action (block/unblock)
  async createLog(blockValue, pseudonym, type, message) {
    const query = `
      INSERT INTO client_status_logs (type, value, pseudonym, message, created_at)
      VALUES (?, ?, ?, ?, NOW())
    `;
    
    try {
        const [result] = await db.query(query, [type, blockValue, pseudonym, message]);
        return result;
    } catch (error) {
        console.error('Error creating log entry:', error);
        throw error;
    }
},

    //  to fetch the last entry of a visitor session by client_id
async getLastVisitorStatus (client_id){
    try {
      const [rows] = await db.query(
        `SELECT * FROM visitor_session 
         WHERE client_id = ? 
         ORDER BY join_time DESC 
         LIMIT 1`, 
        [client_id]
      );
      return rows[0]; // Return the most recent session (if found)
    } catch (error) {
      console.error('Error fetching last visitor status:', error);
      throw error;
    }
  },
  // Check if a client or IP is blacklisted
async  checkBlacklistStatus(type, value) {
    const query = 'SELECT COUNT(*) AS count FROM blacklists WHERE type = ? AND value = ?';
    const [result] = await db.query(query, [type, value]);
    return result[0].count > 0; // Returns true if blacklisted, false otherwise
},

// Get client data by chatKey
 
// Get visitor data by clientId
async getVisitorByClientId(clientId) {
    const query = 'SELECT ip FROM visitors WHERE client_id = ? ORDER BY created_at DESC LIMIT 1';
    const [result] = await db.query(query, [clientId]);
    return result[0]; // Returns the most recent visitor entry for the client
},


  // Fetch client data by chatKey
  async getClientDataByChatKey(chatKey) {
    try {
      // First, try to fetch the active chat session
      const activeSessionQuery = `
        SELECT c.name,c.client_id, c.email, c.phone, cs.notes, cs.tags 
        FROM client c
        JOIN chat_sessions cs ON c.client_id = cs.client_id
        WHERE cs.chat_key = ? AND cs.is_active = 1
      `;
      const [activeRows] = await db.query(activeSessionQuery, [chatKey]);
  
      // If an active session is found, return the data
      if (activeRows.length > 0) {
        return activeRows[0];
      }
  
      // If no active session found, fetch the last session data
      console.log('No active session found. Fetching the last session.');
      const lastSessionQuery = `
        SELECT c.name,c.client_id, c.email, c.phone, cs.notes, cs.tags 
        FROM client c
        JOIN chat_sessions cs ON c.client_id = cs.client_id
        WHERE cs.chat_key = ?
        ORDER BY cs.created_at DESC
        LIMIT 1
      `;
      const [lastRows] = await db.query(lastSessionQuery, [chatKey]);
  
      // Return the last session data or null if none is found
      return lastRows.length > 0 ? lastRows[0] : null;
  
    } catch (error) {
      console.error('Error in getClientDataByChatKey:', error);
      throw error;
    }
  },
  

  // Fetch join_time from visitor_session where client_id matches and status != 4
  async getVisitorSession(client_id) {
    try {
      // Query to find active session (status != 4)
      let query = `
        SELECT join_time 
        FROM visitor_session 
        WHERE client_id = ? AND status != 4
        ORDER BY join_time DESC
        LIMIT 1
      `;
      
      // Fetch the active session
      const [results] = await db.query(query, [client_id]);
  
      // If no active session found, fetch from the last session (status can be any)
      if (results.length === 0) {
        query = `
          SELECT join_time
          FROM visitor_session
          WHERE client_id = ?
          ORDER BY join_time DESC
          LIMIT 1
        `;
        const [lastSessionResults] = await db.query(query, [client_id]);
  
        // Return the last session if found, otherwise null
        return lastSessionResults.length > 0 ? lastSessionResults[0] : null;
      }
  
      // Return the active session
      return results[0];
    } catch (error) {
      console.error('Error in getVisitorSession:', error);
      throw error;
    }
  },
  

  // Fetch URLs from visitor table where visit time is after the join_time
async getVisitorUrlsAfterJoinTime(client_id, visitor_id) {
    console.log("visitor url.... ");
    console.log(visitor_id);
    
    try {
        const query = `
        SELECT url 
        FROM visitors 
        WHERE  v_session_id = ?
        ORDER BY created_at ASC
      `;

        const [results] = await db.query(query, [visitor_id]);
        return results;
    } catch (error) {
        console.error('Error in getVisitorUrlsAfterJoinTime:', error);
        throw error;
    }
},
 
async getUrlsByVisitorSession(visitor_session_id, client_id) {
  try {
    console.log("fetching urls for history...");
    console.log('client id', client_id);
    console.log('session id ', visitor_session_id);
    
    const query = `
      SELECT v.url 
      FROM visitors v
      WHERE v.v_session_id = ? AND v.client_id = ?
      ORDER BY v.created_at DESC
       
    `;

    const [results] = await db.query(query, [visitor_session_id, client_id]);
    return results;
  } catch (error) {
    console.error('Error in getUrlsByVisitorSession:', error);
    throw error;
  }
},
  
  

// async getVisitorMetadata(clientId) {
//     try {
//         // Fetch join_time and ip_health from the active visitor_session
//         const [visitorSessionRows] = await db.query(`
//           SELECT 
//             DATE_SUB(join_time, INTERVAL 5 SECOND) AS join_time,
//             ip_health
//           FROM visitor_session 
//           WHERE client_id = ? AND status != 4
//         `, [clientId]);
    
//         let join_time, left_time, ip_health;
    
//         // If no active visitor session is found, fetch the last session's join_time, left_time, and ip_health
//         if (visitorSessionRows.length === 0) {
//           console.log("No active visitor session found. Fetching the last session.");
    
//           const [lastSessionRows] = await db.query(`
//             SELECT 
//               DATE_SUB(join_time, INTERVAL 5 SECOND) AS join_time, 
//               left_time,
//               ip_health
//             FROM visitor_session 
//             WHERE client_id = ?
//             ORDER BY join_time DESC
//             LIMIT 1
//           `, [clientId]);
    
//           if (lastSessionRows.length === 0) {
//             throw new Error("No visitor session found, even the last session.");
//           }
    
//           // Assign join_time, left_time, and ip_health from the last session
//           join_time = lastSessionRows[0].join_time;
//           left_time = lastSessionRows[0].left_time;
//           ip_health = lastSessionRows[0].ip_health;
    
//           console.log("join_time of last session: ", join_time);
//           console.log("left_time of last session: ", left_time);
//           console.log("ip_health of last session: ", ip_health);
//         } else {
//           // Assign join_time and ip_health from the active session
//           join_time = visitorSessionRows[0].join_time;
//           left_time = null; // No left_time in an active session
//           ip_health = visitorSessionRows[0].ip_health;
    
//           console.log("join_time of active session: ", join_time);
//           console.log("ip_health of active session: ", ip_health);
//         }
    
//         // Fetch additional metadata from visitors table
//         const [visitorMetadataRows] = await db.query(`
//           SELECT 
//             os, 
//             ip, 
//             country, 
//             browser, 
//             city, 
//             created_at 
//           FROM visitors 
//           WHERE client_id = ? 
//             AND created_at >= ? 
//           ORDER BY created_at ASC 
//           LIMIT 1
//         `, [clientId, join_time]);
    
//         if (visitorMetadataRows.length === 0) {
//           throw new Error("No metadata found for the provided client_id and join_time.");
//         }
    
//         const metadata = visitorMetadataRows[0];
//         return {
//           ...metadata,
//           join_time,
//           left_time, // Include the left_time if it was fetched
//           ip_health, // Include the ip_health status
//         };
//       } catch (error) {
//         throw new Error(`Error fetching visitor metadata: ${error.message}`);
//       }
//   },
   // Method to update IP health in visitor_session table
   async updateIPHealth(visitorSessionId, ipHealth) {
    const query = 'UPDATE visitor_session SET ip_health = ? WHERE id = ?';
    await db.execute(query, [ipHealth, visitorSessionId]);
  },
  
  async getVisitorMetadata(clientId, visitor_id) {
    try {
        console.log("Fetching visitor metadata...");

        // Fetch visitor details
        const [visitorData] = await db.query(`
            SELECT 
                os, 
                ip, 
                country, 
                browser, 
                city, 
                created_at, 
                 
                v_session_id 
            FROM visitors 
            WHERE v_session_id = ?
            LIMIT 1
        `, [visitor_id]);

        if (visitorData.length === 0) {
            throw new Error("No visitor found for the provided visitor_id.");
        }

        const { v_session_id, ...metadata } = visitorData[0];

        // Fetch join_time from visitor_session table
        const [sessionData] = await db.query(`
            SELECT DATE_SUB(join_time, INTERVAL 2 SECOND) AS join_time ,ip_health
            FROM visitor_session
            WHERE id = ?
            LIMIT 1
        `, [v_session_id]);

        if (sessionData.length === 0) {
            throw new Error("No session found for the provided visitor_id.");
        }

        return {
            ...metadata,
            join_time: sessionData[0].join_time,
            ip_health:sessionData[0].ip_health
        };
    } catch (error) {
        throw new Error(`Error fetching visitor metadata: ${error.message}`);
    }
},


async getTotalVisitorSessions(clientId) {
  try {
    const [rows] = await db.query(`
      SELECT COUNT(*) AS total_sessions
      FROM visitor_session 
      WHERE client_id = ? 
    `, [clientId]);

    return rows[0].total_sessions || 0;
  } catch (error) {
    throw new Error("Error fetching total visitor sessions: " + error.message);
  }
},

async getTotalChatSessions(clientId) {
  try {
    const [rows] = await db.query(`
      SELECT COUNT(*) AS total_sessions
      FROM chat_sessions 
      WHERE client_id = ? 
    `, [clientId]);

    return rows[0].total_sessions || 0;
  } catch (error) {
    throw new Error("Error fetching total chat sessions: " + error.message);
  }
},
async getClientData(user_id, page, limit) {
    try {
      // Calculate offset for pagination
      const offset = (page - 1) * limit;
        console.log("page:",page)
        console.log("limit:",limit)
      // First query: Fetch paginated session data with message count
      const sessionQuery = `
       WITH AssignedBrands AS (
        SELECT b.public_key, b.name AS brand_name
        FROM brand_assignees ba
        JOIN brands b ON ba.brand_id = b.id
        WHERE ba.user_id = ? and ba.status = 1
      )
      SELECT 
        c.client_id,
        c.name AS client_name,
        cs.served_by,
        cs.session_id AS chat_session_id,
        vs.id AS visitor_session_id,
        ab.brand_name,
        ab.public_key,
        vs.landing_url,
        vs.IP_Health,
        vs.join_time,
        vs.left_time,
        COALESCE(cm.message_count, 0) AS message_count
      FROM 
        visitor_session vs
      LEFT JOIN chat_sessions cs ON vs.chat_session_id = cs.session_id
      LEFT JOIN (
        SELECT session_id, COUNT(*) AS message_count
        FROM chat_messages
        WHERE type != 'comment'
        GROUP BY session_id
      ) cm ON cs.session_id = cm.session_id
      INNER JOIN client c ON vs.client_id = c.client_id
      INNER JOIN AssignedBrands ab ON ab.public_key = vs.public_key
      WHERE 
        vs.status = 4
      ORDER BY 
        vs.left_time DESC
      LIMIT ? OFFSET ?;
      `;
  
      // Fetch paginated session data
      const [sessionRows] = await db.query(sessionQuery, [user_id, parseInt(limit, 10), offset]);
  
      // Extract visitor_session_ids from the session rows
      const visitorSessionIds = sessionRows.map(row => row.visitor_session_id);
  
      if (visitorSessionIds.length === 0) {
        // If no session data, return early with no results
        return { rows: [], totalRecords: 0 };
      }
  
      // Second query: Fetch visitor data for the relevant visitor_session_ids
      const visitorQuery = `
        SELECT 
          v.v_session_id,
          v.created_at,
          v.ip,
          v.country,
          v.browser,
          v.os
        FROM visitors v
        WHERE v.v_session_id IN (?)
        GROUP BY v.v_session_id
        ORDER BY v.created_at DESC;
      `;
  
      // Fetch all visitor data at once
      const [visitorRows] = await db.query(visitorQuery, [visitorSessionIds]);
  
      // Create a map of visitor session data
      const visitorDataMap = visitorRows.reduce((acc, visitor) => {
        acc[visitor.v_session_id] = visitor;
        return acc;
      }, {});
  
      // Merge visitor data into session rows
      const rows = sessionRows.map(session => ({
        ...session,
        ip: visitorDataMap[session.visitor_session_id]?.ip || null,
        country: visitorDataMap[session.visitor_session_id]?.country || null,
        browser: visitorDataMap[session.visitor_session_id]?.browser || null,
        os: visitorDataMap[session.visitor_session_id]?.os || null,
      }));
  
      // Fetch the total count of records
      const countQuery = `
        WITH AssignedBrands AS (
          SELECT b.public_key
          FROM brand_assignees ba
          JOIN brands b ON ba.brand_id = b.id
          WHERE ba.user_id = ? and ba.status = 1
        )
        SELECT COUNT(DISTINCT vs.id) AS totalRecords
        FROM visitor_session vs
        INNER JOIN AssignedBrands ab 
          ON ab.public_key = vs.public_key
        WHERE vs.status = 4;
      `;
      
      const [[{ totalRecords }]] = await db.query(countQuery, [user_id]);
  
      // Return total records and merged data
      return { rows, totalRecords };
    } catch (err) {
      console.error('Error fetching client data:', err);
      throw new Error('Failed to fetch client data');
    }
  },
  
// async  SearchVisitorHistory(searchTerm, user_id) {
//     try {
//       const sessionQuery = `
//       WITH AssignedBrands AS (
//         SELECT b.public_key, b.name AS brand_name
//         FROM brand_assignees ba
//         JOIN brands b ON ba.brand_id = b.id
//         WHERE ba.user_id = ?
//       )
//       SELECT 
//         c.client_id,
//         c.name AS client_name,
//         c.email,
//         c.phone,
//         cs.served_by,
//         cs.session_id AS chat_session_id, 
//         vs.id AS visitor_session_id,
//         ab.brand_name,
//         ab.public_key,
//         vs.landing_url,
//         vs.IP_Health,
//         vs.join_time,
//         vs.left_time,
//         v.created_at,
//         v.ip,
//         v.country,
//         v.browser,
//         v.os,
//         COUNT(*) OVER() AS total_records
//       FROM 
//         visitor_session vs
//       LEFT JOIN chat_sessions cs ON vs.chat_session_id = cs.session_id
//       INNER JOIN client c ON vs.client_id = c.client_id
//       INNER JOIN AssignedBrands ab ON ab.public_key = vs.public_key
//       LEFT JOIN chat_messages cm ON cm.session_id = cs.session_id
//       LEFT JOIN visitors v ON v.v_session_id = vs.id
//       WHERE 
//         vs.status = 4
//         AND (
//           c.name LIKE CONCAT('%', ?, '%')
//           OR c.email LIKE CONCAT('%', ?, '%')
//           OR c.phone LIKE CONCAT('%', ?, '%')
//           OR cs.served_by LIKE CONCAT('%', ?, '%')
//           OR cs.tags LIKE CONCAT('%', ?, '%')
//           OR cs.notes LIKE CONCAT('%', ?, '%')
//           OR ab.brand_name LIKE CONCAT('%', ?, '%')
//           OR vs.landing_url LIKE CONCAT('%', ?, '%')
//           OR cm.message LIKE CONCAT('%', ?, '%')
//           OR v.ip LIKE CONCAT('%', ?, '%')
//           OR v.country LIKE CONCAT('%', ?, '%')
//           OR v.browser LIKE CONCAT('%', ?, '%')
//           OR vs.client_id LIKE CONCAT('%', ?, '%')
//           OR v.os LIKE CONCAT('%', ?, '%')
//         )
//       GROUP BY vs.id
//       ORDER BY vs.left_time DESC
//       `;
  
//       const [sessionRows] = await db.query(sessionQuery, [
//         user_id,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//         searchTerm,
//       ]);
  
//       const totalRecords = sessionRows.length > 0 ? sessionRows[0].total_records : 0;
  
//       return { sessionRows, totalRecords };
//     } catch (err) {
//       console.error('Error fetching client data:', err);
//       throw new Error('Failed to fetch client data');
//     }
//   },
async  SearchVisitorHistory(
    searchTerm,
    user_id,
    includeName,
    includeEmail,
    includeClientId,
    brandIds,
    includeMsg,
    servedStatus = "all",
    connectedStatus = "all",
    currentPage = 1,
    itemsPerPage = 50
  ) {
    try {
      if(!includeClientId && !includeEmail && !includeMsg && !includeName || brandIds.length ==0){
        return { sessionRows: [], totalRecords: 0 };
      }
       
      let queryConditions = [];
      let queryParams = [user_id];
      console.log("page..",currentPage)
      console.log("limit...",itemsPerPage)
      // Handle brandIds conditionally
      const assignedBrandsCondition =
        brandIds && brandIds.length > 0
          ? `AND ba.brand_id IN (${brandIds.map(() => "?").join(", ")})`
          : "";
  
      if (brandIds && brandIds.length > 0) {
        queryParams.push(...brandIds);
      }
  
      // Served status condition
      let servedCondition = "";
      if (servedStatus === "not_served") {
        servedCondition = "(cs.served_by IS NULL OR cs.served_by = '')";
      } else if (servedStatus === "served") {
        servedCondition = "(cs.served_by IS NOT NULL AND cs.served_by != '')";
      }
  
      // Connected status condition
      let connectedCondition = "";
      if (connectedStatus === "connected") {
        connectedCondition =
          "EXISTS (SELECT 1 FROM chat_participants cp WHERE cp.session_id = cs.session_id AND cp.role = 'client')";
      } else if (connectedStatus === "not_connected") {
        connectedCondition =
          "NOT EXISTS (SELECT 1 FROM chat_participants cp WHERE cp.session_id = cs.session_id AND cp.role = 'client')";
      }
  
      if (servedCondition && connectedCondition) {
        queryConditions.push(`(${servedCondition} AND ${connectedCondition})`);
      } else if (servedCondition) {
        queryConditions.push(servedCondition);
      } else if (connectedCondition) {
        queryConditions.push(connectedCondition);
      }
  console.log(includeClientId);
  console.log(includeEmail);
  console.log(includeName);
  console.log(includeMsg);
  
      // Search term conditions
      if (searchTerm) {
        let searchConditions = [];
        if (includeName) {
          searchConditions.push("c.name LIKE CONCAT('%', ?, '%')");
          queryParams.push(searchTerm);
        }
        if (includeEmail) {
          searchConditions.push("c.email LIKE CONCAT('%', ?, '%')");
          queryParams.push(searchTerm);
        }
        if (includeClientId) {
          searchConditions.push("vs.client_id LIKE CONCAT('%', ?, '%')");
          queryParams.push(searchTerm);
        }
        if (includeMsg) {
          searchConditions.push("cm.messages LIKE CONCAT('%', ?, '%')");
          queryParams.push(searchTerm);
        }
  
        if (searchConditions.length > 0) {
          queryConditions.push(`(${searchConditions.join(" OR ")})`);
        }
      }
  
      const queryConditionsString =
        queryConditions.length > 0 ? `AND (${queryConditions.join(" AND ")})` : "";
      const offset = (currentPage - 1) * itemsPerPage;
  
      const sessionQuery = `
        WITH AssignedBrands AS (
          SELECT b.public_key, b.name AS brand_name
          FROM brand_assignees ba
          JOIN brands b ON ba.brand_id = b.id
          WHERE ba.user_id = ? AND ba.status = 1
          ${assignedBrandsCondition}
        )
        SELECT 
          c.client_id,
          c.name AS client_name,
          c.email,
          c.phone,
          cs.served_by,
          cs.session_id AS chat_session_id, 
          vs.id AS visitor_session_id,
          ab.brand_name,
          ab.public_key,
          vs.landing_url,
          vs.IP_Health,
          vs.join_time,
          vs.left_time,
          v.created_at,
          v.ip,
          v.country,
          v.browser,
          v.os,
          cm.message_count,
          COUNT(*) OVER() AS total_records
        FROM 
          visitor_session vs
        LEFT JOIN chat_sessions cs ON vs.chat_session_id = cs.session_id
        INNER JOIN client c ON vs.client_id = c.client_id
        INNER JOIN AssignedBrands ab ON ab.public_key = vs.public_key
        LEFT JOIN (
          SELECT 
            session_id, 
            COUNT(*) AS message_count, 
            GROUP_CONCAT(message) AS messages
          FROM chat_messages
          WHERE type != 'comment'
          GROUP BY session_id
        ) cm ON cs.session_id = cm.session_id
        LEFT JOIN visitors v ON v.v_session_id = vs.id
        WHERE 
          vs.status = 4
          ${queryConditionsString}
        GROUP BY vs.id
        ORDER BY vs.left_time DESC
        LIMIT ? OFFSET ?;
      `;
  
      queryParams.push(itemsPerPage, offset);
      console.log(queryParams)
      console.log(queryConditionsString)
      const [sessionRows] = await db.query(sessionQuery, queryParams);
      const totalRecords = sessionRows.length > 0 ? sessionRows[0].total_records : 0;
  
      return { sessionRows, totalRecords };
    } catch (err) {
      console.error("Error fetching client data:", err);
      throw new Error("Failed to fetch client data");
    }
  },
  
  




  async FilterVisitorHistoryByDate(user_id, start_date, end_date) {
    try {
      // SQL query to filter by date range (join_time) and include message count
      const dateFilterQuery = `
        WITH AssignedBrands AS (
          SELECT b.public_key, b.name AS brand_name
          FROM brand_assignees ba
          JOIN brands b ON ba.brand_id = b.id
          WHERE ba.user_id = ? AND ba.status = 1
        )
        SELECT 
          c.client_id,
          c.name AS client_name,
          c.email,
          c.phone,
          cs.served_by,
          cs.session_id AS chat_session_id, 
          vs.id AS visitor_session_id,
          ab.brand_name,
          ab.public_key,
          vs.landing_url,
          vs.IP_Health,
          vs.join_time,
          vs.left_time,
          v.created_at,
          v.ip,
          v.country,
          v.browser,
          v.os,
          cm.message_count,
          COUNT(*) OVER() AS total_records
        FROM 
          visitor_session vs
        LEFT JOIN chat_sessions cs ON vs.chat_session_id = cs.session_id
        INNER JOIN client c ON vs.client_id = c.client_id
        INNER JOIN AssignedBrands ab ON ab.public_key = vs.public_key
        LEFT JOIN (
          SELECT session_id, COUNT(*) AS message_count
          FROM chat_messages
          WHERE type != 'comment'
          GROUP BY session_id
        ) cm ON cs.session_id = cm.session_id
        LEFT JOIN visitors v ON v.v_session_id = vs.id
        WHERE 
          vs.status = 4
          AND (
            vs.left_time BETWEEN ? AND ?  -- Date range filter
          )
        GROUP BY vs.id
        ORDER BY vs.left_time DESC
      `;
  
      // Execute the query with user_id, start_date, and end_date
      const [sessionRows] = await db.query(dateFilterQuery, [user_id, start_date, end_date]);
  
      const totalRecords = sessionRows.length > 0 ? sessionRows[0].total_records : 0;
  
      console.log(sessionRows[0]); // Log first result (optional)
  
      return { sessionRows, totalRecords };
    } catch (err) {
      console.error('Error fetching visitor history by date:', err);
      throw new Error('Failed to fetch visitor history by date');
    }
  },
  
  async filterByBrands(user_id, brandIds) {
    try {
      const placeholders = brandIds.map(() => '?').join(', ');
      const query = `
        WITH AssignedBrands AS (
          SELECT b.public_key, b.name AS brand_name
          FROM brand_assignees ba
          JOIN brands b ON ba.brand_id = b.id
          WHERE ba.user_id = ? and ba.status = 1
        )
        SELECT 
          c.client_id,
          c.name AS client_name,
          c.email,
          c.phone,
          cs.served_by,
          cs.session_id AS chat_session_id, 
          vs.id AS visitor_session_id,
          ab.brand_name,
          ab.public_key,
          vs.landing_url,
          vs.IP_Health,
          vs.join_time,
          vs.left_time,
          v.created_at,
          v.ip,
          v.country,
          v.browser,
          v.os,
          COUNT(*) OVER() AS total_records
        FROM 
          visitor_session vs
        LEFT JOIN chat_sessions cs ON vs.chat_session_id = cs.session_id
        INNER JOIN client c ON vs.client_id = c.client_id
        INNER JOIN AssignedBrands ab ON ab.public_key = vs.public_key
        LEFT JOIN chat_messages cm ON cm.session_id = cs.session_id
        LEFT JOIN visitors v ON v.v_session_id = vs.id
        WHERE 
          vs.status = 4
          AND ab.brand_id IN (${placeholders})
        GROUP BY vs.id
        ORDER BY vs.left_time DESC
      `;
      const [results] = await db.query(query, [user_id, ...brandIds]);
      return results;
    } catch (error) {
      console.error('Error filtering by brands:', error);
      throw new Error('Failed to filter by brands');
    }
  }


  

 

};

module.exports = ClientModel;
