const db = require('../config/database'); // Your database connection

// Function to get user tones by user_id
const getUserTones = async (user_id) => {
  const [rows] = await db.query('SELECT * FROM user_tones WHERE user_id = ?', [user_id]);
  return rows[0]; // Return the first row (user tones)
};

// Function to update or insert user tones by user_id
const updateUserTones = async (user_id, new_visitor_tone, message_tone) => {
  // Check if the user already exists in the user_tones table
  const [existingTones] = await db.query('SELECT 1 FROM user_tones WHERE user_id = ?', [user_id]);

  if (existingTones.length > 0) {
    // If user exists, update the tones
    await db.query(
      'UPDATE user_tones SET new_visitor_tone = ?, message_tone = ? WHERE user_id = ?',
      [new_visitor_tone, message_tone, user_id]
    );
  } else {
    // If user does not exist, insert new tones
    await db.query(
      'INSERT INTO user_tones (user_id, new_visitor_tone, message_tone) VALUES (?, ?, ?)',
      [user_id, new_visitor_tone, message_tone]
    );
  }
};

module.exports = {
  getUserTones,
  updateUserTones
};
