// // controllers/userShortcutsController.js
// const UserShortcuts = require('../models/userShortcutsModel');

// const UserShortcutsController = {
//   getShortcuts: async (req, res) => {
//     const { userId } = req.params;
//     try {
//       const shortcuts = await UserShortcuts.getShortcutsByUserId(userId);
//       res.status(200).json({ success: true, shortcuts });
//     } catch (error) {
//       res.status(500).json({ success: false, message: error.message });
//     }
//   },

//   addShortcuts: async (req, res) => {
//     const { userId } = req.params;
//     const { shortcuts } = req.body; // Expecting an array of shortcuts
//     if (!shortcuts || !Array.isArray(shortcuts)) {
//       return res.status(400).json({ success: false, message: 'Shortcuts must be an array' });
//     }

//     try {
//       const shortcutId = await UserShortcuts.addShortcuts(userId, shortcuts);
//       res.status(201).json({ success: true, shortcutId, message: 'Shortcuts added successfully' });
//     } catch (error) {
//       res.status(500).json({ success: false, message: error.message });
//     }
//   },

//   deleteShortcut: async (req, res) => {
//     const { userId } = req.params;
//     const { shortcut } = req.body; // Expecting { "shortcut": "Your shortcut text" }
//     if (!shortcut) {
//       return res.status(400).json({ success: false, message: 'Shortcut text is required' });
//     }

//     try {
//       const success = await UserShortcuts.deleteShortcut(userId, shortcut);
//       if (success) {
//         res.status(200).json({ success: true, message: 'Shortcut deleted successfully' });
//       } else {
//         res.status(404).json({ success: false, message: 'Shortcut not found' });
//       }
//     } catch (error) {
//       res.status(500).json({ success: false, message: error.message });
//     }
//   },
// };

// module.exports = UserShortcutsController;
// const UserShortcuts = require('../models/userShortcutsModel');

// const UserShortcutsController = {
//   getShortcuts: async (req, res) => {
//     const { companyId } = req.params;
//     try {
//       const shortcuts = await UserShortcuts.getShortcutsByCompanyId(companyId);
//       res.status(200).json({ success: true, shortcuts });
//     } catch (error) {
//       res.status(500).json({ success: false, message: error.message });
//     }
//   },

//   addShortcuts: async (req, res) => {
//     const { userId, companyId } = req.params;
//     const { shortcuts, createdBy } = req.body;
//     if (!shortcuts || !Array.isArray(shortcuts)) {
//       return res.status(400).json({ success: false, message: 'Shortcuts must be an array' });
//     }

//     try {
//       const shortcutId = await UserShortcuts.addShortcuts(userId, companyId, shortcuts, createdBy);
//       res.status(201).json({ success: true, shortcutId, message: 'Shortcuts added successfully' });
//     } catch (error) {
//       res.status(500).json({ success: false, message: error.message });
//     }
//   },

//   updateShortcut: async (req, res) => {
//     const { shortcutId } = req.params;
//     const { newShortcut, updatedBy } = req.body;
//     if (!newShortcut) {
//       return res.status(400).json({ success: false, message: 'New shortcut text is required' });
//     }

//     try {
//       const success = await UserShortcuts.updateShortcut(shortcutId, newShortcut, updatedBy);
//       if (success) {
//         res.status(200).json({ success: true, message: 'Shortcut updated successfully' });
//       } else {
//         res.status(404).json({ success: false, message: 'Shortcut not found' });
//       }
//     } catch (error) {
//       res.status(500).json({ success: false, message: error.message });
//     }
//   },

//   deleteShortcut: async (req, res) => {
//     const { shortcutId } = req.params;
//     const { deletedBy } = req.body;
//     if (!shortcutId) {
//       return res.status(400).json({ success: false, message: 'Shortcut ID is required' });
//     }

//     try {
//       const success = await UserShortcuts.deleteShortcut(shortcutId, deletedBy);
//       if (success) {
//         res.status(200).json({ success: true, message: 'Shortcut deleted successfully' });
//       } else {
//         res.status(404).json({ success: false, message: 'Shortcut not found' });
//       }
//     } catch (error) {
//       res.status(500).json({ success: false, message: error.message });
//     }
//   },
// };

// module.exports = UserShortcutsController;
const UserShortcuts = require('../models/userShortcutsModel');

const UserShortcutsController = {
    // ✅ Get all shortcuts (Public, Private, Hidden)
    getShortcuts: async (req, res) => {
        const { companyId } = req.params;
        const userId = req.query.userId;
        if (!userId) return res.status(400).json({ success: false, message: 'User ID is required' });

        try {
            const { publicShortcuts, privateShortcuts, hiddenShortcuts } = await UserShortcuts.getShortcutsByCompanyId(companyId, userId);
            res.status(200).json({ success: true, publicShortcuts, privateShortcuts, hiddenShortcuts });
        } catch (error) {
            res.status(500).json({ success: false, message: error.message });
        }
    },

    // ✅ Create a new shortcut
    createShortcut: async (req, res) => {
        const { companyId, userId, shortcutName, shortcutType } = req.body;

        if (!companyId || !userId || !shortcutName || shortcutType === undefined) 
            return res.status(400).json({ success: false, message: 'All fields are required' });

        try {
            const shortcutId = await UserShortcuts.createShortcut(companyId, userId, shortcutName, shortcutType);
            res.status(201).json({ success: true, message: 'Shortcut created', shortcutId });
        } catch (error) {
            res.status(500).json({ success: false, message: error.message });
        }
    },

    // ✅ Update a shortcut
    updateShortcut: async (req, res) => {
        const { shortcutId, updatedBy, shortcutName, shortcutType } = req.body;

        if (!shortcutId || !updatedBy || !shortcutName || shortcutType === undefined) 
            return res.status(400).json({ success: false, message: 'All fields are required' });

        try {
            const updated = await UserShortcuts.updateShortcut(shortcutId, updatedBy, shortcutName, shortcutType);
            if (!updated) return res.status(400).json({ success: false, message: 'Shortcut not updated' });

            res.status(200).json({ success: true, message: 'Shortcut updated' });
        } catch (error) {
            res.status(500).json({ success: false, message: error.message });
        }
    },

    // ✅ Delete a shortcut
    deleteShortcut: async (req, res) => {
        const { shortcutId } = req.body;

        if (!shortcutId) return res.status(400).json({ success: false, message: 'Shortcut ID is required' });

        try {
            const deleted = await UserShortcuts.deleteShortcut(shortcutId);
            if (!deleted) return res.status(400).json({ success: false, message: 'Shortcut not deleted' });

            res.status(200).json({ success: true, message: 'Shortcut deleted' });
        } catch (error) {
            res.status(500).json({ success: false, message: error.message });
        }
    },

    // ✅ Hide shortcut
    hideShortcut: async (req, res) => {
        const { userId, shortcutId } = req.body;
        if (!userId || !shortcutId) return res.status(400).json({ success: false, message: 'User ID and Shortcut ID are required' });

        try {
            const hidden = await UserShortcuts.hideShortcut(userId, shortcutId);
            res.status(200).json({ success: true, message: 'Shortcut hidden' });
        } catch (error) {
            res.status(500).json({ success: false, message: error.message });
        }
    },

    // ✅ Unhide shortcut
    unhideShortcut: async (req, res) => {
        const { userId, shortcutId } = req.body;
        if (!userId || !shortcutId) return res.status(400).json({ success: false, message: 'User ID and Shortcut ID are required' });

        try {
            const unhidden = await UserShortcuts.unhideShortcut(userId, shortcutId);
            res.status(200).json({ success: true, message: 'Shortcut unhidden' });
        } catch (error) {
            res.status(500).json({ success: false, message: error.message });
        }
    }
};

module.exports = UserShortcutsController;
