module.exports = (widgetId, brandId, userInfo) => {
    return `
        document.addEventListener('DOMContentLoaded', function() {
            const chatWidget = document.createElement('div');
            chatWidget.id = 'chat-widget-${widgetId}';
            chatWidget.setAttribute('data-brand-id', '${brandId}');
            chatWidget.style.position = 'fixed';
            chatWidget.style.bottom = '20px';
            chatWidget.style.right = '20px';
            chatWidget.style.width = '300px';
            chatWidget.style.height = '400px';
            chatWidget.style.border = '1px solid #ccc';
            chatWidget.style.backgroundColor = '#f9f9f9';
            chatWidget.innerHTML = \`
                <h3>Chat Widget for Brand ${brandId}</h3>
                <div id="chat-content" style="height: 80%; overflow-y: auto;"></div>
                <input type="text" id="chat-input" placeholder="Type a message..." style="width: 100%; box-sizing: border-box; padding: 10px;" />
                <button id="send-button" style="width: 100%; padding: 10px; background-color: #007bff; color: #fff; border: none; cursor: pointer;">Send</button>
            \`;

            document.body.appendChild(chatWidget);

            const sendButton = document.getElementById('send-button');
            const chatInput = document.getElementById('chat-input');
            const chatContent = document.getElementById('chat-content');

            const userInfo = ${JSON.stringify(userInfo)};

            sendButton.addEventListener('click', function() {
                const message = chatInput.value;
                if (message.trim() !== '') {
                    chatInput.value = '';
                    // Display the message in the chat content
                    const userMessageDiv = document.createElement('div');
                    userMessageDiv.style.padding = '10px';
                    userMessageDiv.style.margin = '5px 0';
                    userMessageDiv.style.backgroundColor = '#e0e0e0';
                    userMessageDiv.style.textAlign = 'right';
                    userMessageDiv.textContent = message;
                    chatContent.appendChild(userMessageDiv);
                    chatContent.scrollTop = chatContent.scrollHeight;

                    // Send the message to the server
                    fetch('http://backend.vchat.ourprojectdemo.com:3001/api/message/${widgetId}/${brandId}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({ message, userInfo })
                    }).then(response => response.json()).then(data => {
                        // Display the response from the server
                        const botMessageDiv = document.createElement('div');
                        botMessageDiv.style.padding = '10px';
                        botMessageDiv.style.margin = '5px 0';
                        botMessageDiv.style.backgroundColor = '#007bff';
                        botMessageDiv.style.color = '#fff';
                        botMessageDiv.style.textAlign = 'left';
                        botMessageDiv.textContent = data.reply;
                        chatContent.appendChild(botMessageDiv);
                        chatContent.scrollTop = chatContent.scrollHeight;
                    }).catch(error => {
                        console.error('Error:', error);
                    });
                }
            });
        });
    `;
};
