import React from 'react';
import styles from './BlurryTable.module.css';

const BlurryTable = () => {
  const data = [
    { clientId: '43d1989a-ce2b-4b49-aede-1e69ee87c80e', name: 'Hasnain real', servedBy: 'Vurkflow', meta: '', brand: 'Vurkflow', landingPage: 'https://vurkflow.com/', ip: '', visitDuration: '0h 4m 47s', ipHealth: 'Good' },
    // ... Add more data here
  ];

  return (
    <div className={styles.container}>
      <table className={styles.table}>
        <thead>
          <tr>
            <th className={styles.headerCell}>Client ID</th>
            <th className={styles.headerCell}>Name</th>
            <th className={styles.headerCell}>Served By</th>
            <th className={styles.headerCell}>Meta</th>
            <th className={styles.headerCell}>Brand</th>
            <th className={styles.headerCell}>Landing Page</th>
            <th className={styles.headerCell}>IP</th>
            <th className={styles.headerCell}>Visit Duration</th>
            <th className={styles.headerCell}>IP Health</th>
          </tr>
        </thead>
        <tbody>
          {data.map((item, index) => (
            <tr key={index}>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>{item.clientId}</td>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>{item.name}</td>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>{item.servedBy}</td>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>{item.meta}</td>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>{item.brand}</td>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>
                <a href={item.landingPage}>{item.landingPage}</a>
              </td>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>{item.ip}</td>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>{item.visitDuration}</td>
              <td className={`${styles.dataCell} ${styles.blurryText}`}>{item.ipHealth}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
};

export default BlurryTable;
