import { useEffect, useState } from 'react';
import axios from 'axios';

const VisitorManualIp = ({ visitorSessionId, ipHealth, updateIpHealth }) => {
  const [isGoodIP, setIsGoodIP] = useState(ipHealth === 1);
 
useEffect(() => {
 
  
  setIsGoodIP(ipHealth == 1)
}, [ipHealth])


  // const toggleIPStatus = async () => {
  //   try {
  //     const newStatus = isGoodIP ? 0 : 1;

  //     const response = await axios-post(`${process.env.NEXT_PUBLIC_API_URL}/api/client/ip-health`, {
  //       visitor_session_id: visitorSessionId,
  //       ip_health: newStatus,
  //     });

  //     if (response.data.success) {
  //       setIsGoodIP(!isGoodIP);

  //       // Call updateIpHealth if it's provided as a prop
  //       updateIpHealth?.(visitorSessionId, newStatus);
  //     }
  //   } catch (error) {
  //     console.error("Failed to update IP status:", error);
  //   }
  // };
  const toggleIPStatus = async () => {
    try {
      const newStatus = isGoodIP ? 0 : 1;
  
      const response = await apiRequest('/api/client/ip-health', 'POST', {
        visitor_session_id: visitorSessionId,
        ip_health: newStatus,
      });
  
      if (response.success) {
        setIsGoodIP(!isGoodIP);
  
        // Call updateIpHealth if it's provided as a prop
        updateIpHealth?.(visitorSessionId, newStatus);
      }
    } catch (error) {
      console.error("Failed to update IP status:", error.message);
    }
  };
  return (
    <div
      className={`visitor-ip-stats `}
    >
      <span  className={`  ${isGoodIP ? 'good-ip' : 'bad-ip'}`}>{isGoodIP ? 'Good IP' : 'Bad IP'}</span>
      <button className="toggle-button" onClick={toggleIPStatus}>
        {isGoodIP ? 'Mark as Bad IP' : 'Mark as Good IP'}
      </button>
    </div>
  );
};

export default VisitorManualIp;
