import React, { useState, useEffect, useRef, useCallback } from 'react';
import { FaArrowAltCircleRight } from 'react-icons/fa';
import { getSocket } from '@/app/lib/socketManager';
import { useDispatch, useSelector } from 'react-redux';
import { closeTab, minimize } from '../lib/features/chat/chatSlice';
import { MdBlock, MdCheckCircle } from 'react-icons/md';
import VisitorIpStats from './VisitorIPstatus';
import VisitorManualIp from './VisitorManualIp';
import { FaMinus } from "react-icons/fa";
import { IoCloseSharp, IoReload } from "react-icons/io5";
import apiRequest from '../lib/InterceptorAxios/axios';
import { decryptData } from '../utils/DecryptData';
import handleLogout from '../utils/handlelogout';



const VisitorMeta = ({ clientId, publicKey ,currentChat ,visitorRef,fetchChatHistory,user  }) => {
  
 
  const socket = getSocket();
  const [VisitedUrl, setVisitedUrl] = useState([])
  const [showToast, setShowToast] = useState(false);
  const [MetadataV, setMetadataV]=useState()
  const { tabs, activeTab } = useSelector((state) => state.chat);
  
  const [isIpBlocked, setisIpBlocked] = useState(false)
  const [isClientBlocked, setisClientBlocked] = useState()
  const dispatch = useDispatch();
  const toastInterval = useRef(null);
  const intervalRef = useRef(null);
    const [activeTabContent, setactiveTabContent] = useState(tabs.find((tab) => tab.client_id === activeTab) )
//   const joinTime = originalJoinTimes[clientId]; // Fetch original join time by clientId
  const [visitorData, setVisitorData] = useState({
    name: '',
    email: '',
    phone: '',
    notes: '',
    tags: [],
    tagInput: '', // To track the input while typing tags
  });
  // const [elapsedTime, setElapsedTime] = useState('0 mins');
  const elapsedTimeRef = useRef('0 mins'); // useRef instead of useState
  const elapsedTimeElementRef = useRef(null); // to update DOM without re-render
   
     // Memoized updateElapsedTime to avoid re-renders due to function redeclaration
 
     const updateElapsedTime = useCallback((MetadataV) => {
      let endTime = MetadataV?.left_time ? new Date(MetadataV.left_time) : new Date();
      const joinTime = MetadataV?.join_time ? new Date(MetadataV.join_time) : null;
    
      
      if (joinTime) {
        const diff = endTime - joinTime;
        const secondsElapsed = Math.floor(diff / 1000);
        const minutesElapsed = Math.floor(secondsElapsed / 60);
        const hoursElapsed = Math.floor(minutesElapsed / 60);
        const displayMinutes = minutesElapsed % 60;
        const displaySeconds = secondsElapsed % 60;
        const totalMinutes = Math.floor(secondsElapsed / 60);
  
        let timeString = '';
        if (totalMinutes > 0) {
          timeString = `${totalMinutes} min`;
        } else {
          timeString = `${secondsElapsed} sec`;
        }
  
        // Update elapsedTimeRef instead of setting state
        elapsedTimeRef.current = timeString;
   
        
        // Manually update the DOM element to avoid re-render
        if (elapsedTimeElementRef.current) {
          elapsedTimeElementRef.current.textContent = timeString;
        }
      }
    }, []);
  
    const startInterval = useCallback(
      (MetadataV) => {
      
        
        if (intervalRef.current) {
          clearInterval(intervalRef.current);
        }
  
        if (!MetadataV?.left_time) {
          intervalRef.current = setInterval(() => {
            updateElapsedTime(MetadataV);
          }, 1000);
        } else {
          updateElapsedTime(MetadataV);
        }
      },
      [updateElapsedTime]
    );
    useEffect(() => {
      const handleBeforeUnload = (event) => {
        handleCloseTab(activeTab); // Call your function
       
        // event.preventDefault();
        // This line is necessary for some browsers to show the confirmation dialog
        // event.returnValue = "";
      };
      
      // Add event listener
      window.addEventListener("beforeunload", handleBeforeUnload);
  
      // Cleanup event listener on component unmount
      return () => {
        window.removeEventListener("beforeunload", handleBeforeUnload);
      };
    }, [activeTab]);
  
    useEffect(() => {
     
      return () => {
        if (intervalRef.current) {
          clearInterval(intervalRef.current);
        }
      };
    }, []);

 
 // Function to check and trim URL
 function checkAndTrimUrl(url) {
  // Remove 'http://', 'https://', or 'www.' from the beginning of the URL
  const trimmedUrl = url.replace(/^https?:\/\/|^www\./, '');

  // If the URL length exceeds 32 characters, trim and append '...'
  if (trimmedUrl.length > 32) {
    return trimmedUrl.substring(0, 32) + '...';
  }

  return trimmedUrl;
}
const copyVisitorId = (client_id, event) => {
  
};
function handleCopyAndOpen(url) {
  setShowToast(true);
  // event.stopPropagation(); // Prevent the click from bubbling up to the row
  navigator.clipboard.writeText(url)
    .then(() => {
      // Clear any existing interval to reset the timer
      if (toastInterval.current) {
        clearInterval(toastInterval.current);
      }

      // Set a new interval to hide the toast after 3 seconds
      toastInterval.current = setInterval(() => {
        setShowToast(false);
        clearInterval(toastInterval.current); // Clear interval after hiding toast
      }, 2000);
    })
    .catch(err => console.error('Failed to copy text: ', err));
}
    // Fetch client data and handle socket events
    useEffect(() => {
      const fetchClientData = async () => {
        try {
         const data =await  apiRequest('/api/client/data','POST',{
            chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`
          })
     
          const { name, email, phone, notes, tags } = data.client;
          setisClientBlocked(data.isClientBlocked)
          setisIpBlocked(data.isIpBlocked)
          setVisitorData({
            name: name || '',
            email: email || '',
            phone: phone || '',
            notes: notes || '',
            tags: tags || [],
            tagInput: '',
          });
          
          
        } catch (error) {
          console.error('Error fetching client data:', error);
        }
      };
  
      if (currentChat) {
        fetchClientData(); // Call the function to fetch data
      }
    }, [currentChat]);
  
    // Handle socket events (only once)
    useEffect(() => {
      const handleUrlUpdate = (encryptedData) => {
        const data = decryptData(encryptedData)
        
        
        
        
        if(currentChat.client_id == data.clientId){
     
        setVisitedUrl((prevVisitedUrl) => [
          data.url,
          ...prevVisitedUrl,
        ]);
           
      }
      };

  


      const handleClientDataUpdate = (encryptedData) => {
        const data = decryptData(encryptedData)
        const { client_id, name, email, phone, notes, tags } = data;
                let currentClient;
                if (visitorRef.current) {
          const classList = visitorRef.current.className.split(" ");
                    currentClient = classList[1];
        }
                                        // Ensure client_id matches currentChat.client_id before updating
        if (client_id != currentClient) {
                    return;
        }
      
        
      
        // Update visitor data based on the presence of tags
        setVisitorData((prevData) => ({
          ...prevData,
          name,
          email,
          phone,
          notes,
          tags: tags || prevData.tags || [], // Preserve existing tags if not provided
        }));
      };
      
  
      socket.on('visitor url update', handleUrlUpdate);
      socket.on('client data updated', handleClientDataUpdate);
  
      // Clean up socket listeners on unmount
      return () => {
        socket.off('visitor url update', handleUrlUpdate);
        socket.off('client data updated', handleClientDataUpdate);
      };
    }, [socket]);
    const fetchVisitedUrls = async () => {
      try {
        
        
        
        
        const data =await apiRequest(`/api/client/urls`,"POST",{
          visitor_id : currentChat?.visitor_session_id,
          client_id:clientId,
        }  )
        
       
         
        const extractedUrls = data.urls.map((item) => item.url);
        setVisitedUrl(extractedUrls);
      } catch (error) {
        console.error('Error fetching visited URLs:', error.message);
      }
    };
     const fetchVisitorMetada = async () => {
      try {
        
        
        
        const data = await  apiRequest(`/api/client/client-metadata`,'POST',{
          visitor_id : currentChat?.visitor_session_id,
          client_id:clientId,
        } )
       
        setMetadataV(data)
        startInterval(data);
        
        return data
      } catch (error) {
        console.error('Error fetching visitor metadata:', error);
      }
    };
    // Fetch visited URLs when the component mounts or `clientId` changes
    useEffect(() => {
        let interval;
  
      if (currentChat?.visitor_session_id) {
        fetchVisitedUrls();
 fetchVisitorMetada().then((metadata)=>{
    
    
    
    if(!metadata?.left_time){
        
        interval = setInterval(updateElapsedTime, 1000);
    
    }
})
 


      }
    }, [clientId]);
  
  const handleInputChange = (e) => {
    const { id, value } = e.target;
    setVisitorData((prevData) => ({
      ...prevData,
      [id]: value,
    }));
  };

  const handleTagInputChange = (e) => {
    const { value } = e.target;
    // If the input contains a comma or space, add the tag
    if ( value.endsWith(', ') ||  e.key === 'Enter') {
      const newTag = value.trim().replace(',', '');
      if (newTag && !visitorData.tags.includes(newTag)) {
        setVisitorData((prevData) => ({
          ...prevData,
          tags: [...prevData.tags, newTag],
          tagInput: '',
        }));
      } else {
        setVisitorData((prevData) => ({
          ...prevData,
          tagInput: '',
        }));
      }
    } else {
      setVisitorData((prevData) => ({
        ...prevData,
        tagInput: value,
      }));
    }
  };
// Handle key press for Enter
const handleTagKeyPress = (e) => {
  if (e.key === 'Enter') {
    e.preventDefault(); // Prevent default form submission or action when pressing Enter
    handleTagInputChange(e); // Call the input change handler on Enter
  }
};
const removeTag = (indexToRemove) => {
  setVisitorData((prevData) => {
    const updatedTags = prevData.tags.filter((_, index) => index !== indexToRemove);
    
    // Update the tags in state
    const updatedData = {
      ...prevData,
      tags: updatedTags,
    };
    
    // Emit the updated data using the same event
    socket.emit('update client data', {
      client_id: clientId,
      public_key: publicKey,
      ...updatedData,
    });

    return updatedData; // Update the state with filtered tags
  });
};

const handleReloadChat=()=>{
 
  socket.emit('join chat',{
    client_id:clientId,
    public_key:publicKey,
    realName: user.pseudonym,
    userId: user.userId,
    visitor_session_id:activeTabContent.visitor_session_id
  })
  fetchChatHistory();
}
const handleUpdateVisitorData = useCallback(() => {
  const updatedData = {
    ...visitorData,
    tags: visitorData.tags, 
  };

  
  socket.emit('update client data', {
    client_id: clientId,
    public_key: publicKey,
    ...updatedData,
  });

  
}, [visitorData, clientId, publicKey]);
const handleCloseTab = (client_id) => {

  dispatch(closeTab({ client_id }));
};
  const handleMinimizeTab = (client_id) => {
    if (intervalRef.current) {
      clearInterval(intervalRef.current);
    }
    dispatch(minimize({ client_id }));
    socket.emit("stop typing admin", {
      chatKey: `${publicKey}_${clientId}`,
      from: user?.pseudonym,
    });
    socket.emit('admin_closed_chat',{
      client_id: clientId,
      public_key: publicKey,
      pseudonym: user.pseudonym,
      user_id: user.userId

    })
  };
  const handleCloseChat = ()=>{
 
    // setHideColumns(false)
    // setCurrentChat(null)
  }

  return (
    <>
      {showToast && (
          <div className="toast show alert-success  " role="alert" aria-live="assertive" aria-atomic="true">
           
            <div className="alert alert-success alert-on-chat copy-visitor-url  " role='alert'>Copied to clipboard</div>
          </div>
        )}
   
    <div className="visitor-box-right">
      <div className='minimize-chatbox-sidebar'  onClick={() => handleMinimizeTab(activeTab)}><FaMinus size={12} />
    
      </div> <div className='closed-chatbox-sidebar'   onClick={() => handleCloseTab(activeTab)}> 
   
      <IoCloseSharp  size={14} color='white' />

             
      </div>
      { 
      }
      <div className="client-details-box chat-visitor-item-3">
        <div className="input-group">
          <input
            type="text"
            id="name"
            className="visitor-name-input form-control"
            placeholder="Add Name"
            value={visitorData.name}
            onChange={handleInputChange}
            onBlur={handleUpdateVisitorData}
          />
        </div>
        <div className="input-group">
          <input
            type="email"
            id="email"
            className="visitor-email-input form-control"
            placeholder="Add Email"
            value={visitorData.email}
            onChange={handleInputChange}
            onBlur={handleUpdateVisitorData}
          />
        </div>
        <div className="input-group">
          <input
            type="tel"
            id="phone"
            className="visitor-phone-input form-control"
            placeholder="Add Phone Number"
            value={visitorData.phone}
            onChange={handleInputChange}
            onBlur={handleUpdateVisitorData}
          />
        </div>
        <div className="input-group">
          <textarea
            id="notes"
            className="visitor-notes-textarea form-control"
            rows="3"
            placeholder="Add Visitor Notes"
            value={visitorData.notes}
            onChange={handleInputChange}
            onBlur={handleUpdateVisitorData}
          ></textarea>
        </div>

        {/* Tag Input Section */}
        <div className="input-group d-flex flex-column">
          <label htmlFor="tags" style={{ fontSize: '13px' }}>Tags:</label>
          <div className="tags-input-container">
          <div className={`tags-box-container ${visitorData.tags.length ? 'active' : ''}`}>
            {visitorData.tags.map((tag, index) => (

              <div className="tag-item "  key={index}>
                <span className="tag-text">{tag}</span>
                <span className="tag-remove" onClick={() => removeTag(index)}>
                  &times;
                </span>
              </div>
            ))}
            </div>
            <input
              type="text"
              id="tagInput"
              className="visitor-tags-input form-control w-100"
              placeholder="Add Tags (comma + space or enter to create)"
              value={visitorData.tagInput}
              onChange={handleTagInputChange}
              onBlur={handleUpdateVisitorData}
              onKeyPress={handleTagKeyPress}
            />
          </div>
        </div>
      </div>
 {/* Client Visit Stats Box */}
 <div className="client-visit-stats-box chat-visitor-item-4">
        <div className="client-stats-head">
          <div className="past-visits-stats chat-stats">
            <p>{MetadataV?.total_visitor_sessions}</p>
            <span>Past Visits</span>
          </div>
          <div className="past-chats-stats chat-stats">
            <p>{MetadataV?.total_chat_sessions}</p>
            <span>Past Chats</span>
          </div>
       
          <div className="past-timing-stats chat-stats">
          <p ref={elapsedTimeElementRef}>{elapsedTimeRef.current}</p>
          <span>Duration</span>
        </div>
      </div>
        <div className="visitor-path mt-3" style={{ background: '#fff' }}>
          <h4 style={{ fontSize: '17px', fontWeight: 'bold' }}>Visitor Path</h4>
          <div className="visitor-path-list">
          <ul>
          {VisitedUrl?.slice().reverse().map((url, index) => (
  <li key={index}>
    <FaArrowAltCircleRight className="me-2" style={{ color: '#72BE9E' }} />
    <a 
      href={url} 
      target='_blank' 
      className='visitor-url-chat' 
      onClick={(e) => {
        e.preventDefault();
        handleCopyAndOpen(url);
      }}
      title={url} // Tooltip showing the complete URL
    >
      {checkAndTrimUrl(url)} {/* Display the trimmed URL */}
    </a>
  </li>
))}

    </ul>
          </div>
        </div>
        <div className="visitor-details-ip">
          <div className="visitor-ip-stats" >
          <button className='toggle-button mb-3 pointer text-center w-100 btn-danger btn bg-danger  text-white' onClick={handleReloadChat}><IoReload  size={14}/>
 <span style={{fontSize:'10px', cursor:'pointer'}}> Refresh chat </span>        </button>
          <VisitorManualIp visitorSessionId={currentChat?.visitor_session_id} ipHealth={MetadataV?.ip_health}/>
          </div>
        <VisitorIpStats isClientBlocked={isClientBlocked} isIpBlocked={isIpBlocked} clientId={clientId} ip={MetadataV?.ip} pseudonym ={user.pseudonym} socket={socket} public_key={publicKey}/>
          <div className="visitor-location visitor-extra-stats">
            <span>Location: </span>
            <p>
  {MetadataV?.country}
  {MetadataV?.city && MetadataV.city !== 'Unknown' ? `, ${MetadataV.city}` : ''}
</p>

          </div> 
          <div className="visitor-location visitor-extra-stats">
            <span>IP: </span>
            <p>{MetadataV?.ip} </p>
          </div>
          <div className="visitor-browser visitor-extra-stats">
            <span>Browser: </span>
            <p>{MetadataV?.browser}</p>
          </div>
          <div className="visitor-os visitor-extra-stats">
            <span>OS: </span>
            <p>{MetadataV?.os}</p>
          </div>
        </div>
      </div>

      {/* Visitor History Box */}
      <div className="visitor-history-box chat-visitor-item-5">
        {/* Add Visitor History content */}
      </div>
      {/* Remaining UI Components */}
    </div>
    </>
  );
};

export default VisitorMeta;
