import React, { useEffect, useState } from 'react';
import axios from 'axios';
import { getCookie } from 'cookies-next';
import { useRouter } from 'next/navigation';
import apiRequest from '@/app/lib/InterceptorAxios/axios';
import { useSelector } from 'react-redux';
import { decryptData } from '@/app/utils/DecryptData';

const AssignBrandModal = ({ userId, companyid, onClose, role }) => {
  const [brands, setBrands] = useState([]);
  const user = useSelector((state) => state.user.userInfo);
  const [UserId, setUserId] = useState(user.userId);
  const [loading, setLoading] = useState(true);
  const [selectAll, setSelectAll] = useState(false); // State for "Select All" checkbox
  const [showAllBrands, setShowAllBrands] = useState(false); // State to toggle between showing all brands or just company brands
  const router = useRouter();   

  useEffect(() => {
    const token = getCookie('token');

    if (!token) {
      router.push('/login');
    } else {
      // const verifyUserRole = async () => {
      //   try {
      //     const response = await axios-post(
      //       `${process.env.NEXT_PUBLIC_API_URL}/api/auth/user-verify-role`,
      //       {},
      //       {
      //         headers: {
      //           Authorization: `Bearer ${token}`,
      //         },
      //       }
      //     );

      //     const { success, userId } = response.data;
      //     setUserId(userId);
      //   } catch (error) {
      //     console.error('Error verifying user role:', error);
      //     router.push('/login');
      //   }
      // };
      // const verifyUserRole = async () => {
      //   try {
      //     const { success, userId } = await apiRequest('/api/auth/user-verify-role', 'POST');
      //     setUserId(userId);
      //   } catch (error) {
      //     console.error('Error verifying user role:', error);
      //     router.push('/login');
      //   }
      // };
      
      // verifyUserRole();
    }
  }, [router]);

  useEffect(() => {
    if (!userId || !companyid) {
      console.warn('User ID or Company ID is missing.');
      return;
    }
  
    const fetchData = async () => {
      try {
        const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/brands/brands-assign`);
        url.searchParams.append('userId', userId);
        url.searchParams.append('company_id', companyid);
  
        const token = getCookie('token');
        if (!token) {
          console.warn('No authentication token found.');
          return;
        }
  
        const response = await axios.get(url.toString(),{
          headers: {
            Authorization: `Bearer ${token}`,
          },
        }).then((response)=>{
          
          
          setLoading(false);
  const d=           decryptData(response.data)
          setBrands(d)
        })
  
        if (!response) {
          throw new Error('No response received from API');
        }
  
        setBrands(response);
      } catch (error) {
        console.error('Error fetching data:', error);
      }
    };
  
    fetchData();
  }, [userId, companyid]);
  

  const handleBrandChange = (event) => {
    const { value, checked } = event.target;
    setBrands(prevBrands =>
      prevBrands.map(brand =>
        brand.brand_id === Number(value) ? { ...brand, assigned: checked ? 1 : 0 } : brand
      )
    );
  };

  const handleSelectAll = () => {
    setSelectAll(prev => {
      const newSelectAll = !prev;
      setBrands(prevBrands =>
        prevBrands.map(brand => 
          filteredBrands.some(filteredBrand => filteredBrand.brand_id === brand.brand_id) 
            ? { ...brand, assigned: newSelectAll ? 1 : 0 } 
            : brand
        )
      );
      return newSelectAll;
    });
  };

  // const handleSubmit = async () => {
  //   const dataToSend = {
  //     userId: userId,
  //     company_id: companyid,
  //     brands: brands,
  //     createdBy: UserId,
  //   };

  //   try {
  //     const response = await axios-put(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/brands/update-brand-assign`, dataToSend);
  //     onClose(); // Close modal after successful assignment
  //   } catch (error) {
  //     console.error('Error updating assignments:', error);
  //   }
  // };
  const handleSubmit = async () => {
    const dataToSend = {
      userId: userId,
      company_id: companyid,
      brands: brands,
      createdBy: UserId,
    };
  
    try {
      await apiRequest('/api/companies/brands/update-brand-assign', 'PUT', dataToSend);
      onClose(); // Close modal after successful assignment
    } catch (error) {
      console.error('Error updating assignments:', error);
    }
  };
  
  let  filteredBrands;
  // Filter brands by the same company
  if (role == 1){

     filteredBrands = showAllBrands ? brands : brands.filter(brand => brand.company_id === companyid);
  }
  else{
    filteredBrands = brands;
  }

  return (
    <div className="modal-overlay-comp">
      <div className="modal-brand w-50">
        <div className="modal-header-comp">
          <h5 className="modal-title mb-2">Assign Brands</h5>
          {role === 1 && (
            <button className="btn btn-sm btn-info mb-2" onClick={() => setShowAllBrands(!showAllBrands)}>
              {showAllBrands ? 'Show Company Brands' : 'Show All Brands'}
            </button>
          )}
          {brands && brands.length > 0 && (
            <button className="btn btn-sm btn-primary mb-2 btn-info" onClick={handleSelectAll}>
              {selectAll ? 'Deselect All' : 'Select All'}
            </button>
          )}
        </div>
        <div className="modal-body assign-brand-modal-body">
          {brands && brands.length > 0 ? (
            <table className="table table-bordered">
              <thead>
                <tr>
                  <th>Select</th>
                  <th>Brand</th>
                  {role === 1 && <th>Company</th>}
                </tr>
              </thead>
              <tbody>
                {filteredBrands.map((brand) => (
                  <tr key={brand.brand_id}>
                    <td>
                      <input
                        className="form-check-input"
                        type="checkbox"
                        value={brand.brand_id}
                        checked={brand.assigned === 1}
                        onChange={handleBrandChange}
                        id={`brand-${brand.brand_id}`}
                      />
                    </td>
                    <td>
                      {role === 1 ? (
                        <>
                          {brand.company_name && (
                            <span className="company-name">{brand.company_name} - </span>
                          )}
                          {brand.brand_name}
                        </>
                      ) : (
                        brand.brand_name
                      )}
                    </td>
                    {role === 1 && <td>{brand.company_name}</td>}
                  </tr>
                ))}
              </tbody>
            </table>
          ) : (
            <p>Brands not found</p>
          )}

        </div>
          <div className="w-100 d-flex justify-content-between align-items-center mt-3">
            {brands && brands.length > 0 && (
              <button className="btn submit-btn p-btn w-50" onClick={handleSubmit}>
                Assign
              </button>
            )}
            <button className="btn submit-btn p-btn w-50" onClick={onClose}>
              Cancel
            </button>
          </div>
      </div>
    </div>
  );
};

export default AssignBrandModal;
