"use client";
import React, { useEffect, useState } from "react";
import Sidebar from "@/app/Components/Home/Sidebar";
import Header from "@/app/Components/Home/Header";
import Link from "next/link";
import { useParams } from "next/navigation";
import axios from "axios";
import Image from "next/image";
import timezones from "@/public/assets/timezone/timezone.json";
import { getCookie } from "cookies-next";
import { useRouter } from "next/navigation";
import {  useSelector } from "react-redux";
import swal from 'sweetalert';
import apiRequest from "@/app/lib/InterceptorAxios/axios";
import { decryptData } from "@/app/utils/DecryptData";
import LoadingSkeletonTable from "../loading";
const BrandsPage = () => {
  const [brands, setBrands] = useState([]);
  const [loading, setLoading] = useState(true);
  const [brandsName, setBrandsName] = useState();
  const [error, setError] = useState(null);
  const [UserData, setUserData] = useState();
  const [companyid, setCompanyid] = useState();
  const router = useRouter();
  const user = useSelector((state) => state.user.userInfo);
  const [showBrandModal, setShowBrandModal] = useState(false); // Brand modal visibility state
  const [showUserModal, setShowUserModal] = useState(false); // User modal visibility state
  const fallbackImageUrl = "@public/assets/images/dp.png";
  const token = getCookie("token");
 
  const [logoOption, setLogoOption] = useState('upload')
  
  
  const [brandFormData, setBrandFormData] = useState({
    name: "",
    url: "",
    domainName: "",
    phone: "",
    email: "",
    timeZone: "",
    logoUrl:'',
    logo: null,
    statusId: 1,
  });
  const [userFormData, setUserFormData] = useState({
   
    name: "",
    pseudonym: "",
    email: "",
    password: "",
    status: 1,
    role: 2,
    designation:'',
    canCreateUsers: 0,
    canCreateBrand: 0,
      hrm_id:''
  });

  

  useEffect(() => {
    const fetchBrands = async () => {
      try {
        const response = await apiRequest(
          `/api/companies/${user.company_id}/brands`,
          'GET'
        );
     
        
        setBrands(response  || []);
        setLoading(false);
      } catch (error) {
        console.error("Error fetching brands:", error.message);
        setError("Failed to fetch brands");
        setLoading(false);
      }
    };
    
    if (user.company_id) {
      fetchBrands();
    }
  }, []);


  useEffect(() => {
    // const fetchUserInfo = async () => {
    //   try {
    //     const response = await axios-get(
    //       `${process.env.NEXT_PUBLIC_API_URL}/api/users/${user.userId}`,
    //       {
    //         headers: {
    //           Authorization: `Bearer ${token}`,
    //         },
    //       }
    //     );
        
    //     setUserData(response.data);
    //     // Handle the response data as needed
    //   } catch (error) {
    //     console.error("Error fetching user information:", error);
    //     // Handle the error as needed
    //   }
    // };
    const fetchUserInfo = async () => {
      try {
        const userData = await apiRequest(`/api/users/${user.userId}`);
        setUserData(userData);
      } catch (error) {
        console.error('Error fetching user information:', error);
      }
    };
    
    if (user.userId) {
      fetchUserInfo();
    }
  }, [user.userId, token]);

  const handleBrandInputChange = (e) => {
    const { name, value } = e.target;
    setBrandFormData({
      ...brandFormData,
      [name]: value,
    });
  };

  const handleUserInputChange = (e) => {
    const { name, value } = e.target;

    setUserFormData({
      ...userFormData,
      [name]: name === "brand_id" ? parseInt(value, 10) : value, // Convert brandid to integer
    });
    
  };

  const handleBrandFileChange = (e) => {
    setBrandFormData({
      ...brandFormData,
      logo: e.target.files[0],
    });
  };

  const handleBrandSubmit = async (e) => {
    e.preventDefault();
  
    if (user.userId) {
      const formDataWithFile = new FormData();
      formDataWithFile.append('name', brandFormData.name);
      formDataWithFile.append('url', brandFormData.url);
      formDataWithFile.append('domainName', brandFormData.domainName);
      formDataWithFile.append('phone', brandFormData.phone);
      formDataWithFile.append('email', brandFormData.email);
      formDataWithFile.append('timeZone', brandFormData.timeZone);
      formDataWithFile.append('logo', brandFormData.logo);
      formDataWithFile.append('logoUrl', brandFormData.logoUrl);
      formDataWithFile.append('company_id', user.company_id);
      formDataWithFile.append('status', brandFormData.statusId);
      formDataWithFile.append('created_by', user.userId);
       
      try {
        await axios.post(`${process.env.NEXT_PUBLIC_API_URL}/api/brands`, formDataWithFile, {
          headers: {
            'Content-Type': 'multipart/form-data',
            Authorization: `Bearer ${token}`,
          },
        });
    
        swal("Success!", "Brand has been created successfully!", "success");
  
        setShowBrandModal(false);
        setBrandFormData({
          name: '',
          url: '',
          domainName: '',
          phone: '',
          email: '',
          timeZone: '',
          logo: null,
          statusId: 1,
          logoUrl: ''
        });
      }
        catch{
          console.error('Error creating brand:', error);
          if(error.response.status === 401){
                   // Show SweetAlert for "Email already exists" error
        swal("Oops!", "Something went wrong, please reload page and try again..", "error");
          }
          swal("Error", `Error creating brand: ${error.response ? error.response.data.error : error.message}`, "error");
        }
        try{
          
    const response =   await  apiRequest(`/api/companies/${companyid}/brands`)
          
          
        setBrands(response  || []);
      } catch (error) {
       if(error.response.status === 401){
        swal("Oops!", "Something went wrong, please reload page and try again..", "error");
       }
       else{
         console.error('Error creating brand:', error);

       }
      }
    } else {
      console.error("User is missing");
    }
  };
  const handleUserSubmit = async (e) => {
    e.preventDefault();
  
    if (user.userId) {
      try {
        const created_by = user.userId;
        const company_id = user.company_id;
        const updatedUserFormData = { ...userFormData, created_by, company_id };
        
        await axios.post(`${process.env.NEXT_PUBLIC_API_URL}/api/users`, updatedUserFormData, {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        });
  
        setShowUserModal(false);
        setUserFormData({
          name: "",
          pseudonym: "",
          email: "",
          password: "",
          status: 1,
          role: 2,
          designation:'',
          canCreateUsers: 0,
          canCreateBrand: 0,
            hrm_id:''
        })
      // Show success alert if user is created successfully
      swal("Success!", "User created successfully.", "success");
        // Refresh user list after adding (if necessary)
      } catch (error) {
        if (error.response && error.response.status === 400 && error.response.data.error === 'Email already exists') {
          // Handle email already exists error
          console.error("Email already exists. Please use a different email.");
          // alert("Email already exists. Please use a different email.");
        // Show SweetAlert for "Email already exists" error
        swal("Oops!", "Email already exists. Please use a different email.", "error");
        }
        else if(error.response.status === 401){
            // Show SweetAlert for "Email already exists" error
        swal("Oops!", "Something went wrong please reload page and try again..", "error");
        }
        else {
          console.error("Error creating user:", error);
        }
      }
    } else {
      console.error("User not found");
    }
  };
  

  const handleViewClick = (brand) => {
    // Ensure path is properly defined and is a string
    const path = `/brands/${brand.id}`;

    if (typeof path === 'string' && path.startsWith('/')) {
      sessionStorage.setItem('brand_public_key', brand.public_key);
      router.push(path); // This should work
    }
  };

  // const openAddUserModel = async () => {
  //   setShowUserModal(true);
  //   const res = await axios-get(
  //    `${process.env.NEXT_PUBLIC_API_URL}/api/companies/${user.company_id}/brandnames`
  //   );
    
  //   setBrandsName(res.data);
  // };
  const openAddUserModel = async () => {
    try {
      setShowUserModal(true);
      const brandNames = await apiRequest(`/api/companies/${user.company_id}/brandnames`);
      setBrandsName(brandNames);
    } catch (error) {
      console.error('Error fetching brand names:', error);
    }
  };
  
  if (loading) {
    return <LoadingSkeletonTable/>;
  }

  if (error) {
    return <div>Error: {error}</div>;
  }

  return (
    <>
       
        <div className="container-fluid top-bar">
          <div className="left-div">
            <h2>Brands</h2>
          </div>
          <div className="right-div">
        
          </div>
        </div>
        <div className="container-fluid company-header">
          <div className="comp-header-row">
          {UserData?.canCreateBrand === 1 && (
              <button className="btn me-2" onClick={() => setShowBrandModal(true)}>
                Add Brand
              </button>
            )}
            {UserData?.canCreateUsers === 1 && (
              <button className="btn  " onClick={openAddUserModel}>
                Add User
              </button>
            )}
          </div>
        </div>
        <div className="container-fluid table-container table-responsive">
        <table className="table table-striped mt-4" cellSpacing="5" cellPadding="6">
  <thead>
    <tr>
      <th></th>
      <th>Brand </th>
      {/* <th>URL</th> */}
      <th>Domain </th>
      <th>Phone</th>
      <th>Email</th>
      {/* Conditionally render these headers based on user.role */}
      {[1, 2, 4].includes(user?.role) && (
        <>
        
          <th>Created At</th>
          <th>Status</th>
        </>
      )}
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
  {Array.isArray(brands) && brands.length > 0 ? (
    brands.map((brand) => (
      <tr key={brand.id}>
        <td className="text-center">
          <img
            src={brand?.logo || "/assets/images/dp.png"}
            width={30}
            height={30}
            alt={brand?.name || 'Brand Logo'}
            className="brand-logo-image"
            onError={(e) => (e.target.src = "/assets/images/dp.png")}
          />
        </td>
        <td>{brand?.name || 'N/A'}</td>
        <td className="text-default">
          <a href={brand?.url} target="_blank" rel="noopener noreferrer">
            {brand?.domain_name || 'N/A'}
          </a>
        </td>
        {/* <td  className="text-default">{brand?.domain_name || 'N/A'}</td> */}
        <td className="text-default">{brand?.phone || 'N/A'}</td>
        <td className="text-default">{brand?.email || 'N/A'}</td>
        {/* Conditionally render these cells based on user.role */}
        {[1, 2, 4].includes(user?.role) && (
          <>
           
            <td>{brand?.created_at ? new Date(brand.created_at).toLocaleDateString() : 'N/A'}</td>
            <td>{brand?.status === 1 ? "Active" : "Inactive"}</td>
          </>
        )}
        <td className="d-flex justify-content-around" style={{ padding: "" }}>
          <button className="btn btn-sm p-btn mt-1" onClick={() => handleViewClick(brand)}>
            View
          </button>
          {user?.canCreateUsers === 1 && (
            <Link href={`/brands/${brand?.id}/assign-user/`} prefetch={false}>
              <button className="btn btn-sm p-0 text-sm-center py-2 px-1 m-1 p-btn w-100">
                Assign User
              </button>
            </Link>
          )}
        </td>
      </tr>
    )))
    : (
      <tr>
        <td>

        No brands available
        </td>
        </tr>
    )}
  </tbody>
</table>

        </div>
    

      {/* Brand Modal */}
      {showBrandModal && (
        <div className="modal-overlay-comp">
          <div className="modal-brand">
            <div className="modal-header-comp">
              <h5 className="modal-title">Add Brand</h5>
              <button
                type="button"
                className="modal-close"
                onClick={() => setShowBrandModal(false)}
              >
                &times;
              </button>
            </div>
            <div className="modal-body">
              <form onSubmit={handleBrandSubmit}>
                <div className="form-group-row-2">
                  <div className="form-group">
                    <label htmlFor="name">Brand Name</label>
                    <input
                      className="form-control"
                      type="text"
                      id="name"
                      name="name"
                      value={brandFormData.name}
                      onChange={handleBrandInputChange}
                      required
                    />
                  </div>
                  <div className="form-group">
                    <label htmlFor="url">URL</label>
                    <input
                      type="text"
                      className="form-control"
                      id="url"
                      name="url"
                      value={brandFormData.url}
                      onChange={handleBrandInputChange}
                      required
                    />
                  </div>
                </div>
                <div className="form-group-row-2">
                  <div className="form-group">
                    <label htmlFor="domainName">Domain Name</label>
                    <span style={{fontSize:10}}> (brandname.com)</span>
                    <input
                      type="text"
                      className="form-control"
                      id="domainName"
                      name="domainName"
                      value={brandFormData.domainName}
                      onChange={handleBrandInputChange}
                      required
                    />
                  </div>
                  <div className="form-group">
                    <label htmlFor="phone">Phone</label>
                    <input
                      className="form-control"
                      type="text"
                      id="phone"
                      name="phone"
                      value={brandFormData.phone}
                      onChange={handleBrandInputChange}
                      required
                    />
                  </div>
                </div>
                <div className="form-group-row-2">
                  <div className="form-group">
                    <label htmlFor="email">Email</label>
                    <input
                      type="email"
                      className="form-control"
                      id="email"
                      name="email"
                      value={brandFormData.email}
                      onChange={handleBrandInputChange}
                      required
                    />
                  </div>
                  <div className="form-group">
                    <label htmlFor="timeZone">Time Zone</label>
                    <select
                      className="form-control"
                      id="timeZone"
                      name="timeZone"
                      value={brandFormData.timeZone || "US/Pacific"}
                      onChange={handleBrandInputChange}
                      required
                    >
                      <option value="">Select a Time Zone</option>
                      {timezones.map((tz) => (
                        <option key={tz.zone} value={tz.zone}>
                          {tz.gmt + "  " + tz.zone}
                        </option>
                      ))}
                    </select>
                  </div>
                </div>
                <div className="form-group">
                  <label htmlFor="statusId">Status</label>
                  <select
                    className="form-control"
                    id="statusId"
                    name="statusId"
                    value={brandFormData.statusId}
                    onChange={handleBrandInputChange}
                  >
                    <option value={1}>Active</option>
                    <option value={0}>Inactive</option>
                  </select>
                </div>
                <div className="form-group">
            <label>Brand Logo</label>
            <div className='brand-logo-container'>
              <div className="form-check">
                <input
                  type="radio"
                  id="uploadFromDevice"
                  name="logoOption"
                  value="upload"
                  checked={logoOption === "upload"}
                  onChange={() => setLogoOption("upload")}
                />
                <label htmlFor="uploadFromDevice" className="form-check-label">
                  Upload from Device
                </label>
              </div>
              <div className="form-check">
                <input
                  type="radio"
                  id="uploadFromUrl"
                  name="logoOption"
                  value="url"
                  checked={logoOption === "url"}
                  onChange={() => setLogoOption("url")}
                />
                <label htmlFor="uploadFromUrl" className="form-check-label">
                  Provide a URL
                </label>
              </div>
            </div>
            {logoOption === "upload" && (
              <input
                className="form-control mt-2"
                type="file"
                id="logoFile"
                name="logoFile"
                onChange={handleBrandFileChange}
                required={logoOption === "upload"}
              />
            )}
            {logoOption === "url" && (
              <input
                className="form-control mt-2"
                type="url"
                id="logoUrl"
                name="logoUrl"
                value={brandFormData.logoUrl || ""}
                onChange={handleBrandInputChange}
                placeholder="Enter image URL"
                required={logoOption === "url"}
              />
            )}
          </div>
                <button
                  type="submit"
                  className="btn submit-btn p-btn mt-3 w-100"
                >
                  Add Brand
                </button>
              </form>
            </div>
          </div>
        </div>
      )}

      {/* User Modal */}
      {showUserModal && (
        <div className="modal-overlay-comp">
          <div className="modal-brand">
            <div className="modal-header-comp">
              <h5 className="modal-title ">Add User</h5>
              <button
                type="button"
                className="modal-close"
                onClick={() => setShowUserModal(false)}
              >
                &times;
              </button>
            </div>
            <div className="modal-body">
              <form onSubmit={handleUserSubmit}>
                <div className="form-group-row-2">
                  <div className="form-group">
                    <label htmlFor="name">Real Name</label>
                    <input
                      className="form-control"
                      type="text"
                      id="name"
                      name="name"
                      value={userFormData.name}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                  <div className="form-group">
                    <label htmlFor="pseudonym">Pseudonym</label>
                    <input
                      type="text"
                      className="form-control"
                      id="pseudonym"
                      name="pseudonym"
                      value={userFormData.pseudonym}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                </div>
                <div className="form-group-row-2">
                  <div className="form-group">
                    <label htmlFor="email">Email</label>
                    <input
                      type="email"
                      className="form-control"
                      id="email"
                      name="email"
                      value={userFormData.email}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                  <div className="form-group">
                    <label htmlFor="password">Password</label>
                    <input
                      className="form-control"
                      type="password"
                      id="password"
                      name="password"
                      value={userFormData.password}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                </div>
                <div className="form-group-row-2">

                
                <div className="form-group">
                    <label htmlFor="designation">HRM ID:</label>
                    <input
                      type="text"
                      className="form-control"
                      id="hrm_id"
                      name="hrm_id"
                      value={userFormData.hrm_id}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                <div className="form-group">
                    <label htmlFor="designation">Designation:</label>
                    <input
                      type="text"
                      className="form-control"
                      id="designation"
                      name="designation"
                      value={userFormData.designation}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                  </div>
                  <div className="form-group-row-2">
                  <div className="form-group flex-1">
                  <label htmlFor="status">Status</label>
                  <select
                    className="form-control"
                    id="status"
                    name="status"
                    value={userFormData.status}
                    onChange={handleUserInputChange}
                    required
                  >
                    <option value={1}>Active</option>
                    <option value={0}>Inactive</option>
                  </select>
                </div>
                <div className="form-group flex-1">
                  <label htmlFor="role">Role</label>
                  <select
                    className="form-control"
                    id="role"
                    name="role"
                    value={userFormData.role}
                    onChange={handleUserInputChange}
                    required
                  >
                    <option value={2}>Admin</option>
                    <option value={3} selected>Sales</option>
                    <option value={4}>Marketing</option>
                    {/* <option value="client">Client</option> */}
                  </select>
                </div>
                  </div>
                  <div className="form-group-row-2">
                <div className="form-group flex-1">
                  <label htmlFor="canCreateUsers">Can Create Users</label>
                  <select
                    className="form-control"
                    id="canCreateUsers"
                    name="canCreateUsers"
                    value={userFormData.canCreateUsers}
                    onChange={handleUserInputChange}
                    required
                  >
                    <option value={0}>No</option>
                    <option value={1}>Yes</option>
                  </select>
                </div>
                <div className="form-group flex-1">
                  <label htmlFor="canCreateBrand">Can Create Brand</label>
                  <select
                    className="form-control"
                    id="canCreateBrand"
                    name="canCreateBrand"
                    value={userFormData.canCreateBrand}
                    onChange={handleUserInputChange}
                    required
                  >
                    <option value={0}>No</option>
                    <option value={1}>Yes</option>
                  </select>
                </div>

                  </div>
                <button
                  type="submit"
                  className="btn submit-btn p-btn mt-3 w-100"
                >
                  Add User
                </button>
              </form>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default BrandsPage;
