import React, { useState, useEffect } from "react";
 
import axios from "axios";
import { getCookie } from "cookies-next";
import { setSelectedBrands, toggleBrandSelection } from "@/app/lib/features/chat/selectedBrandsSlice";
import { useDispatch, useSelector } from 'react-redux';
const FilterChats = ({ onClose,brands,setBrands,filteredBrands,setFilteredBrands}) => {
 

  const dispatch = useDispatch();
  const selectedBrands = useSelector((state) => state.selectedBrands.selectedBrands);
  const [searchTerm, setSearchTerm] = useState("");
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);

 

 

//   const toggleBrandSelection = (public_key) => {
//     
//     
//     // Toggle the selection for the brand based on the public_key
//     setSelectedBrands((prevSelected) => {
//         if (prevSelected.includes(public_key)) {
//             // If brand is already selected, remove it
//             return prevSelected.filter((key) => key !== public_key);
//         } else {
//             // If brand is not selected, add it
//             return [...prevSelected, public_key];
//         }
//     });
//     
  
//     // Toggle the 'selected' property for the associated visitors based on the public_key
//     setFilteredVisitors((prevFiltered) =>
//       prevFiltered.map((visitor) =>
//         visitor.public_key === public_key
//           ? { ...visitor, selected: !visitor.selected } // Toggle the 'selected' state of the visitor
//           : visitor // Return visitor as is if public_key doesn't match
//       )
//     );
//   };
  

  const handleSearchChange = (e) => {
    setSearchTerm(e.target.value);
    const filtered = brands.filter((brand) =>
      brand.name.toLowerCase().includes(e.target.value.toLowerCase())
    );
    setFilteredBrands(filtered);
  };

  const handleToggleSelection = (public_key) => {
    dispatch(toggleBrandSelection(public_key)); // This will toggle the brand selection
  };

//   const handleSelectAll = () => {
//     setSelectedBrands(filteredBrands.map((brand) => brand.public_key));
//   };

//   const handleUnselectAll = () => {
//     setSelectedBrands([]);
//   };
  const handleSelectAll = () => {
    const allPublicKeys = brands.map((brand) => brand.public_key);
    dispatch(setSelectedBrands(allPublicKeys)); // Set all brands as selected
  };

  const handleUnselectAll = () => {
    dispatch(setSelectedBrands([])); // Unselect all brands
  };

  if (loading) {
    return <div className="loading">Loading...</div>;
  }

  if (error) {
    return <div className="error">{error}</div>;
  }

  return (
    <div className="chat-filter-box">
      <div className="chat-filter-container">
        <div className="header-chat-filter">
        <h2>Select Brands to Filter</h2>


        <div className="chat-filter-actions">
          <button className="btn select-all-btn" onClick={handleSelectAll}>
            Select All
          </button>
          <button className="btn unselect-all-btn" onClick={handleUnselectAll}>
            Unselect All
          </button>
        </div>
        </div>

        <div className="chat-filter-search">
          <input
            type="text"
            className="search-input"
            placeholder="Search brands..."
            value={searchTerm}
            onChange={handleSearchChange}
          />
        </div>

        <div className="chat-filter-grid">
          {filteredBrands.map((brand) => (
            <div
              key={brand.id}
              className={`chat-filter-item ${
                selectedBrands.includes(brand.public_key) ? "selected" : ""
              }`}
              onClick={() => handleToggleSelection(brand.public_key)}
            >
              <img
                src={brand.logo || "/default-logo.png"}
                alt={brand.name}
                className="brand-logo"
              />
              <p className="brand-name">{brand.name}</p>
            </div>
          ))}
        </div>
      </div>

      <button type="submit" className="btn done-btn" onClick={onClose}>
        Done
      </button>
    </div>
  );
};

export default FilterChats;
